<?php if (!defined('ABSPATH')) die('Direct access forbidden.');

$options = [
    
    'featured_upload_img' => [
        'label'	        => esc_html__( 'upload feature image', 'vinkmag' ),
        'desc'	        => esc_html__( 'This will be used as the image', 'vinkmag' ),
        'type'	        => 'upload',
    ],

    'block_highlight_color' => [
        'label'	        => esc_html__( 'Highlight color', 'vinkmag' ),
        'desc'	        => esc_html__( 'This will be used as the primary color for this category', 'vinkmag' ),
        'type'	        => 'color-picker',
        'value'         => '#d72924',
    ],
    'block_secondary_color' => [
        'label'	        => esc_html__( 'Text color', 'vinkmag' ),
        'desc'	        => esc_html__( 'Choose a color that is easily readable within the highlight color background.', 'vinkmag' ),
        'type'	        => 'color-picker',
        'value'         => '#ffffff',
    ],
    'override_default'	 => [
        'type'	 => 'switch',
        'value'	 => 'no',
        'label'	 => esc_html__( 'Override default layouts?', 'vinkmag' ),
        'desc'	 => esc_html__( 'You can change the default options from customizer\'s "Blog settings".', 'vinkmag' ),
        'left-choice' => [
            'value' => 'yes',
            'label' => esc_html__( 'Yes', 'vinkmag' ),
        ],
        'right-choice' => [
            'value' => 'no',
            'label' => esc_html__( 'No', 'vinkmag' ),
        ],
    ],
    'block_style_body_bg' => [
        'label'	        => esc_html__( 'Body background', 'vinkmag' ),
        'desc'	        => esc_html__( 'Site\'s main background color.', 'vinkmag' ),
        'type'	        => 'color-picker',
        'value'         => '#f0f1f4',
     ],
     'style_box_shadow' => [
        'type'			 => 'switch',
        'label'			 => esc_html__( 'Box sadow?', 'vinkmag' ),
        'desc'			 => esc_html__( 'Do you want to use box shadow on post blocks?', 'vinkmag' ),
        'value'          => 'yes',
        'left-choice'	 => [
            'value'	 => 'yes',
            'label'	 => esc_html__( 'Yes', 'vinkmag' ),
        ],
        'right-choice'	 => [
            'value'	 => 'no',
            'label'	 => esc_html__( 'No', 'vinkmag' ),
        ],
    ],

  

    'block_category_template' => [
        'label'	        => esc_html__( 'Category template', 'vinkmag' ),
        'desc'	        => esc_html__( 'Post block style in category pages.', 'vinkmag' ),
        'type'	        => 'image-picker',
        'choices'       => [
            'style1'    => [
                'small'     => VINKMAG_IMG . '/admin/category-main-layout/min-style1.png',
                'large'     => VINKMAG_IMG . '/admin/category-main-layout/style1.png',
            ],
            'style2'    => [
                'small'     => VINKMAG_IMG . '/admin/category-main-layout/min-style2.png',
                'large'     => VINKMAG_IMG . '/admin/category-main-layout/style2.png',
            ],
            'style3'    => [
                'small'     => VINKMAG_IMG . '/admin/category-main-layout/min-style3.png',
                'large'     => VINKMAG_IMG . '/admin/category-main-layout/style3.png',
            ],
            'style4'    => [
                'small'     => VINKMAG_IMG . '/admin/category-main-layout/min-style4.png',
                'large'     => VINKMAG_IMG . '/admin/category-main-layout/style4.png',
            ],
            'style5'    => [
                'small'     => VINKMAG_IMG . '/admin/category-main-layout/min-style5.png',
                'large'     => VINKMAG_IMG . '/admin/category-main-layout/style5.png',
            ],
            'style6'    => [
                'small'     => VINKMAG_IMG . '/admin/category-main-layout/min-style6.png',
                'large'     => VINKMAG_IMG . '/admin/category-main-layout/style6.png',
            ],
            'style7'    => [
                'small'     => VINKMAG_IMG . '/admin/category-main-layout/min-style6.png',
                'large'     => VINKMAG_IMG . '/admin/category-main-layout/style6.png',
            ],
        ],
        'value'         => 'style1',
     ],
    
    'block_featured_post'      => [
        'type'    => 'multi-picker',
        'picker'  => [
            'block_featured_post_show'      => [
                'type'  => 'switch',
                'value' => 'yes',
                'label' => esc_html__('Show featured posts', 'vinkmag'),
                'desc'  => esc_html__('Show or hide featured posts in category\'s top section', 'vinkmag'),
                'left-choice' => [
                    'value' => 'yes',
                    'label' => esc_html__( 'Yes', 'vinkmag' ),
                ],
                'right-choice' => [
                    'value' => 'no',
                    'label' => esc_html__( 'No', 'vinkmag' ),
                ],
            ],
        ],
        'choices' => [
            'yes' => [
                'block_featured_post_layout' => [
                    'label'	        => esc_html__( 'Featured post style', 'vinkmag' ),
                    'desc'	        => esc_html__( 'Featured post style in category pages.', 'vinkmag' ),
                    'type'	        => 'image-picker',
                    'choices'       => [
                        'style1'    => [
                            'small'     => VINKMAG_IMG . '/admin/category-header-layout/min-style1.png',
                            'large'     => VINKMAG_IMG . '/admin/category-header-layout/style1.png',
                        ],
                        'style2'    => [
                            'small'     => VINKMAG_IMG . '/admin/category-header-layout/min-style2.png',
                            'large'     => VINKMAG_IMG . '/admin/category-header-layout/style2.png',
                        ],
                    ],
                    'value'         => 'style1',
                ],
            ]
        ]
    ],
    'block_sidebar_layout' => [
        'label'	        => esc_html__( 'Category sidebar layout', 'vinkmag' ),
        'desc'	        => esc_html__( 'The sidebar position of a blog category.', 'vinkmag' ),
        'type'	        => 'image-picker',
        'choices'       => [
            'sidebar-right'    => [
                'small'     => VINKMAG_IMG . '/admin/category-sidebar-layout/min-sidebar-right.png',
                'large'     => VINKMAG_IMG . '/admin/category-sidebar-layout/sidebar-right.png',
            ],
            'sidebar-none'    => [
                'small'     => VINKMAG_IMG . '/admin/category-sidebar-layout/min-sidebar-none.png',
                'large'     => VINKMAG_IMG . '/admin/category-sidebar-layout/sidebar-none.png',
            ]
        ],
        'value'         => 'sidebar-right',
     ],
    'block_pagination_alignment'      => [
        'type'  => 'radio',
        'value' => 'center',
        'label' => esc_html__('Pagination alignment', 'vinkmag'),
        'desc'  => esc_html__('Pagination alignment in blog category page.', 'vinkmag'),
        'choices' => [
            'left' => esc_html__('Left', 'vinkmag'),
            'center' => esc_html__('Center', 'vinkmag'),
            'right' => esc_html__('Right', 'vinkmag'),
        ],
        'inline' => true,
    ],
    'block_crop_desc'      => [
        'type'    => 'multi-picker',
        'picker'  => [
            'block_crop_desc_switch'      => [
                'type'  => 'switch',
                'value' => 'no',
                'label' => esc_html__('Custom post word length', 'vinkmag'),
                'desc'  => esc_html__('Enable disable custom post word length.', 'vinkmag'),
                'left-choice' => [
                    'value' => 'yes',
                    'label' => esc_html__( 'Yes', 'vinkmag' ),
                ],
                'right-choice' => [
                    'value' => 'no',
                    'label' => esc_html__( 'No', 'vinkmag' ),
                ],
            ],
        ],
        'choices' => [
            'yes' => [
                'block_crop_desc_limit'	 => [
                    'type'	 => 'text',
                    'label'	 => esc_html__( 'Post word limit.', 'vinkmag' ),
                    'desc'  => esc_html__('Post word limit, example: 100', 'vinkmag'),
                    'value'  => 35
                ],
            ]
        ]
    ], //
];