<?php if (!defined('ABSPATH')) die('Direct access forbidden.');
/**
 * customizer option: general
 */
$options =[
    'general_settings' => [
            'title'		 => esc_html__( 'General settings', 'vinkmag' ),
            'options'	 => [
                'general_main_logo' => [
                    'label'	        => esc_html__( 'Dark logo', 'vinkmag' ),
                    'desc'	        => esc_html__( 'It\'s the main logo, mostly it will be shown on "light background" type area.', 'vinkmag' ),
                    'type'	        => 'upload',
                    'image_only'    => true,
                 ],
                'general_light_logo' => [
                    'label'	        => esc_html__( 'Light logo', 'vinkmag' ),
                    'desc'	        => esc_html__( 'It will be shown on any "dark or coloreful" type area.', 'vinkmag' ),
                    'type'	        => 'upload',
                    'image_only'    => true,
                 ],
                 'general_sticky_sidebar' => [
                    'type'			 => 'switch',
                    'label'			 => esc_html__( 'Sticky sidebar', 'vinkmag' ),
                    'desc'			 => esc_html__( 'Use sticky sidebar?', 'vinkmag' ),
                    'value'          => 'yes',
                    'left-choice' => [
                        'value'	 => 'yes',
                        'label'	 => esc_html__( 'Yes', 'vinkmag' ),
                    ],
                    'right-choice' => [
                        'value'	 => 'no',
                        'label'	 => esc_html__( 'No', 'vinkmag' ),
                    ],
               ],
               'blog_breadcrumb_show' => [
                    'type'			 => 'switch',
                    'label'			 => esc_html__( 'Breadcrumb', 'vinkmag' ),
                    'desc'			 => esc_html__( 'Do you want to show breadcrumb?', 'vinkmag' ),
                    'value'          => 'yes',
                    'left-choice'	 => [
                        'value'	 => 'yes',
                        'label'	 => esc_html__('Yes', 'vinkmag'),
                    ],
                    'right-choice'	 => [
                        'value'	 => 'no',
                        'label'	 => esc_html__('No', 'vinkmag'),
                    ],
                ],
                'blog_breadcrumb_length' => [
                    'type'			 => 'text',
                    'label'			 => esc_html__( 'Breadcrumb word length', 'vinkmag' ),
                    'desc'			 => esc_html__( 'The length of the breadcumb text.', 'vinkmag' ),
                    'value'          => '3',
                ],
                'general_social_links' => [
                    'type'  => 'addable-popup',
                    'template' => '{{- title }}',
                    'popup-title' => null,
                    'label' => esc_html__( 'Social links', 'vinkmag' ),
                    'desc'  => esc_html__( 'Add social links and it\'s icon class bellow. These are all fontaweseome-4.7 icons.', 'vinkmag' ),
                    'add-button-text' => esc_html__( 'Add new', 'vinkmag' ),
                    'popup-options' => [
                        'title' => [ 
                            'type' => 'text',
                            'label'=> esc_html__( 'Title', 'vinkmag' ),
                        ],
                        'icon_class' => [ 
                            'type' => 'icon',
                            'label'=> esc_html__( 'Social icon', 'vinkmag' ),
                        ],
                        'url' => [ 
                            'type' => 'text',
                            'label'=> esc_html__( 'Social link', 'vinkmag' ),
                        ],
                    ],

                ],
            ],
        ],
    ];