<?php if (!defined('ABSPATH')) die('Direct access forbidden.');
/**
 * customizer option: general
 */
$options =[
    'blocks_settings' => [
            'title'		 => esc_html__( 'Post blocks & listing settings', 'vinkmag' ),
            'options'	 => [
                'block_category_template' => [
                    'label'	        => esc_html__( 'Category template', 'vinkmag' ),
                    'desc'	        => esc_html__( 'Post block style in category pages.', 'vinkmag' ),
                    'type'	        => 'image-picker',
                    'choices'       => [
                        'style1'    => [
                            'small'     => VINKMAG_IMG . '/admin/category-main-layout/min-style1.png',
                            'large'     => VINKMAG_IMG . '/admin/category-main-layout/style1.png',
                        ],
                        'style2'    => [
                            'small'     => VINKMAG_IMG . '/admin/category-main-layout/min-style2.png',
                            'large'     => VINKMAG_IMG . '/admin/category-main-layout/style2.png',
                        ],
                        'style3'    => [
                            'small'     => VINKMAG_IMG . '/admin/category-main-layout/min-style3.png',
                            'large'     => VINKMAG_IMG . '/admin/category-main-layout/style3.png',
                        ],
                        'style4'    => [
                            'small'     => VINKMAG_IMG . '/admin/category-main-layout/min-style4.png',
                            'large'     => VINKMAG_IMG . '/admin/category-main-layout/style4.png',
                        ],
                        'style5'    => [
                            'small'     => VINKMAG_IMG . '/admin/category-main-layout/min-style5.png',
                            'large'     => VINKMAG_IMG . '/admin/category-main-layout/style5.png',
                        ],
                        'style6'    => [
                            'small'     => VINKMAG_IMG . '/admin/category-main-layout/min-style6.png',
                            'large'     => VINKMAG_IMG . '/admin/category-main-layout/style6.png',
                        ],
                        'style7'    => [
                            'small'     => VINKMAG_IMG . '/admin/category-main-layout/min-style6.png',
                            'large'     => VINKMAG_IMG . '/admin/category-main-layout/style6.png',
                        ],
                  
                    ],
                    'value'         => 'style-default',
                 ],

                 'featured_categories'      => [
                    'type'  => 'text',
                    'label' => esc_html__('Featured categories (for layout style 7)', 'vinkmag'),
                    'desc'  => esc_html__('Use category\'s slug, seperated by comma.', 'vinkmag'),
               
                ],

                'block_featured_post'      => [
                    'type'    => 'multi-picker',
                    'picker'  => [
                        'block_featured_post_show'      => [
                            'type'  => 'switch',
                            'value' => 'yes',
                            'label' => esc_html__('Show featured posts', 'vinkmag'),
                            'desc'  => esc_html__('Show or hide featured posts in category\'s top section', 'vinkmag'),
                            'left-choice' => [
                                'value' => 'yes',
                                'label' => esc_html__( 'Yes', 'vinkmag' ),
                            ],
                            'right-choice' => [
                                'value' => 'no',
                                'label' => esc_html__( 'No', 'vinkmag' ),
                            ],
                        ],
                    ],
                    'choices' => [
                        'yes' => [
                            'block_featured_post_layout' => [
                                'label'	        => esc_html__( 'Featured post style', 'vinkmag' ),
                                'desc'	        => esc_html__( 'Featured post style in category pages.', 'vinkmag' ),
                                'type'	        => 'image-picker',
                                'choices'       => [
                                    'style1'    => [
                                        'small'     => VINKMAG_IMG . '/admin/category-header-layout/min-style1.png',
                                        'large'     => VINKMAG_IMG . '/admin/category-header-layout/style1.png',
                                    ],
                                    'style2'    => [
                                        'small'     => VINKMAG_IMG . '/admin/category-header-layout/min-style2.png',
                                        'large'     => VINKMAG_IMG . '/admin/category-header-layout/style2.png',
                                    ],
                                ],
                                'value'         => 'style1',
                            ],
                        ]
                    ]
                ],

            


                'block_sidebar_layout' => [
                    'label'	        => esc_html__( 'Category sidebar layout', 'vinkmag' ),
                    'desc'	        => esc_html__( 'The sidebar position of a blog category.', 'vinkmag' ),
                    'type'	        => 'image-picker',
                    'choices'       => [
                        'sidebar-right'    => [
                            'small'     => VINKMAG_IMG . '/admin/category-sidebar-layout/min-sidebar-right.png',
                            'large'     => VINKMAG_IMG . '/admin/category-sidebar-layout/sidebar-right.png',
                        ],
                        'sidebar-none'    => [
                            'small'     => VINKMAG_IMG . '/admin/category-sidebar-layout/min-sidebar-none.png',
                            'large'     => VINKMAG_IMG . '/admin/category-sidebar-layout/sidebar-none.png',
                        ]
                    ],
                    'value'         => 'sidebar-right',
                 ],
                'block_pagination_alignment'      => [
                    'type'  => 'radio',
                    'value' => 'center',
                    'label' => esc_html__('Pagination alignment', 'vinkmag'),
                    'desc'  => esc_html__('Pagination alignment in blog category page.', 'vinkmag'),
                    'choices' => [
                        'left' => esc_html__('Left', 'vinkmag'),
                        'center' => esc_html__('Center', 'vinkmag'),
                        'right' => esc_html__('Right', 'vinkmag'),
                    ],
                    'inline' => true,
                ],
                'block_crop_desc'      => [
                    'type'    => 'multi-picker',
                    'picker'  => [
                        'block_crop_desc_switch'      => [
                            'type'  => 'switch',
                            'value' => 'no',
                            'label' => esc_html__('Custom post word length', 'vinkmag'),
                            'desc'  => esc_html__('Enable disable custom post word length.', 'vinkmag'),
                            'left-choice' => [
                                'value' => 'yes',
                                'label' => esc_html__( 'Yes', 'vinkmag' ),
                            ],
                            'right-choice' => [
                                'value' => 'no',
                                'label' => esc_html__( 'No', 'vinkmag' ),
                            ],
                        ],
                    ],
                    'choices' => [
                        'yes' => [
                            'block_crop_desc_limit'	 => [
                                'type'	 => 'text',
                                'label'	 => esc_html__( 'Post word limit.', 'vinkmag' ),
                                'desc'  => esc_html__('Post word limit, example: 100', 'vinkmag'),
                                'value'  => 35
                            ],
                        ]
                    ]
                ], //
            ],
        ],
    ];