<?php

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit;

class Vinkmag_Video_Post_Tab_Widget extends Widget_Base {

  public $base;

    public function get_name() {
        return 'vinazine-video-post-tab';
    }

    public function get_title() {
        return esc_html__( 'Video Post Tab', 'vinkmag' );
    }

    public function get_icon() { 
        return 'eicon-thumbnails-right';
    }

    public function get_categories() {
        return [ 'vinkmag-elements' ];
    }

    protected function _register_controls() {

        $this->start_controls_section(
            'section_tab',
            [
                'label' => esc_html__('Post', 'vinkmag'),
            ]
        );
        $this->add_control(
            'section_title',
            [
                'label' => esc_html__('Block Title', 'vinkmag'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__( 'Post Slider', 'vinkmag' )
            ]
        );
        $this->add_control(
          'post_count',
          [
            'label'         => esc_html__( 'Post count', 'vinkmag' ),
            'type'          => Controls_Manager::NUMBER,
            'default'       => '8',
          ]
        );
        $this->add_control(
          'post_title_crop',
          [
            'label'         => esc_html__( 'Post title crop', 'vinkmag' ),
            'type'          => Controls_Manager::NUMBER,
            'default'       => '50',
          ]
        );
        
        $this->add_control(
            'post_cats',
            [
                'label' =>esc_html__('Select Categories', 'vinkmag'),
                'type'      => Vinkmag_Custom_Controls_Manager::AJAXSELECT2,
                'options'   =>'category',
                'label_block' => true,
                'multiple'  => true,
            ]
        );
        $this->add_control(
            'show_date',
            [
                'label' => esc_html__('Show Date', 'vinkmag'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Yes', 'vinkmag'),
                'label_off' => esc_html__('No', 'vinkmag'),
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'show_cat',
            [
                'label' => esc_html__('Show Category', 'vinkmag'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Yes', 'vinkmag'),
                'label_off' => esc_html__('No', 'vinkmag'),
                'default' => 'yes',
            ]
        );
        $this->add_control(
            'post_sortby',
            [
                'label'     =>esc_html__( 'Post sort by', 'vinkmag' ),
                'type'      => Controls_Manager::SELECT,
                'default'   => 'latestpost',
                'options'   => [
                        'latestpost'      =>esc_html__( 'Latest posts', 'vinkmag' ),
                        'popularposts'    =>esc_html__( 'Popular posts', 'vinkmag' ),
                        'mostdiscussed'    =>esc_html__( 'Most discussed', 'vinkmag' ),
                    ],
            ]
        );
        $this->add_control(
            'post_order',
            [
                'label'     =>esc_html__( 'Post order', 'vinkmag' ),
                'type'      => Controls_Manager::SELECT,
                'default'   => 'DESC',
                'options'   => [
                        'DESC'      =>esc_html__( 'Descending', 'vinkmag' ),
                        'ASC'       =>esc_html__( 'Ascending', 'vinkmag' ),
                    ],
            ]
        );

        $this->end_controls_section();
    }

    protected function render( ) { 
        $settings = $this->get_settings();
        $thumb 					= [600, 398];
        $arg = [
            'post_type'   =>  'post',
            'post_status' => 'publish',
            'order' => $settings['post_order'],
            'posts_per_page' => $settings['post_count'],
            'category__in' => $settings['post_cats'],
            'tax_query' => [
                [
                    'taxonomy' => 'post_format',
                    'field' => 'slug',
                    'terms' => 'post-format-video'
                ]
            ]
        ];


        switch($settings['post_sortby']){
         case 'popularposts':
             $arg['meta_key'] = 'vinkmag_post_views_count';
             $arg['orderby'] = 'meta_value_num';
         break;
         case 'mostdiscussed':
             $arg['orderby'] = 'comment_count';
         break;
         default:
             $arg['orderby'] = 'date';
         break;
     }
        $settings['show_author'] = 'no';
        $query = new \WP_Query( $arg ); ?>
        
        <?php if ( $query->have_posts() ) : ?>
            <div class="row">
                <div class="col-lg-8 pr-0">
                    <div class="tab-content clearfix">
                        <?php $i = 0; while ($query->have_posts()) : $query->the_post(); $i++; ?>
                            <div class="tab-pane fade <?php echo esc_attr(($i == 1) ? 'in active' : ''); ?>" id="video-tab-<?php echo esc_attr($this->get_id()); ?>-<?php echo esc_attr($i); ?>">
                                <div class="video-item" style="background-image: url(<?php echo esc_url(vinkmag_post_thumbnail(get_the_ID(), $thumb[0], $thumb[1])); ?>)">
                                    <?php require VINKMAG_THEME_DIR . '/template-parts/blogs/contents/content-style3-d.php'; ?>
                                </div>
                            </div>
                        <?php endwhile; 
                        wp_reset_query(); ?>
                    </div>
                </div>
                
                <div class="col-lg-4 pl-0">
                    <div class="video-tab-list bg-dark-item video-tab-scrollbar" id="video-tab-scrollbar">
                        <ul class="nav nav-pills post-tab-list">
                        <?php $i = 0; while ($query->have_posts()) : $query->the_post(); $i++; ?>
                            <li class="<?php echo esc_attr(($i == 1) ? 'active' : ''); ?>">
                                <a href="#video-tab-<?php echo esc_attr($this->get_id()); ?>-<?php echo esc_attr($i); ?>" data-toggle="tab">
                                    <div class="post-content media">
                                        <img class="d-flex sidebar-img" src="<?php echo esc_url(vinkmag_post_thumbnail(get_the_ID())); ?>" alt="<?php echo esc_attr(vinkmag_alt(get_the_ID())); ?>">
                                        <div class="media-body align-self-center">
                                            <h4 class="post-title">
                                                <?php the_title(); ?>
                                            </h4>
                                        </div>
                                    </div>
                                </a>
                            </li>
                        <?php endwhile; ?>
                        </ul>
                    </div>
                </div>
            </div>
        <?php endif; ?>

      <?php  
    }
    protected function _content_template() { }
}