<?php

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit;

class Vinkmag_Video_Post_Slider_Widget extends Widget_Base {

  public $base;

    public function get_name() {
        return 'vinazine-video-post-slider';
    }

    public function get_title() {
        return esc_html__( 'Video Post Slider', 'vinkmag' );
    }

    public function get_icon() { 
        return 'eicon-slider-video';
    }

    public function get_categories() {
        return [ 'vinkmag-elements' ];
    }

    protected function _register_controls() {

        $this->start_controls_section(
            'section_tab',
            [
                'label' => esc_html__('Post', 'vinkmag'),
            ]
        );

        $this->add_control(
          'post_count',
          [
            'label'         => esc_html__( 'Post count', 'vinkmag' ),
            'type'          => Controls_Manager::NUMBER,
            'default'       => '8',
          ]
        );
        $this->add_control(
          'post_title_crop',
          [
            'label'         => esc_html__( 'Post title crop', 'vinkmag' ),
            'type'          => Controls_Manager::NUMBER,
            'default'       => '50',
          ]
        );

        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'content_typography',
				'label' => esc_html__( 'Typography', 'vinkmag' ),
				'scheme' => Scheme_Typography::TYPOGRAPHY_1,
				'selector' => '{{WRAPPER}} .vinkmag-video-slider-item h3',
			]
		);



        $this->add_responsive_control(
			'thumbnail_height',
			[
				'label' =>esc_html__( 'Thumbnail Height', 'vinkmag' ),
                'type' => \Elementor\Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000,
					],
				],
				'devices' => [ 'desktop', 'tablet', 'mobile' ],
				'desktop_default' => [
					'size' => 300,
					'unit' => 'px',
				],
				'tablet_default' => [
					'size' => 250,
					'unit' => 'px',
				],
				'mobile_default' => [
					'size' => 250,
					'unit' => 'px',
				],
				'selectors' => [
					'{{WRAPPER}} .post-video .item' => 'min-height: {{SIZE}}{{UNIT}};',
                ],
         
			]
      );

        $this->add_control(
            'post_cats',
            [
                'label' =>esc_html__('Select Categories', 'vinkmag'),
                'type'      => Vinkmag_Custom_Controls_Manager::AJAXSELECT2,
                'options'   =>'category',
                'label_block' => true,
                'multiple'  => true,
            ]
        );
        $this->add_control(
            'show_date',
            [
                'label' => esc_html__('Show Date', 'vinkmag'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Yes', 'vinkmag'),
                'label_off' => esc_html__('No', 'vinkmag'),
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'show_cat',
            [
                'label' => esc_html__('Show Category', 'vinkmag'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Yes', 'vinkmag'),
                'label_off' => esc_html__('No', 'vinkmag'),
                'default' => 'yes',
            ]
        );
        $this->add_control(
         'show_author',
               [
                  'label' => esc_html__('Show Author', 'vinkmag'),
                  'type' => Controls_Manager::SWITCHER,
                  'label_on' => esc_html__('Yes', 'vinkmag'),
                  'label_off' => esc_html__('No', 'vinkmag'),
                  'default' => 'no',
               ]
         );

         $this->add_control(
               'show_author_image',
               [
                  'label' => esc_html__('Show Author Image', 'vinkmag'),
                  'type' => Controls_Manager::SWITCHER,
                  'label_on' => esc_html__('Yes', 'vinkmag'),
                  'label_off' => esc_html__('No', 'vinkmag'),
                  'default' => 'no',
               ]
         );

        $this->add_control(
         'show_view_count',
         [
             'label' => esc_html__('Show view Count', 'vinkmag'),
             'type' => Controls_Manager::SWITCHER,
             'label_on' => esc_html__('Yes', 'vinkmag'),
             'label_off' => esc_html__('No', 'vinkmag'),
             'default' => 'no',
         ]
       );

        $this->add_control(
            'post_sortby',
            [
                'label'     =>esc_html__( 'Post sort by', 'vinkmag' ),
                'type'      => Controls_Manager::SELECT,
                'default'   => 'latestpost',
                'options'   => [
                        'latestpost'      =>esc_html__( 'Latest posts', 'vinkmag' ),
                        'popularposts'    =>esc_html__( 'Popular posts', 'vinkmag' ),
                        'mostdiscussed'    =>esc_html__( 'Most discussed', 'vinkmag' ),
                    ],
            ]
        );
        $this->add_control(
            'post_order',
            [
                'label'     =>esc_html__( 'Post order', 'vinkmag' ),
                'type'      => Controls_Manager::SELECT,
                'default'   => 'DESC',
                'options'   => [
                        'DESC'      =>esc_html__( 'Descending', 'vinkmag' ),
                        'ASC'       =>esc_html__( 'Ascending', 'vinkmag' ),
                    ],
            ]
        );

        $this->end_controls_section();
    }

    protected function render( ) { 
        $settings = $this->get_settings();
        
        $arg = [
            'post_type'   =>  'post',
            'post_status' => 'publish',
            'order' => $settings['post_order'],
            'posts_per_page' => $settings['post_count'],
            'category__in' => $settings['post_cats'],
            'tax_query' => [
                [
                    'taxonomy' => 'post_format',
                    'field' => 'slug',
                    'terms' => 'post-format-video'
                ]
            ]
        ];

        switch($settings['post_sortby']){
         case 'popularposts':
             $arg['meta_key'] = 'vinkmag_post_views_count';
             $arg['orderby'] = 'meta_value_num';
         break;
         case 'mostdiscussed':
             $arg['orderby'] = 'comment_count';
         break;
         default:
             $arg['orderby'] = 'date';
         break;
     }
        $query = new \WP_Query( $arg ); ?>
        
        <?php if ( $query->have_posts() ) : ?>
            <div class="video-slider owl-carousel owl-theme featured-post">
                    <?php $i = 0; while ($query->have_posts()) : $query->the_post(); $i++; 
                        $video_url         =    vinkmag_post_option( get_the_ID(), 'featured_video' );
                    ?>

                        <div class="vinkmag-video-slider-item">
                            <?php require VINKMAG_THEME_DIR . '/template-parts/blogs/contents/content-style3-c.php'; ?>
                        </div>
                    <?php endwhile;
                    wp_reset_query(); ?>
            </div>
        <?php endif; ?>

      <?php  
    }
    protected function _content_template() { }
}