<?php

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit;


class Vinkmag_Video_Popup_Widget extends Widget_Base {


  public $base;

    public function get_name() {
        return 'vinazine-video-popup';
    }

    public function get_title() {

        return esc_html__( 'Video Popup', 'vinkmag' );

    }

    public function get_icon() { 
        return 'eicon-youtube';
    }

    public function get_categories() {
        return [ 'vinkmag-elements' ];
    }

    protected function _register_controls() {

        $this->start_controls_section(
            'section_tab',
            [
                'label' => esc_html__('Title settings', 'vinkmag'),
            ]
        );

   

        $this->add_control(
            'video_url',
            [
                'label' => esc_html__('Link', 'vinkmag'),
                'type' => Controls_Manager::URL,
                'default' => [
                    'url' => '#'
                ],
            ]
        );
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'content_title_typography',
				'label' => esc_html__( 'Typography', 'vinkmag' ),
				'scheme' => Scheme_Typography::TYPOGRAPHY_2,
				'selector' => '{{WRAPPER}} .featurd-video-icon',
			]
        );

        $this->add_control(
            'icon_color',
            [
                'label' => esc_html__('icon color', 'vinkmag'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .featurd-video-icon' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'icon_text_align', [
                'label'             =>esc_html__( 'Alignment', 'vinkmag' ),
                'type'             => Controls_Manager::CHOOSE,
                'options'         => [
    
                    'left'         => [
                        'title'     =>esc_html__( 'Left', 'vinkmag' ),
                        'icon'     => 'fa fa-align-left',
                    ],
                    'center'     => [
                        'title'     =>esc_html__( 'Center', 'vinkmag' ),
                        'icon'     => 'fa fa-align-center',
                    ],
                    'right'         => [
                        'title'     =>esc_html__( 'Right', 'vinkmag' ),
                        'icon'     => 'fa fa-align-right',
                    ],
                ],
                'default'         => '',
               'selectors' => [
                   '{{WRAPPER}} .video-icon' => 'text-align: {{VALUE}};'
               ],
            ]
        );


        
        $this->end_controls_section();
    }

    protected function render( ) { 
        $settings = $this->get_settings();

    ?>
        <div class="video-icon">
            <a href="<?php echo esc_url($settings['video_url']['url']); ?>" class="ts-play-btn featurd-video-icon">
                <i class="icon-paly-button-1" aria-hidden="true"></i>
            </a>
        </div>

    <?php  
    }
    protected function _content_template() { }
}