<?php

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit;


class Vinkmag_Breaking_Slider_post_Widget extends Widget_Base {


  public $base;

    public function get_name() {
        return 'vinazine-breaking-slider-post';
    }

    public function get_title() {

        return esc_html__( 'Breaking Slider', 'vinkmag' );

    }

    public function get_icon() { 
        return 'eicon-youtube';
    }

    public function get_categories() {
        return [ 'vinkmag-elements' ];
    }

    protected function _register_controls() {

        $this->start_controls_section(
            'section_tab',
            [
                'label' => esc_html__('Title settings', 'vinkmag'),
            ]
        );

        $this->add_control(
            'trending_color',
            [
                'label' => esc_html__('Primary Color', 'vinkmag'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .breaking-title' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .vinkmag-breaking-slider .owl-nav .owl-prev, {{WRAPPER}} .vinkmag-breaking-slider .owl-nav .owl-next' => 'background: {{VALUE}};',
                ],
            ]
        );
        
        $this->add_control(
            'trending_post_color',
            [
                'label' => esc_html__('Secondary Color', 'vinkmag'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .ts-breaking-news p a' => 'color: {{VALUE}};',
                ],
            ]
        );

        
        $this->end_controls_section();
    }

    protected function render( ) { 
        $settings = $this->get_settings();

    ?>
      			<div class="ts-breaking-news media breaking-sliders-item">
					<h2 class="breaking-title">
						<i class="fa fa-bolt"></i> <?php esc_html_e('Breaking News :', 'vinkmag'); ?></h2>
					<div class="breaking-news-content owl-carousel media-body vinkmag-breaking-slider">
						<?php 
						$the_query = vinkmag_breaking_news_query();

						if ( $the_query->have_posts() ) :
							while ($the_query->have_posts()):
								$the_query->the_post();
						?>
								<div class="breaking-post-content">
									<p>
										<a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
									</p>
								</div>
						<?php
							endwhile;
							wp_reset_postdata();
						else:
							esc_html_e('nothing found', 'vinkmag');
						endif;
						?>
					</div>
				</div>

    <?php  
    }
    protected function _content_template() { }
}