<?php

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit;

class Vinkmag_Trending_Post_Widget extends Widget_Base {

  public $base;

    public function get_name() {
        return 'vinazine-trending-post';
    }

    public function get_title() {
        return esc_html__( 'Trending Post Slider', 'vinkmag' );
    }

    public function get_icon() { 
        return 'eicon-post-navigation';
    }

    public function get_categories() {
        return [ 'vinkmag-elements' ];
    }

    protected function _register_controls() {

        $this->start_controls_section(
            'section_tab',
            [
                'label' => esc_html__('Post', 'vinkmag'),
            ]
        );

        $this->add_control(
            'block_title_show',
            [
                'label' => esc_html__('Show block title', 'vinkmag'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Yes', 'vinkmag'),
                'label_off' => esc_html__('No', 'vinkmag'),
                'default' => 'yes',
            ]
        ); 
        $this->add_control(
            'block_title_style', [
                'label' => esc_html__('Block title style', 'vinkmag'),
                'type' => Vinkmag_Custom_Controls_Manager::IMAGECHOOSE,
                'default' => 'style1',
                'options' => require VINKMAG_EDITOR . '/elementor/widgets/widget-parts/helpers/block-title-styles-array.php',
                'condition' => [ 'block_title_show' => ['yes'] ]
            ]
        ); 
        $this->add_control(
            'block_title_markup',
            [
                'label'     =>esc_html__( 'Block title markup', 'vinkmag' ),
                'type'      => Controls_Manager::SELECT,
                'default'   => 'h2',
                'options'   => [
                        'h1'      =>esc_html__( 'H1', 'vinkmag' ),
                        'h2'      =>esc_html__( 'H2', 'vinkmag' ),
                        'h3'      =>esc_html__( 'H3', 'vinkmag' ),
                        'h4'      =>esc_html__( 'H4', 'vinkmag' ),
                        'h5'      =>esc_html__( 'H5', 'vinkmag' ),
                    ],
                'condition' => [ 'block_title_show' => ['yes'] ]
            ]
        );
        $this->add_control(
            'block_title_text',
            [
                'label' => esc_html__('Block title', 'vinkmag'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__( 'Post Slider', 'vinkmag' ),
                'condition' => [ 'block_title_show' => ['yes'] ]
            ]
        );

        
        $this->add_control(
         'block_title_color',
         [
             'label' => esc_html__('Block title color', 'vinkmag'),
             'type' => Controls_Manager::COLOR,
             'default' => '',
             'condition' => [ 'block_title_show' => ['yes'] ],
             'selectors' => [
                 '{{WRAPPER}} .title-text, {{WRAPPER}} .ts-title, {{WRAPPER}} .title-text' => 'color: {{VALUE}};',
             ],
         ]
     );

     $this->add_control(
         'block_title_background',
         [
             'label' => esc_html__('Title seperator background', 'vinkmag'),
             'type' => Controls_Manager::COLOR,
             'default' => '',
             'condition' => [ 'block_title_show' => ['yes'] ],
             'selectors' => [
                 '{{WRAPPER}} .title-text, {{WRAPPER}} .title-before, {{WRAPPER}} .title-after, {{WRAPPER}} .ts-title-item .topic-list, {{WRAPPER}} .owl-dots .owl-dot span' => 'background-color: {{VALUE}};',
             ],
         ]
     );

        $this->add_control(
          'post_title_limit',
          [
            'label'         => esc_html__( 'Post title crop', 'vinkmag' ),
            'type'          => Controls_Manager::NUMBER,
            'default'       => '100',
          ]
        );

        $this->add_control(
            'show_author',
            [
                'label' => esc_html__('Show Author', 'vinkmag'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Yes', 'vinkmag'),
                'label_off' => esc_html__('No', 'vinkmag'),
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'show_author_image',
            [
                'label' => esc_html__('Show Author Image', 'vinkmag'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Yes', 'vinkmag'),
                'label_off' => esc_html__('No', 'vinkmag'),
                'default' => 'yes',
            ]
        );

        $this->add_control(
         'show_view_count',
         [
             'label' => esc_html__('Show view Count', 'vinkmag'),
             'type' => Controls_Manager::SWITCHER,
             'label_on' => esc_html__('Yes', 'vinkmag'),
             'label_off' => esc_html__('No', 'vinkmag'),
             'default' => 'yes',
            ]
      );

        $this->add_control(
            'show_cat',
            [
                'label' => esc_html__('Show Category', 'vinkmag'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Yes', 'vinkmag'),
                'label_off' => esc_html__('No', 'vinkmag'),
                'default' => 'yes',
            ]
        );
        $this->add_control(
            'post_cats',
            [
                'label' =>esc_html__('Select Categories', 'vinkmag'),
                'type'      => Vinkmag_Custom_Controls_Manager::AJAXSELECT2,
                'options'   =>'category',
                'label_block' => true,
                'multiple'  => true,
            ]
        );
        $this->add_control(
            'post_sortby',
            [
                'label'     =>esc_html__( 'Post sort by', 'vinkmag' ),
                'type'      => Controls_Manager::SELECT,
                'default'   => 'latestpost',
                'options'   => [
                        'popularposts'    =>esc_html__( 'Popular posts', 'vinkmag' ),
                        'mostdiscussed'    =>esc_html__( 'Most discussed', 'vinkmag' ),
                    ],
            ]
        );
        $this->add_control(
            'post_order',
            [
                'label'     =>esc_html__( 'Post order', 'vinkmag' ),
                'type'      => Controls_Manager::SELECT,
                'default'   => 'DESC',
                'options'   => [
                        'DESC'      =>esc_html__( 'Descending', 'vinkmag' ),
                        'ASC'       =>esc_html__( 'Ascending', 'vinkmag' ),
                    ],
            ]
        );

        $this->end_controls_section();
    }

    protected function render( ) { 
        $settings = $this->get_settings();
        $arg = [
            'post_type'   =>  'post',
            'post_status' => 'publish',
            'order' => $settings['post_order'],
            'posts_per_page' => 8,
            'category__in' => $settings['post_cats'],
        ];

        switch($settings['post_sortby']){
            case 'popularposts':
                $arg['meta_key'] = 'vinkmag_post_views_count';
                $arg['orderby'] = 'meta_value_num';
            break;
            default:
                $arg['orderby'] = 'comment_count';
            break;
        }
        $query = new \WP_Query( $arg ); ?>
        
        <?php if ( $query->have_posts() ) : ?>
            <div class="ts-grid-box ts-tranding-post">
                <?php require VINKMAG_THEME_DIR . '/template-parts/blogs/block-titles/block-title-init.php'; ?>
        
                    <div class="owl-carousel owl-theme vinazine-trending-1">
                        <?php $i = 0; while ($query->have_posts()) : $query->the_post(); $i++; ?>
                            <div class="item grid-md <?php echo esc_attr(($i == 1) ? 'active' : ''); ?>">
                                <?php require VINKMAG_THEME_DIR . '/template-parts/blogs/contents/content-style3.php'; ?>
                            </div>
                        <?php endwhile; 
                        wp_reset_query(); ?>
                    </div>
                    <div  class="owl-carousel owl-theme heighlight slider-indicators vinazine-trending-2">
                       <?php $i=0; while($query->have_posts()): $query->the_post(); $i++; ?>
                        <div class="item">
                           <div class="post-content media">
                                 <div class="d-flex post-count"><?php echo esc_html(str_pad($i, 2, '0', STR_PAD_LEFT)); ?></div>
                                 <div class="media-body align-self-center">
                                       <h4 class="post-title">
                                          
                                          <?php echo esc_html(vinkmag_limited_title(get_the_title(), $settings['post_title_limit'])); ?>
                                       
                                       </h4>
                                       <span class="post-date-info">
                                          <i class="fa fa-clock-o"></i>
                                       <?php echo get_the_date(); ?>
                                       </span>
                                 </div>
                              </div>
                        </div>
                        <?php endwhile;
                           wp_reset_query();
                        ?>
                     </div>

            </div>
        <?php endif; ?>



      <?php  
    }
    protected function _content_template() { }
}