<?php

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit;

class Vinkmag_Post_Tab_Two_Widget extends Widget_Base {

  public $base;

    public function get_name() {
        return 'vinazine-post-tab-2';
    }

    public function get_title() {
        return esc_html__( 'Post Tab 2', 'vinkmag' );
    }

    public function get_icon() { 
        return 'eicon-nav-menu';
    }

    public function get_categories() {
        return [ 'vinkmag-elements' ];
    }

    protected function _register_controls() {

        $this->start_controls_section(
            'section_tab',
            [
                'label' => esc_html__('Post', 'vinkmag'),
            ]
        );
        $this->add_control(
         'shadow_opt',
         [
               'label' => esc_html__('Show shadow', 'vinkmag'),
               'type' => Controls_Manager::SWITCHER,
               'label_on' => esc_html__('Yes', 'vinkmag'),
               'label_off' => esc_html__('No', 'vinkmag'),
               'default' => 'yes',
         ]
      );

      $this->add_control(
        'theme',
        [
              'label' => esc_html__('Dark background?', 'vinkmag'),
              'type' => Controls_Manager::SWITCHER,
              'label_on' => esc_html__('Dark', 'vinkmag'),
              'label_off' => esc_html__('Light', 'vinkmag'),
              'default' => 'yes',
        ]
     ); 

      $this->add_control(
        'block_title_show',
        [
            'label' => esc_html__('Show block title', 'vinkmag'),
            'type' => Controls_Manager::SWITCHER,
            'label_on' => esc_html__('Yes', 'vinkmag'),
            'label_off' => esc_html__('No', 'vinkmag'),
            'default' => 'yes',
        ]
    );

    $this->add_control(
        'block_title_style', [
            'label' => esc_html__('Block title style', 'vinkmag'),
            'type' => Vinkmag_Custom_Controls_Manager::IMAGECHOOSE,
            'default' => 'style1',
            'options' => require VINKMAG_EDITOR . '/elementor/widgets/widget-parts/helpers/block-title-styles-array.php',

            'condition' => [ 'block_title_show' => ['yes'] ]
        ]
    );

    $this->add_control(
        'block_title_markup',
        [
            'label'     =>esc_html__( 'Block title markup', 'vinkmag' ),
            'type'      => Controls_Manager::SELECT,
            'default'   => 'h2',
            'options'   => [
                    'h1'      =>esc_html__( 'H1', 'vinkmag' ),
                    'h2'      =>esc_html__( 'H2', 'vinkmag' ),
                    'h3'      =>esc_html__( 'H3', 'vinkmag' ),
                    'h4'      =>esc_html__( 'H4', 'vinkmag' ),
                    'h5'      =>esc_html__( 'H5', 'vinkmag' ),
                ],
            'condition' => [ 'block_title_show' => ['yes'] ]
        ]
    );

    $this->add_control(
        'block_title_text',
        [
            'label' => esc_html__('Block title', 'vinkmag'),
            'type' => Controls_Manager::TEXT,
            'default' => esc_html__( 'Post Slider', 'vinkmag' ),
            'condition' => [ 'block_title_show' => ['yes'] ]
        ]
    );

    $this->add_control(
      'block_title_color',
      [
          'label' => esc_html__('Block title color', 'vinkmag'),
          'type' => Controls_Manager::COLOR,
          'default' => '',
          'condition' => [ 'block_title_show' => ['yes'] ],
          'selectors' => [
              '{{WRAPPER}} .title-text, {{WRAPPER}} .ts-title, {{WRAPPER}} .title-text' => 'color: {{VALUE}};',
          ],
      ]
  );

  $this->add_control(
      'block_title_background',
      [
          'label' => esc_html__('Title seperator background', 'vinkmag'),
          'type' => Controls_Manager::COLOR,
          'default' => '',
          'condition' => [ 'block_title_show' => ['yes'] ],
          'selectors' => [
              '{{WRAPPER}} .title-text, {{WRAPPER}} .title-before, {{WRAPPER}} .title-after, {{WRAPPER}} .ts-title-item .topic-list, {{WRAPPER}} .owl-dots .owl-dot span' => 'background-color: {{VALUE}};',
          ],
      ]
  );

        $this->add_control(
          'post_count',
          [
            'label'         => esc_html__( 'Post count', 'vinkmag' ),
            'type'          => Controls_Manager::NUMBER,
            'default'       => '8',
          ]
        );
        $this->add_responsive_control(
			'thumbnail_height',
			[
				'label' =>esc_html__( 'Thumbnail height', 'vinkmag' ),
                'type' => \Elementor\Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000,
					],
				],
				'devices' => [ 'desktop', 'tablet', 'mobile' ],
				'desktop_default' => [
					'size' => 400,
					'unit' => 'px',
				],
				'tablet_default' => [
					'size' => 300,
					'unit' => 'px',
				],
				'mobile_default' => [
					'size' => 250,
					'unit' => 'px',
				],
				'selectors' => [
					'{{WRAPPER}} .featured-post .item' => 'min-height: {{SIZE}}{{UNIT}};',
				],
			]
      );
      
        $this->add_control(
          'post_title_crop',
          [
            'label'         => esc_html__( 'Post title crop', 'vinkmag' ),
            'type'          => Controls_Manager::NUMBER,
            'default'       => '50',
          ]
        );
        $this->add_control(
            'post_format',
            [
                'label' =>esc_html__('Select Post Format', 'vinkmag'),
                'type'      => Vinkmag_Custom_Controls_Manager::SELECT2,
                'options' => [
					'standard'  =>esc_html__( 'Standard', 'vinkmag' ),
					'video' =>esc_html__( 'Video', 'vinkmag' ),
				],
				'default' => [],
                'label_block' => true,
                'multiple'  => true,
            ]
        );
        $this->add_control(
            'show_date',
            [
                'label' => esc_html__('Show Date', 'vinkmag'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Yes', 'vinkmag'),
                'label_off' => esc_html__('No', 'vinkmag'),
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'show_cat',
            [
                'label' => esc_html__('Show Category', 'vinkmag'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Yes', 'vinkmag'),
                'label_off' => esc_html__('No', 'vinkmag'),
                'default' => 'no',
            ]
        );
        $this->add_control(
            'post_sortby',
            [
                'label'     =>esc_html__( 'Post sort by', 'vinkmag' ),
                'type'      => Controls_Manager::SELECT,
                'default'   => 'latestpost',
                'options'   => [
                        'latestpost'      =>esc_html__( 'Latest posts', 'vinkmag' ),
                        'popularposts'    =>esc_html__( 'Popular posts', 'vinkmag' ),
                        'mostdiscussed'    =>esc_html__( 'Most discussed', 'vinkmag' ),
                    ],
            ]
        );
        $this->add_control(
            'post_order',
            [
                'label'     =>esc_html__( 'Post order', 'vinkmag' ),
                'type'      => Controls_Manager::SELECT,
                'default'   => 'DESC',
                'options'   => [
                        'DESC'      =>esc_html__( 'Descending', 'vinkmag' ),
                        'ASC'       =>esc_html__( 'Ascending', 'vinkmag' ),
                    ],
            ]
        );
        $this->add_control(
            'tabs',
            [
                'label' => esc_html__('Tabs', 'vinkmag'),
                'type' => Controls_Manager::REPEATER,
                'default' => [
                    [
                        'tab_title' => esc_html__('Add Label', 'vinkmag'),
                        'post_cats' => 1,
                    ],
                ],
                'fields' => [
                    [   'name' => 'post_cats',
                        'label' =>esc_html__('Select Categories', 'vinkmag'),
                        'type'      => Vinkmag_Custom_Controls_Manager::AJAXSELECT2,
                        'options'   =>'category',
                        'label_block' => true,
                        'multiple'  => true,
                    ],
                    [   'name' => 'tab_title',
                        'label'         => esc_html__( 'Tab title', 'vinkmag' ),
                        'type'          => Controls_Manager::TEXT,
                        'default'       => 'Add Label',
                  ]
                ],
            ]
        );
        $this->end_controls_section();
    }

    protected function render( ) { 
        $settings = $this->get_settings();
        
        $arg = [
            'post_type'   =>  'post',
            'post_status' => 'publish',
            'order' => $settings['post_order'],
            'posts_per_page' => $settings['post_count'],

        ];

        switch($settings['post_sortby']){
         case 'popularposts':
             $arg['meta_key'] = 'vinkmag_post_views_count';
             $arg['orderby'] = 'meta_value_num';
         break;
         case 'mostdiscussed':
             $arg['orderby'] = 'comment_count';
         break;
         default:
             $arg['orderby'] = 'date';
         break;
     }

        $settings['tab_style'] = 'style1';
        $settings['show_author'] = 'no'; 
        $remove_clearfix = true;
        ?>
        
        <div class="ts-grid-box tabs-item mb-30 <?php echo esc_attr(($settings['theme'] == 'yes') ? 'bg-dark-item white-text' : '' ); ?> <?php echo esc_attr(($settings['shadow_opt'] == 'yes') ? '' : 'grid-no-shadow'); ?>">
            <div class="clearfix ts-tab-style">
                <?php require VINKMAG_THEME_DIR . '/template-parts/blogs/block-titles/block-title-init.php'; ?>
            
                
                <ul class="tab-menu-item nav float-right" role="tablist" id="vinkmagposttab2<?php echo esc_attr($this->get_id());?>Tab">
                    <?php $i = 0; foreach($settings['tabs'] as $tab): $i++; ?>
                        <li class="nav-item">
                            <a class="nav-link <?php echo esc_attr(($i > 1) ? '' : 'active'); ?>" href="#tab-<?php echo esc_attr($this->get_id() . $i); ?>" role="tab" data-toggle="tab"><?php echo esc_html($tab['tab_title']); ?></a>
                        </li>
                    <?php endforeach; ?>
                </ul>
            </div>
            <div class="tab-content ts-tabs-content" id="vinkmagposttab2<?php echo esc_attr($this->get_id());?>TabContent">

                <?php $j = 0; foreach($settings['tabs'] as $tab): $j++;
                        require VINKMAG_THEME_DIR . '/template-parts/blogs/post-tab/post-tab-'.$settings['tab_style'].'.php'; 
                    endforeach;
                ?>
            </div>
        </div>
      <?php  
    }
    protected function _content_template() { }
}