<?php

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit;

class Vinkmag_Post_List_Widget extends Widget_Base {

  public $base;

    public function get_name() {
        return 'vinazine-post-list';
    }

    public function get_title() {
        return esc_html__( 'Post List', 'vinkmag' );
    }

    public function get_icon() { 
        return 'eicon-post-list';
    }

    public function get_categories() {
        return [ 'vinkmag-elements' ];
    }

    protected function _register_controls() {

        $this->start_controls_section(
            'section_tab',
            [
                'label' => esc_html__('Post', 'vinkmag'),
            ]
        );
 
        $this->add_control(

            'grid_style', [
                'label' => esc_html__('Choose Style', 'vinkmag'),
                'type' => Vinkmag_Custom_Controls_Manager::IMAGECHOOSE,
                'default' => 'style1',
                'options' => [
					'style1' => [
						'title' =>esc_html__( 'Style ', 'vinkmag' ),
                        'imagelarge' => VINKMAG_IMG . '/admin/elementor/post-grid/style1.png',
                        'imagesmall' => VINKMAG_IMG . '/admin/elementor/post-grid/style-min1.png',
                        'width' => '50%',
					],
					'style2' => [
						'title' =>esc_html__( 'Style ', 'vinkmag' ),
                        'imagelarge' => VINKMAG_IMG . '/admin/elementor/post-list/Style2.png',
                        'imagesmall' => VINKMAG_IMG . '/admin/elementor/post-list/Style-min2.png',
                        'width' => '50%',
					],
					'style3' => [
						'title' =>esc_html__( 'Style ', 'vinkmag' ),
                        'imagelarge' => VINKMAG_IMG . '/admin/elementor/post-list/Style3.png',
                        'imagesmall' => VINKMAG_IMG . '/admin/elementor/post-list/Style-min3.png',
                        'width' => '50%',
					],
					'style4' => [
						'title' =>esc_html__( 'Style ', 'vinkmag' ),
                        'imagelarge' => VINKMAG_IMG . '/admin/elementor/post-list/Style4.png',
                        'imagesmall' => VINKMAG_IMG . '/admin/elementor/post-list/Style-min4.png',
                        'width' => '50%',
					],
				],

            ]
        ); 
         $this->add_control(
               'block_title_show',
               [
                  'label' => esc_html__('Show block title', 'vinkmag'),
                  'type' => Controls_Manager::SWITCHER,
                  'label_on' => esc_html__('Yes', 'vinkmag'),
                  'label_off' => esc_html__('No', 'vinkmag'),
                  'default' => 'yes',
                  'condition' => [ 'grid_style' => ['style1', 'style2', 'style4'] ]

               ]
         ); 
         $this->add_control(
               'block_title_style', [
                  'label' => esc_html__('Block title style', 'vinkmag'),
                  'type' => Vinkmag_Custom_Controls_Manager::IMAGECHOOSE,
                  'default' => 'style1',
                  'options' => require VINKMAG_EDITOR . '/elementor/widgets/widget-parts/helpers/block-title-styles-array.php',
                  'condition' => [ 'block_title_show' => ['yes'] ],
                  'condition' => [ 'grid_style' => ['style1', 'style2', 'style4'] ]

               ]
         ); 
         $this->add_control(
               'block_title_markup',
               [
                  'label'     =>esc_html__( 'Block title markup', 'vinkmag' ),
                  'type'      => Controls_Manager::SELECT,
                  'default'   => 'h2',
                  'options'   => [
                           'h1'      =>esc_html__( 'H1', 'vinkmag' ),
                           'h2'      =>esc_html__( 'H2', 'vinkmag' ),
                           'h3'      =>esc_html__( 'H3', 'vinkmag' ),
                           'h4'      =>esc_html__( 'H4', 'vinkmag' ),
                           'h5'      =>esc_html__( 'H5', 'vinkmag' ),
                     ],
                  'condition' => [ 'block_title_show' => ['yes'] ]
               ]
         );
         $this->add_control(
               'block_title_text',
               [
                  'label' => esc_html__('Block title', 'vinkmag'),
                  'type' => Controls_Manager::TEXT,
                  'default' => esc_html__( 'Post Slider', 'vinkmag' ),
                  'condition' => [ 'block_title_show' => ['yes'] ]
               ]
         );

         
         $this->add_control(
            'block_title_color',
            [
                'label' => esc_html__('Block title color', 'vinkmag'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'condition' => [ 'block_title_show' => ['yes'] ],
                'selectors' => [
                    '{{WRAPPER}} .title-text, {{WRAPPER}} .ts-title, {{WRAPPER}} .title-text' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'block_title_background',
            [
                'label' => esc_html__('Title seperator background', 'vinkmag'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'condition' => [ 'block_title_show' => ['yes'] ],
                'selectors' => [
                    '{{WRAPPER}} .title-text, {{WRAPPER}} .title-before, {{WRAPPER}} .title-after, {{WRAPPER}} .ts-title-item .topic-list, {{WRAPPER}} .owl-dots .owl-dot span' => 'background-color: {{VALUE}};',
                ],
            ]
        );
         
          $this->add_control(
            'title_big',
            [
                'label' => esc_html__('Show big post title', 'vinkmag'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Yes', 'vinkmag'),
                'label_off' => esc_html__('No', 'vinkmag'),
                'default' => 'yes',
            ]
        );
         $this->add_control(
            'shadow_opt',
            [
                  'label' => esc_html__('Show shadow', 'vinkmag'),
                  'type' => Controls_Manager::SWITCHER,
                  'label_on' => esc_html__('Yes', 'vinkmag'),
                  'label_off' => esc_html__('No', 'vinkmag'),
                  'default' => 'yes',
            ]
         ); 


        $this->add_control(
          'post_count',
          [
            'label'         => esc_html__( 'Post count', 'vinkmag' ),
            'type'          => Controls_Manager::NUMBER,
            'default'       => '3',

          ]
        );

        $this->add_control(
         'post_title_crop',
         [
           'label'         => esc_html__( 'Post title crop', 'vinkmag' ),
           'type'          => Controls_Manager::NUMBER,
           'default'       => '100',
           'condition' => [ 'grid_style' => ['style1','style3', 'style4'] ]
         ]
       );

        $this->add_control(
         'post_title_limit',
         [
           'label'         => esc_html__( 'Post title crop', 'vinkmag' ),
           'type'          => Controls_Manager::NUMBER,
           'default'       => '100',
           'condition' => [ 'grid_style' => ['style2'] ]
         ]
       );

        $this->add_control(
         'show_desc',
         [
             'label' => esc_html__('Show post description', 'vinkmag'),
             'type' => Controls_Manager::SWITCHER,
             'label_on' => esc_html__('Yes', 'vinkmag'),
             'label_off' => esc_html__('No', 'vinkmag'),
             'default' => 'no',
             'condition' => [ 'grid_style' => ['style1', 'style2','style4'] ]
         ]
         ); 
         
        $this->add_control(
            'desc_limit',
            [
              'label'         => esc_html__( 'Desc limit', 'vinkmag' ),
              'type'          => Controls_Manager::NUMBER,
              'default'       => '100',
              'condition' => [ 'grid_style' => ['style2','style4'] ]
            ]
          );

         $this->add_control(
            'show_author',
                  [
                     'label' => esc_html__('Show Author', 'vinkmag'),
                     'type' => Controls_Manager::SWITCHER,
                     'label_on' => esc_html__('Yes', 'vinkmag'),
                     'label_off' => esc_html__('No', 'vinkmag'),
                     'default' => 'no',
                     'condition' => [ 'grid_style' => ['style4'] ]
                  ]
            );
   
            $this->add_control(
                  'show_author_image',
                  [
                     'label' => esc_html__('Show Author Image', 'vinkmag'),
                     'type' => Controls_Manager::SWITCHER,
                     'label_on' => esc_html__('Yes', 'vinkmag'),
                     'label_off' => esc_html__('No', 'vinkmag'),
                     'default' => 'no',
                     'condition' => [ 'grid_style' => ['style4'] ]
                  ]
            );


        $this->add_control(
            'post_cats',
            [
                'label' =>esc_html__('Select Categories', 'vinkmag'),
                'type'      => Vinkmag_Custom_Controls_Manager::AJAXSELECT2,
                'options'   =>'category',
                'label_block' => true,
                'multiple'  => true,
            ]
        );
        $this->add_control(
            'show_date',
            [
                'label' => esc_html__('Show Date', 'vinkmag'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Yes', 'vinkmag'),
                'label_off' => esc_html__('No', 'vinkmag'),
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'show_cat',
            [
                'label' => esc_html__('Show Category', 'vinkmag'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Yes', 'vinkmag'),
                'label_off' => esc_html__('No', 'vinkmag'),
                'default' => 'yes',
            ]
        );
        $this->add_control(
            'show_small_cat',
            [
                'label' => esc_html__('Show small post category', 'vinkmag'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Yes', 'vinkmag'),
                'label_off' => esc_html__('No', 'vinkmag'),
                'default' => 'no',
            ]
        );
        $this->add_control(
            'show_overlay_style',
            [
                'label' => esc_html__('Show Overlay Style', 'vinkmag'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Yes', 'vinkmag'),
                'label_off' => esc_html__('No', 'vinkmag'),
                'default' => 'no',
                'condition' => [ 'grid_style' => ['style2'] ]

            ]
        );
        $this->add_control(
            'show_big_img',
            [
                'label' => esc_html__('Show big image', 'vinkmag'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Yes', 'vinkmag'),
                'label_off' => esc_html__('No', 'vinkmag'),
                'default' => 'yes',
                'condition' => [ 'grid_style' => ['style3'] ]

            ]
        );
        $this->add_control(
            'show_view_count',
            [
                'label' => esc_html__('Show view Count', 'vinkmag'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Yes', 'vinkmag'),
                'label_off' => esc_html__('No', 'vinkmag'),
                'default' => 'no',
                'condition' => [ 'show_overlay_style' => ['yes'] ]

            ]
        );
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'content_title_typography',
				'label' => __( 'Big Post Typography', 'vinkmag' ),
				'scheme' => Scheme_Typography::TYPOGRAPHY_2,
                'selector' => '{{WRAPPER}} .vinkgmag-grid-posts .post-title',
                'condition' => [ 'show_overlay_style' => ['yes'] ],

			]
		);

        $this->add_control(
            'post_sortby',
            [
                'label'     =>esc_html__( 'Post sort by', 'vinkmag' ),
                'type'      => Controls_Manager::SELECT,
                'default'   => 'latestpost',
                'options'   => [
                        'latestpost'      =>esc_html__( 'Latest posts', 'vinkmag' ),
                        'popularposts'    =>esc_html__( 'Popular posts', 'vinkmag' ),
                        'mostdiscussed'    =>esc_html__( 'Most discussed', 'vinkmag' ),
                    ],
            ]
        );
        $this->add_control(
            'post_order',
            [
                'label'     =>esc_html__( 'Post order', 'vinkmag' ),
                'type'      => Controls_Manager::SELECT,
                'default'   => 'DESC',
                'options'   => [
                        'DESC'      =>esc_html__( 'Descending', 'vinkmag' ),
                        'ASC'       =>esc_html__( 'Ascending', 'vinkmag' ),
                    ],
            ]
        );

        $this->end_controls_section();
    }

    protected function render( ) { 
        $settings = $this->get_settings();
        $settings['show_author'] = 'no';
        $arg = [
            'post_type'   =>  'post',
            'post_status' => 'publish',
            'order' => $settings['post_order'],
            'posts_per_page' => $settings['post_count'],
            'category__in' => $settings['post_cats'],
        ];

        switch($settings['post_sortby']){
            case 'popularposts':
                $arg['meta_key'] = 'vinkmag_post_views_count';
                $arg['orderby'] = 'meta_value_num';
            break;
            case 'mostdiscussed':
                $arg['orderby'] = 'comment_count';
            break;
            default:
                $arg['orderby'] = 'date';
            break;
        }
        $query = new \WP_Query( $arg ); ?>
        
        <?php if ( $query->have_posts() ) : ?>
                <?php switch($settings['grid_style']){  
                        case 'style1': ?>
                            <div class="ts-grid-box ts-col-box  <?php echo esc_attr(($settings['title_big'] == 'yes') ? 'grid-md' : 'grid-sm'); ?>  <?php echo esc_attr(($settings['show_desc'] == 'yes') ? '' : 'grid-no-desc'); ?> <?php echo esc_attr(($settings['shadow_opt'] == 'yes') ? '' : 'grid-no-shadow'); ?>">
                            <?php require VINKMAG_THEME_DIR . '/template-parts/blogs/block-titles/block-title-init.php'; ?>

                                <?php while ($query->have_posts()) : $query->the_post(); ?>
                                    <div class="item grid-sm">
                                        <?php require VINKMAG_THEME_DIR . '/template-parts/blogs/contents/content-style1-c.php'; ?>
                                    </div>
                                <?php endwhile; ?>
                            </div>
                        <?php break; ?>
                        <?php case 'style2': ?>
                            <div class="widgets ts-grid-box widgets-populer-post  <?php echo esc_attr(($settings['shadow_opt'] == 'yes') ? '' : 'grid-no-shadow'); ?>">
                                <?php $i = 0; while ($query->have_posts()) : $query->the_post(); $i++; ?>
                                    <?php if($i == 1): ?>

                                    <?php require VINKMAG_THEME_DIR . '/template-parts/blogs/block-titles/block-title-init.php'; ?>
                                        <?php if($settings['show_overlay_style']=='yes'): ?>
                                        <div class="item vinkgmag-grid-posts <?php echo esc_attr(($settings['title_big'] == 'yes') ? 'grid-md' : 'grid-sm'); ?> ">
                                            <div <?php post_class(); ?>  >
                                              <?php require VINKMAG_THEME_DIR . '/template-parts/blogs/contents/content-style1.php'; ?>
                                            </div>
                                        </div>
                                         <?php else: ?>
                                         <div class="item <?php echo esc_attr(($settings['title_big'] == 'yes') ? 'grid-md' : 'grid-sm'); ?> ">
                                            <?php require VINKMAG_THEME_DIR . '/template-parts/blogs/contents/content-style3.php'; ?>
                                        </div>
                                         <?php endif; ?>
                                    <?php else: ?>
                                        <div class="post-content media">
                                            <a href="<?php the_permalink(); ?>">
                                                <img 
                                                class="d-flex sidebar-img" 
                                                src="<?php echo esc_url(vinkmag_post_thumbnail(get_the_ID())); ?>" 
                                                alt="<?php echo esc_attr(vinkmag_alt(get_the_ID())); ?>">
                                            </a>
                                            
                                            <div class="media-body ">
                                                <?php if($settings['show_small_cat']=='yes'): ?>
                                                 <span class="post-tag">
                                                    <?php $cat = get_the_category(); ?>
                                                    <a 
                                                        href="<?php echo get_category_link($cat[0]->term_id); ?>"
                                                        style="<?php echo esc_attr(vinkmag_cat_style($cat[0]->term_id, 'color_only')); ?>"
                                                        >
                                                        <?php echo get_cat_name($cat[0]->term_id); ?>
                                                    </a>
                                                </span>
                                                 <?php endif; ?>
                                                <h4 class="post-title">
                                                    <a href="<?php the_permalink(); ?>">  <?php echo esc_html(vinkmag_limited_title(get_the_title(), $settings['post_title_limit'])); ?></a>
                                                 
                                                </h4>
                                                <?php if($settings['show_date'] == 'yes'): ?>
                                                   <span class="post-date-info">
                                                      <i class="fa fa-clock-o"></i>
                                                      <?php echo get_the_date(); ?>
                                                   </span>
                                                 <?php endif; ?>
                                           
                                            </div>
                                        </div>
                                    <?php endif; ?>
                                <?php endwhile; ?>
                            </div>
                        <?php break; ?>

                        <?php case 'style3': ?>
                            <div class="ts-grid-item-2  <?php echo esc_attr(($settings['shadow_opt'] == 'yes') ? 'ts-list-post-box ts-grid-content' : 'grid-no-shadow '); ?>">
                                <?php $i = 0; while ($query->have_posts()) : $query->the_post(); $i++; ?>
                                    <?php if($i == 1): ?>
                                        <?php if($settings['show_big_img'] =='yes'): ?>
                                        <div class="item <?php echo esc_attr(($settings['title_big'] == 'yes') ? 'grid-md' : 'grid-sm'); ?> ">
                                            <?php require VINKMAG_THEME_DIR . '/template-parts/blogs/contents/content-style6.php'; ?>
                                        </div>
                                        <?php endif; ?>
                                    <?php else: ?>
                                          <div class="item">
                                             <div class="post-content">
                                                <h4 class="post-title">
                                                      <a href="<?php the_permalink(); ?>">  <?php echo esc_html(vinkmag_limited_title(get_the_title(), $settings['post_title_crop'])); ?></a>
                                                </h4>
                                                <?php if($blog_date_show == 'yes'): ?>
                                                   <span>
                                                      <i class="fa fa-clock-o"></i> <?php echo get_the_date(); ?>
                                                   </span>
                                                <?php endif; ?>
                                              </div>
                                          </div>
                                    <?php endif; ?>
                                <?php endwhile; ?>
                            </div>
                        <?php break; ?>

                       <?php case 'style4': ?>
                            <div class="post-list <?php echo esc_attr(($settings['title_big'] == 'yes') ? 'grid-md' : 'grid-sm'); ?>">
                            <?php require VINKMAG_THEME_DIR . '/template-parts/blogs/block-titles/block-title-init.php'; ?>
                            
                                <?php while ($query->have_posts()) : $query->the_post(); ?>
                                    <div class=" grid-sm vink-post-list">
                                        <?php require VINKMAG_THEME_DIR . '/template-parts/blogs/contents/content-style4.php'; ?>
                                    </div>
                                <?php endwhile; ?>
                            </div>
                        <?php break; ?>
                <?php } ?>
        <?php endif; ?>
      <?php  
    }
    protected function _content_template() { }
}
