<?php

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit;

class Vinkmag_Post_List_Tab_Widget extends Widget_Base {

  public $base;

    public function get_name() {
        return 'vinazine-post-list-tab';
    }

    public function get_title() {
        return esc_html__( 'Recent Post', 'vinkmag' );
    }

    public function get_icon() { 
        return 'eicon-post-excerpt';
    }

    public function get_categories() {
        return [ 'vinkmag-elements' ];
    }

    protected function _register_controls() {

        $this->start_controls_section(
            'section_tab',
            [
                'label' => esc_html__('Post', 'vinkmag'),
            ]
        );
        $this->add_control(
            'show_bg',
            [
               'label' => esc_html__('Show BG', 'vinkmag'),
               'type' => Controls_Manager::SWITCHER,
               'label_on' => esc_html__('Yes', 'vinkmag'),
               'label_off' => esc_html__('No', 'vinkmag'),
               'default' => 'no',
            ]
         );
         $this->add_control(
            'shadow_opt',
            [
                  'label' => esc_html__('Show shadow', 'vinkmag'),
                  'type' => Controls_Manager::SWITCHER,
                  'label_on' => esc_html__('Yes', 'vinkmag'),
                  'label_off' => esc_html__('No', 'vinkmag'),
                  'default' => 'yes',
            ]
         ); 

        $this->add_control(
            'tab_left_title',
            [
                'label' => esc_html__('Tab Left Title', 'vinkmag'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__( 'RECENT', 'vinkmag' )
            ]
        );
        $this->add_control(
            'tab_right_title',
            [
                'label' => esc_html__('Tab Right Title', 'vinkmag'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__( 'FAVORITES', 'vinkmag' )
            ]
        );
        $this->add_control(
          'post_count',
          [
            'label'         => esc_html__( 'Post count', 'vinkmag' ),
            'type'          => Controls_Manager::NUMBER,
            'default'       => '8',
          ]
        );
        $this->add_control(
          'post_title_crop',
          [
            'label'         => esc_html__( 'Post title crop', 'vinkmag' ),
            'type'          => Controls_Manager::NUMBER,
            'default'       => '50',
          ]
        );
        
        $this->add_control(
            'show_cat',
            [
                'label' => esc_html__('Show Category', 'vinkmag'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Yes', 'vinkmag'),
                'label_off' => esc_html__('No', 'vinkmag'),
                'default' => 'yes',
            ]
        );
        $this->add_control(
            'post_sortby',
            [
                'label'     =>esc_html__( 'Popular post sort by', 'vinkmag' ),
                'type'      => Controls_Manager::SELECT,
                'default'   => 'latestpost',
                'options'   => [
                        'latestpost'      =>esc_html__( 'Latest posts', 'vinkmag' ),
                        'viewcount'    =>esc_html__( 'View count', 'vinkmag' ),
                        'mostdiscussed'    =>esc_html__( 'Most discussed', 'vinkmag' ),
                    ],
            ]
        );
        $this->end_controls_section();
    }

    protected function render( ) { 
        $settings = $this->get_settings();

        $arg_recent = [
            'post_type'   =>  'post',
            'post_status' => 'publish',
            'posts_per_page' => $settings['post_count'],
            'ignore_sticky_posts' => 1
        ];
        $arg_fav = [
            'post_type'   =>  'post',
            'post_status' => 'publish',
            'posts_per_page' => $settings['post_count'],
            'ignore_sticky_posts' => 1
        ];

        switch($settings['post_sortby']){
         case 'popularposts':
             $arg_fav['meta_key'] = 'vinkmag_post_views_count';
             $arg_fav['orderby'] = 'meta_value_num';
         break;
         case 'mostdiscussed':
             $arg_fav['orderby'] = 'comment_count';
         break;
         default:
             $arg_fav['orderby'] = 'date';
         break;
     }

        $settings['show_author'] = 'no';
        $query_recent = new \WP_Query( $arg_recent );
        ?>
        
     
        <div class="post-list-item widgets <?php echo esc_attr(($settings['shadow_opt']== 'yes') ? '' : 'grid-no-shadow'); ?> <?php echo esc_attr(($settings['show_bg'] =='yes') ? 'bg-dark-item' : ''); ?>">
            <ul class="nav nav-tabs" role="tablist">
                <li role="presentation">
                    <a class="active" href="#home" aria-controls="home" role="tab" data-toggle="tab">
                        <i class="fa fa-clock-o"></i>
                        <?php echo esc_html($settings['tab_left_title']); ?>
                    </a>
                </li>
                <li role="presentation">
                    <a href="#profile" aria-controls="profile" role="tab" data-toggle="tab">
                        <i class="fa fa-heart"></i>
                        <?php echo esc_html($settings['tab_right_title']); ?>
                    </a>
                </li>
            </ul>
            <div class="tab-content">
				<div role="tabpanel" class="tab-pane active ts-grid-box post-tab-list" id="home">
                <?php if ( $query_recent->have_posts() ) : ?>
                    <?php $i = 0; while ($query_recent->have_posts()) : $query_recent->the_post(); $i++; ?>
                        <div class="post-content media">    
                            <img 
                                class="d-flex sidebar-img" 
                                src="<?php echo esc_url(vinkmag_post_thumbnail(get_the_ID())); ?>" 
                                alt="<?php echo esc_attr(vinkmag_alt(get_the_ID())); ?>">
                            <div class="media-body">
                                <span class="post-tag">
                                <?php $cat = get_the_category(); ?>
                                <a 
                                    href="<?php echo get_category_link($cat[0]->term_id); ?>"
                                    style="<?php echo esc_attr(vinkmag_cat_style($cat[0]->term_id, 'color_only')); ?>"
                                    >
                                    <?php echo get_cat_name($cat[0]->term_id); ?>
                                </a>
                                </span>
                                <h4 class="post-title">
                                <a href="<?php the_permalink(); ?>"><?php echo esc_html(vinkmag_limited_title(get_the_title(), $settings['post_title_crop'])); ?></a>
                                </h4>
                            </div>
                        </div>
                    <?php endwhile; 
                    wp_reset_query(); ?>
                <?php endif; ?>
                </div>
                <div role="tabpanel" class="tab-pane ts-grid-box post-tab-list" id="profile">
                    <?php
                    $query_fav = new \WP_Query( $arg_fav );
                    if ( $query_fav->have_posts() ) : ?>
                        <?php $i = 0; while ($query_fav->have_posts()) : $query_fav->the_post(); $i++; ?>
                            <div class="post-content media">    
                                <img 
                                    class="d-flex sidebar-img" 
                                    src="<?php echo esc_url(vinkmag_post_thumbnail(get_the_ID())); ?>" 
                                    alt="<?php echo esc_attr(vinkmag_alt(get_the_ID())); ?>">
                                <div class="media-body">
                                    <span class="post-tag">
                                    <?php $cat = get_the_category(); ?>
                                    <a 
                                        href="<?php echo get_category_link($cat[0]->term_id); ?>"
                                        style="<?php echo esc_attr(vinkmag_cat_style($cat[0]->term_id, 'color_only')); ?>"
                                        >
                                        <?php echo get_cat_name($cat[0]->term_id); ?>
                                    </a>
                                    </span>
                                    <h4 class="post-title">
                                        <a href="<?php the_permalink(); ?>"><?php echo esc_html(vinkmag_limited_title(get_the_title(), $settings['post_title_crop'])); ?></a>
                                    </h4>
                                </div>
                            </div>
                        <?php endwhile; 
                        wp_reset_query(); ?>
                    <?php endif; ?>
                </div>
            </div>
        </div>
        


      <?php  
    }
    protected function _content_template() { }
}