<?php

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit;

class Vinkmag_Post_Grid_Widget extends Widget_Base {

  public $base;

    public function get_name() {
        return 'vinazine-post-grid';
    }

    public function get_title() {
        return esc_html__( 'Posts Grid', 'vinkmag' );
    }

    public function get_icon() { 
        return 'eicon-posts-grid';
    }

    public function get_categories() {
        return [ 'vinkmag-elements' ];
    }

    protected function _register_controls() {

        $this->start_controls_section(
            'section_tab',
            [
                'label' => esc_html__('Post', 'vinkmag'),
            ]
        );
 
        $this->add_control(

            'grid_style', [
                'label' => esc_html__('Choose Style', 'vinkmag'),
                'type' => Vinkmag_Custom_Controls_Manager::IMAGECHOOSE,
                'default' => 'style1',
                'options' => [
					'style1' => [
						'title' => esc_html__( 'Style 1', 'vinkmag' ),
                        'imagelarge' => VINKMAG_IMG . '/admin/elementor/post-grid/style1.png',
                        'imagesmall' => VINKMAG_IMG . '/admin/elementor/post-grid/style-min1.png',
                        'width' => '50%',
					],
					'style2' => [
						'title' => esc_html__( 'Style 2', 'vinkmag' ),
                        'imagelarge' => VINKMAG_IMG . '/admin/elementor/post-grid/style-big2.png',
                        'imagesmall' => VINKMAG_IMG . '/admin/elementor/post-grid/style-min2.png',
                        'width' => '50%',
					],
					'style3' => [
						'title' => esc_html__( 'Style 3', 'vinkmag' ),
                        'imagelarge' => VINKMAG_IMG . '/admin/elementor/post-grid/style4.png',
                        'imagesmall' => VINKMAG_IMG . '/admin/elementor/post-grid/style-min4.png',
                        'width' => '50%',
					],
					'style4' => [
						'title' => esc_html__( 'Style 4', 'vinkmag' ),
                        'imagelarge' => VINKMAG_IMG . '/admin/elementor/post-grid/style5.png',
                        'imagesmall' => VINKMAG_IMG . '/admin/elementor/post-grid/style-min5.png',
                        'width' => '50%',
					],
					'style5' => [
						'title' => esc_html__( 'Style 5', 'vinkmag' ),
                        'imagelarge' => VINKMAG_IMG . '/admin/elementor/post-grid/style6.png',
                        'imagesmall' => VINKMAG_IMG . '/admin/elementor/post-grid/style-min6.png',
                        'width' => '50%',
					],
					'style6' => [
						'title' => esc_html__( 'Style 6', 'vinkmag' ),
                        'imagelarge' => VINKMAG_IMG . '/admin/elementor/post-grid/style66.png',
                        'imagesmall' => VINKMAG_IMG . '/admin/elementor/post-grid/style-min66.png',
                        'width' => '50%',
					],
					'style7' => [
						'title' => esc_html__( 'Style 7', 'vinkmag' ),
                        'imagelarge' => VINKMAG_IMG . '/admin/elementor/post-grid/style7.png',
                        'imagesmall' => VINKMAG_IMG . '/admin/elementor/post-grid/style-min7.png',
                        'width' => '50%',
					],
					'style8' => [
						'title' => esc_html__( 'Style 8', 'vinkmag' ),
                        'imagelarge' => VINKMAG_IMG . '/admin/elementor/post-grid/style8.png',
                        'imagesmall' => VINKMAG_IMG . '/admin/elementor/post-grid/style-min8.png',
                        'width' => '50%',
					],
					'style9' => [
						'title' => esc_html__( 'Style 9', 'vinkmag' ),
                        'imagelarge' => VINKMAG_IMG . '/admin/elementor/post-grid/style9.png',
                        'imagesmall' => VINKMAG_IMG . '/admin/elementor/post-grid/style-min9.png',
                        'width' => '50%',
					],
					'style10' => [
						'title' => esc_html__( 'Style 10', 'vinkmag' ),
                        'imagelarge' => VINKMAG_IMG . '/admin/elementor/post-grid/style10.png',
                        'imagesmall' => VINKMAG_IMG . '/admin/elementor/post-grid/style-min10.png',
                        'width' => '50%',
					],
					'style11' => [
						'title' => esc_html__( 'Style 11', 'vinkmag' ),
                        'imagelarge' => VINKMAG_IMG . '/admin/elementor/post-grid/style11.png',
                        'imagesmall' => VINKMAG_IMG . '/admin/elementor/post-grid/style-min11.png',
                        'width' => '50%',
					],
				],
            ]
        ); 



        $this->add_control(
            'post_bg_color',
            [
                'label' => esc_html__('Grid background color', 'vinkmag'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'condition' => [ 'grid_style' => ['style2'] ],
                'selectors' => [
                    '{{WRAPPER}} .ts-grid-box' => 'background-color: {{VALUE}};',
                ],
            ]
        );
    
          $this->add_control(
            'post_text_color',
            [
                'label' => esc_html__('Text color', 'vinkmag'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'condition' => [ 'grid_style' => ['style2'] ],
                'selectors' => [
                    '{{WRAPPER}} .post-title a:hover, {{WRAPPER}} .post-date-info, {{WRAPPER}} .post-content p, {{WRAPPER}} .post-title a' => 'color: {{VALUE}};',
                ],
            ]
        );
        
        $this->add_control(
         'title_big',
         [
             'label' => esc_html__('Show big post title', 'vinkmag'),
             'type' => Controls_Manager::SWITCHER,
             'label_on' => esc_html__('Yes', 'vinkmag'),
             'label_off' => esc_html__('No', 'vinkmag'),
             'default' => 'yes',
         ]
     );  
     
        $this->add_control(
         'shadow_opt',
         [
             'label' => esc_html__('Show box Shadow', 'vinkmag'),
             'type' => Controls_Manager::SWITCHER,
             'label_on' => esc_html__('Yes', 'vinkmag'),
             'label_off' => esc_html__('No', 'vinkmag'),
             'default' => 'yes',
             'condition' => [ 'grid_style' => ['style1','style9'] ]
         ]
     );  
     $this->add_group_control(
        Group_Control_Background::get_type(),
        [
            'name' => 'background',
            'label' => __( 'Background', 'vinkmag' ),
            'types' => [ 'gradient' ],
            'selector' => '{{WRAPPER}} .gradient-overlay',
            'condition' => [ 'grid_style' => ['style4'] ]
            ]
    );

     $this->add_control(
      'post_title_crop',
      [
        'label'         => esc_html__( 'Post Title limit', 'vinkmag' ),
        'type'          => Controls_Manager::NUMBER,
        'default' => '35',
        'condition' => [ 'grid_style' => ['style2','style3','style4','style6', 'style8', 'style9'] ]
      ]
    );  

     $this->add_control(
      'show_desc',
      [
          'label' => esc_html__('Show post description', 'vinkmag'),
          'type' => Controls_Manager::SWITCHER,
          'label_on' => esc_html__('Yes', 'vinkmag'),
          'label_off' => esc_html__('No', 'vinkmag'),
          'default' => 'yes',
          'condition' => [ 'grid_style' => ['style1','style2','style5', 'style6', 'style8','style11'] ]
      ]
      );        
      $this->add_control(
         'desc_limit',
         [
           'label'         => esc_html__( 'Description limit', 'vinkmag' ),
           'type'          => Controls_Manager::NUMBER,
           'default' => '35',
           'condition' => [ 'show_desc' => ['yes'] ],
           'condition' => [ 'grid_style' => ['style1','style2','style5', 'style6', 'style8','style11'] ]
         ]
       );       
      $this->add_control(
          'post_count',
          [
            'label'         => esc_html__( 'Post count', 'vinkmag' ),
            'type'          => Controls_Manager::NUMBER,
            'default'       => '3',

          ]
        );

        $this->add_responsive_control(
			'thumbnail_height',
			[
				'label' =>esc_html__( 'Thumbnail Height', 'vinkmag' ),
                'type' => \Elementor\Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000,
					],
				],
				'devices' => [ 'desktop', 'tablet', 'mobile' ],
				'desktop_default' => [
					'size' => 300,
					'unit' => 'px',
				],
				'tablet_default' => [
					'size' => 250,
					'unit' => 'px',
				],
				'mobile_default' => [
					'size' => 250,
					'unit' => 'px',
				],
				'selectors' => [
					'{{WRAPPER}} .featured-post .item' => 'min-height: {{SIZE}}{{UNIT}};',
                ],
                'condition' => [ 'grid_style' => ['style4', 'style6','style7', 'style10'] ]
			]
      );
      $this->add_responsive_control(
			'grid_margin',
			[
				'label' =>esc_html__( 'margin', 'vinkmag' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'selectors' => [
					'{{WRAPPER}} .grid-item' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
      );
      
        $this->add_control(
            'post_cats',
            [
                'label' =>esc_html__('Select Categories', 'vinkmag'),
                'type'      => Vinkmag_Custom_Controls_Manager::AJAXSELECT2,
                'options'   =>'category',
                'label_block' => true,
                'multiple'  => true,
            ]
        );
         $this->add_control(
            'show_date',
            [
                'label' => esc_html__('Show Date', 'vinkmag'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Yes', 'vinkmag'),
                'label_off' => esc_html__('No', 'vinkmag'),
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'show_cat',
            [
                'label' => esc_html__('Show Category', 'vinkmag'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Yes', 'vinkmag'),
                'label_off' => esc_html__('No', 'vinkmag'),
                'default' => 'no',
            ]
        );
        $this->add_control(
         'show_author',
               [
                  'label' => esc_html__('Show Author', 'vinkmag'),
                  'type' => Controls_Manager::SWITCHER,
                  'label_on' => esc_html__('Yes', 'vinkmag'),
                  'label_off' => esc_html__('No', 'vinkmag'),
                  'default' => 'no',
                  'condition' => [ 'grid_style' => ['style1', 'style4'] ]
               ]
         );

         $this->add_control(
               'show_author_image',
               [
                  'label' => esc_html__('Show Author Image', 'vinkmag'),
                  'type' => Controls_Manager::SWITCHER,
                  'label_on' => esc_html__('Yes', 'vinkmag'),
                  'label_off' => esc_html__('No', 'vinkmag'),
                  'default' => 'no',
                  'condition' => [ 'grid_style' => ['style1', 'style4'] ]
               ]
         );

        $this->add_control(
         'show_view_count',
         [
             'label' => esc_html__('Show view Count', 'vinkmag'),
             'type' => Controls_Manager::SWITCHER,
             'label_on' => esc_html__('Yes', 'vinkmag'),
             'label_off' => esc_html__('No', 'vinkmag'),
             'default' => 'no',
             'condition' => [ 'grid_style' => ['style4', 'style1'] ]
         ]
       );

        $this->add_control(
            'post_sortby',
            [
                'label'     =>esc_html__( 'Post sort by', 'vinkmag' ),
                'type'      => Controls_Manager::SELECT,
                'default'   => 'latestpost',
                'options'   => [
                        'latestpost'      =>esc_html__( 'Latest posts', 'vinkmag' ),
                        'popularposts'    =>esc_html__( 'Popular posts', 'vinkmag' ),
                        'mostdiscussed'    =>esc_html__( 'Most discussed', 'vinkmag' ),
                    ],
            ]
        );
        $this->add_control(
            'post_order',
            [
                'label'     =>esc_html__( 'Post order', 'vinkmag' ),
                'type'      => Controls_Manager::SELECT,
                'default'   => 'DESC',
                'options'   => [
                        'DESC'      =>esc_html__( 'Descending', 'vinkmag' ),
                        'ASC'       =>esc_html__( 'Ascending', 'vinkmag' ),
                    ],
            ]
        );

        $this->end_controls_section();
    }

    protected function render( ) { 
        $settings = $this->get_settings();
      
        $arg = [
            'post_type'   =>  'post',
            'post_status' => 'publish',
            'order' => $settings['post_order'],
            'posts_per_page' => $settings['post_count'],
            'category__in' => $settings['post_cats'],
        ];

        switch($settings['post_sortby']){
            case 'popularposts':
                $arg['meta_key'] = 'vinkmag_post_views_count';
                $arg['orderby'] = 'meta_value_num';
            break;
            case 'mostdiscussed':
                $arg['orderby'] = 'comment_count';
            break;
            default:
                $arg['orderby'] = 'date';
            break;
        }
        $query = new \WP_Query( $arg ); ?>
        
        <?php if ( $query->have_posts() ) : ?>
           <?php while ($query->have_posts()) : $query->the_post(); ?>
           <div class="grid-item <?php echo esc_attr(($settings['title_big'] == 'yes') ? 'grid-md' : 'grid-sm'); ?> <?php echo esc_attr(($settings['show_desc'] == 'yes') ? '' : 'grid-no-desc'); ?>">
                <?php switch($settings['grid_style']){  
                        case 'style1': ?>
                            <?php require VINKMAG_THEME_DIR . '/template-parts/blogs/contents/content-style1.php'; ?>
                        <?php break; case 'style2':?>
                            <?php require VINKMAG_THEME_DIR . '/template-parts/blogs/contents/content-style1-b.php'; ?>
                        <?php break; case 'style3': ?>
                            <?php require VINKMAG_THEME_DIR . '/template-parts/blogs/contents/content-style2.php'; ?>
                        <?php break; ?>
                        <?php break; case 'style4': ?>
                            <?php require VINKMAG_THEME_DIR . '/template-parts/blogs/contents/content-style3-b.php'; ?>
                        <?php break; ?>
                        <?php break; case 'style5': ?>
                            <?php require VINKMAG_THEME_DIR . '/template-parts/blogs/contents/content-style5.php'; ?>
                            <?php break; ?>
                        <?php break; case 'style6': ?>
                            <?php require VINKMAG_THEME_DIR . '/template-parts/blogs/contents/content-style1-d.php'; ?>
                            <?php break; ?>
                        <?php break; case 'style7': ?>
                            <?php require VINKMAG_THEME_DIR . '/template-parts/blogs/contents/content-style3-e.php'; ?>
                            <?php break; ?>

                        <?php break; case 'style8': ?>
                            <?php require VINKMAG_THEME_DIR . '/template-parts/blogs/contents/content-style4-b.php'; ?>
                            <?php break; ?>
                        <?php break; case 'style9': ?>
                          <div class="ts-grid-box ts-grid-content border-style">
                              <?php require VINKMAG_THEME_DIR .
                                 '/template-parts/blogs/contents/content-style6.php'; ?>
                          </div>
                            <?php break; ?>

                        <?php break; case 'style10': ?>
                          <div class="content-centerd-item">
                              <?php require VINKMAG_THEME_DIR .
                                 '/template-parts/blogs/contents/content-style3-e.php'; ?>
                          </div>
                            <?php break; ?>

                            <?php break; case 'style11': ?>
                              <?php require VINKMAG_THEME_DIR .
                                 '/template-parts/blogs/contents/content-style8.php'; ?>
                            <?php break; ?>


                        <?php } ?>

                    

                  </div>
            <?php endwhile; ?>
        <?php endif; ?>



      <?php  
    }
    protected function _content_template() { }
}