<?php

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit;

class Vinkmag_Post_Featured_Tab_Widget extends Widget_Base {

  public $base;

    public function get_name() {
        return 'vinazine-post-featured-tab';
    }

    public function get_title() {
        return esc_html__( 'Post featured Tab', 'vinkmag' );
    }

    public function get_icon() { 
        return 'eicon-sidebar';
    }

    public function get_categories() {
        return [ 'vinkmag-elements' ];
    }

    protected function _register_controls() {

        $this->start_controls_section(
            'section_tab',
            [
                'label' => esc_html__('Post', 'vinkmag'),
            ]
        );
       
        $this->add_control(
          'post_count',
          [
            'label'         => esc_html__( 'Post count', 'vinkmag' ),
            'type'          => Controls_Manager::NUMBER,
            'default'       => '8',
          ]
        );
        $this->add_responsive_control(
			'thumbnail_height',
			[
				'label' =>esc_html__( 'Thumbnail height', 'vinkmag' ),
                'type' => \Elementor\Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000,
					],
				],
				'devices' => [ 'desktop', 'tablet', 'mobile' ],
				'desktop_default' => [
					'size' => 400,
					'unit' => 'px',
				],
				'tablet_default' => [
					'size' => 300,
					'unit' => 'px',
				],
				'mobile_default' => [
					'size' => 250,
					'unit' => 'px',
				],
				'selectors' => [
					'{{WRAPPER}} .featured-post .item' => 'min-height: {{SIZE}}{{UNIT}};',
				],
			]
      );
      
        $this->add_control(
          'post_title_crop',
          [
            'label'         => esc_html__( 'Post title crop', 'vinkmag' ),
            'type'          => Controls_Manager::NUMBER,
            'default'       => '50',
          ]
        );
        $this->add_control(
            'post_format',
            [
                'label' =>esc_html__('Select Post Format', 'vinkmag'),
                'type'      => Vinkmag_Custom_Controls_Manager::SELECT2,
                'options' => [
					'standard'  =>esc_html__( 'Standard', 'vinkmag' ),
					'video' =>esc_html__( 'Video', 'vinkmag' ), 
				],
				'default' => [],
                'label_block' => true,
                'multiple'  => true,
            ]
        );
        $this->add_control(
            'post_cats',
            [
                'label' =>esc_html__('Select Categories', 'vinkmag'),
                'type'      => Vinkmag_Custom_Controls_Manager::AJAXSELECT2,
                'options'   =>'category',
                'label_block' => true,
                'multiple'  => true,
            ]
        );
        $this->add_control(
            'show_date',
            [
                'label' => esc_html__('Show Date', 'vinkmag'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Yes', 'vinkmag'),
                'label_off' => esc_html__('No', 'vinkmag'),
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'show_cat',
            [
                'label' => esc_html__('Show Category', 'vinkmag'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Yes', 'vinkmag'),
                'label_off' => esc_html__('No', 'vinkmag'),
                'default' => 'yes',
            ]
        );
        $this->add_control(
            'post_sortby',
            [
                'label'     =>esc_html__( 'Post sort by', 'vinkmag' ),
                'type'      => Controls_Manager::SELECT,
                'default'   => 'latestpost',
                'options'   => [
                        'latestpost'      =>esc_html__( 'Latest posts', 'vinkmag' ),
                        'popularposts'    =>esc_html__( 'Popular posts', 'vinkmag' ),
                        'mostdiscussed'    =>esc_html__( 'Most discussed', 'vinkmag' ),
                    ],
            ]
        );
        $this->add_control(
            'post_order',
            [
                'label'     =>esc_html__( 'Post order', 'vinkmag' ),
                'type'      => Controls_Manager::SELECT,
                'default'   => 'DESC',
                'options'   => [
                        'DESC'      =>esc_html__( 'Descending', 'vinkmag' ),
                        'ASC'       =>esc_html__( 'Ascending', 'vinkmag' ),
                    ],
            ]
        );

        $this->end_controls_section();
    }

    protected function render( ) { 
        $settings = $this->get_settings();

        $blog_date_show			= (isset($settings['show_date'])) 
						? $settings['show_date'] 
						: vinkmag_option( 'blog_date_show', 'yes' );
        $blog_cat_show			= (isset($settings['show_cat'])) 
						? $settings['show_cat'] 
                  : vinkmag_option( 'blog_cat_show', 'yes' );


        
        $arg = [
            'post_type'   =>  'post',
            'post_status' => 'publish',
            'order' => $settings['post_order'],
            'posts_per_page' => $settings['post_count'],
            'category__in' => $settings['post_cats'],
 
        ];

        switch($settings['post_sortby']){
         case 'popularposts':
             $arg['meta_key'] = 'vinkmag_post_views_count';
             $arg['orderby'] = 'meta_value_num';
         break;
         case 'mostdiscussed':
             $arg['orderby'] = 'comment_count';
         break;
         default:
             $arg['orderby'] = 'date';
         break;
     }

        $query = new \WP_Query( $arg ); ?>
        
        <?php if($query->have_posts()): ?>
        <div class="featured-tab-item">
							<!-- Tab panes -->
            <div class="tab-content">
               <?php $i=0; while ($query->have_posts()): $query->the_post(); $i++; ?>
               <div class="tab-pane fade <?php echo esc_attr(($i == 1) ? 'show active' : ''); ?>" id="nav-post-tab-<?php echo esc_attr($this->get_id()); ?>-<?php echo esc_attr($i); ?>" role="tabpanel" aria-labelledby="nav-<?php echo esc_attr($this->get_id()); ?>-<?php      echo esc_attr($i); ?>-tab">
                  <div class="featured-post">
                     <a href="<?php the_permalink(); ?>">
                        <div class="item"  style="background-image:url(<?php echo esc_url(vinkmag_post_thumbnail(get_the_ID(), 'full')); ?>)">

                        </div>
                     </a>
                  </div>
               </div>
               <?php endwhile; 
               wp_reset_query(); ?>
            </div>
            <!-- Nav tabs -->
            <ul class="nav nav-tabs row featured-tab-post" role="tablist">
            <?php $i = 0; while ($query->have_posts()) : $query->the_post(); $i++; ?>
               <li role="presentation" class="col-lg">
             
                  <a class="nav-item <?php echo esc_attr(($i == 1) ? 'active' : ''); ?>" id="nav-<?php echo esc_attr($this->get_id()); ?>-<?php echo esc_attr($i); ?>-tab" data-toggle="tab" href="#nav-post-tab-<?php echo esc_attr($this->get_id()); ?>-<?php echo esc_attr($i); ?>" role="tab" aria-controls="nav-post-tab-<?php echo esc_attr($this->get_id()); ?>-<?php echo esc_attr($i); ?>"
                     aria-selected="true">
                     <div class="post-content">
                        <h3 class="post-title">
                         <?php echo esc_html(vinkmag_limited_title(get_the_title(),  $settings['post_title_crop'])); ?>
                        </h3>
                        <ul class="post-meta-info">
                        <?php if($blog_cat_show == 'yes'): ?>
                            <?php $cat = get_the_category(); ?>

                           <li class="cat-name">
                              <span style="<?php echo esc_attr(vinkmag_cat_style($cat[0]->term_id, 'color_only')); ?>">
                                 <?php echo get_cat_name($cat[0]->term_id); ?>
                                 
                              </span>
                           </li>
                           <?php endif; ?>

                           <?php if($blog_date_show == 'yes'): ?>

                           <li>
                              <?php echo get_the_date(); ?>
                           </li>
                            <?php endif; ?>
                        </ul>
                     </div>


                  </a>
            
               </li>
               <?php endwhile;
                wp_reset_query(); ?>
            </ul>
    
       </div>
      <?php endif; ?>


      <?php  
    }
    protected function _content_template() { }
}