<?php

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit;

class Vinkmag_Post_Block_Slider_Widget extends Widget_Base {

  public $base;

    public function get_name() {
        return 'vinazine-post-block-slider';
    }

    public function get_title() {
        return esc_html__( 'Post Block Slider', 'vinkmag' );
    }

    public function get_icon() { 
        return 'eicon-slider-device';
    }

    public function get_categories() {
        return [ 'vinkmag-elements' ];
    }

    protected function _register_controls() {

        $this->start_controls_section(
            'section_tab',
            [
                'label' => esc_html__('Post', 'vinkmag'),
            ]
        );

        $this->add_control(
         'grid_style', [
             'label' => esc_html__('Choose Style', 'vinkmag'),
             'type' => Vinkmag_Custom_Controls_Manager::IMAGECHOOSE,
             'default' => 'style1',
             'options' => [
               'style1' => [
                  'title' =>esc_html__( 'Style ', 'vinkmag' ),
                        'imagelarge' => VINKMAG_IMG . '/admin/elementor/block-slider/block1.png',
                        'imagesmall' => VINKMAG_IMG . '/admin/elementor/block-slider/block1.png',
                        'width' => '50%',
               ],
               'style2' => [
                  'title' =>esc_html__( 'Style ', 'vinkmag' ),
                        'imagelarge' => VINKMAG_IMG . '/admin/elementor/block-slider/block2.png',
                        'imagesmall' => VINKMAG_IMG . '/admin/elementor/block-slider/block2.png',
                        'width' => '50%',
               ],
         
            ],

         ]
     ); 

   

        $this->add_control(
          'post_count',
          [
            'label'         => esc_html__( 'Post count', 'vinkmag' ),
            'type'          => Controls_Manager::NUMBER,
            'default'       => '3',
          ]
        );

        $this->add_control(
         'show_desc',
         [
             'label' => esc_html__('Show post description', 'vinkmag'),
             'type' => Controls_Manager::SWITCHER,
             'label_on' => esc_html__('Yes', 'vinkmag'),
             'label_off' => esc_html__('No', 'vinkmag'),
             'default' => 'yes',
         ]
         ); 
         $this->add_control(
            'desc_limit',
            [
              'label'         => esc_html__( 'Description limit', 'vinkmag' ),
              'type'          => Controls_Manager::NUMBER,
              'default' => '35',
              'condition' => [ 'show_desc' => ['yes'] ]
            ]
          );  

          $this->add_responsive_control(
            'thumbnail_height',
            [
               'label' =>esc_html__( 'Slider Height', 'vinkmag' ),
                   'type' => \Elementor\Controls_Manager::SLIDER,
               'range' => [
                  'px' => [
                     'min' => 0,
                     'max' => 1000,
                  ],
               ],
               'devices' => [ 'desktop', 'tablet', 'mobile' ],
               'desktop_default' => [
                  'size' => 350,
                  'unit' => 'px',
               ],
               'tablet_default' => [
                  'size' => 250,
                  'unit' => 'px',
               ],
               'mobile_default' => [
                  'size' => 200,
                  'unit' => 'px',
               ],
               'selectors' => [
                  '{{WRAPPER}} .featured-post .item, .blog-post-slider-item .ts-grid-box' => 'min-height: {{SIZE}}{{UNIT}};',
               ],
            ]
         );


        $this->add_control(
            'post_cats',
            [
                'label' => esc_html__('Select categories', 'vinkmag'),
                'type'      => Vinkmag_Custom_Controls_Manager::AJAXSELECT2,
                'options'   =>'category',
                'label_block' => true,
                'multiple'  => true,
            ]
        );
        $this->add_control(
            'show_date',
            [
                'label' => esc_html__('Show date', 'vinkmag'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Yes', 'vinkmag'),
                'label_off' => esc_html__('No', 'vinkmag'),
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'show_cat',
            [
                'label' => esc_html__('Show category', 'vinkmag'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Yes', 'vinkmag'),
                'label_off' => esc_html__('No', 'vinkmag'),
                'default' => 'no',
            ]
        );
        $this->add_control(
            'post_sortby',
            [
                'label'     => esc_html__( 'Post sort by', 'vinkmag' ),
                'type'      => Controls_Manager::SELECT,
                'default'   => 'latestpost',
                'options'   => [
                        'latestpost'      =>esc_html__( 'Latest posts', 'vinkmag' ),
                        'popularposts'    =>esc_html__( 'Popular posts', 'vinkmag' ),
                        'mostdiscussed'    =>esc_html__( 'Most discussed', 'vinkmag' ),
                    ],
            ]
        );
        $this->add_control(
            'post_order',
            [
                'label'     => esc_html__( 'Post order', 'vinkmag' ),
                'type'      => Controls_Manager::SELECT,
                'default'   => 'DESC',
                'options'   => [
                        'DESC'      =>esc_html__( 'Descending', 'vinkmag' ),
                        'ASC'       =>esc_html__( 'Ascending', 'vinkmag' ),
                    ],
            ]
        );

        $this->end_controls_section();
    }

    protected function render( ) { 
        $settings = $this->get_settings();
        $arg = [
            'post_type'   =>  'post',
            'post_status' => 'publish',
            'order' => $settings['post_order'],
            'posts_per_page' => $settings['post_count'],
            'category__in' => $settings['post_cats'],
        ];

        switch($settings['post_sortby']){
         case 'popularposts':
             $arg['meta_key'] = 'vinkmag_post_views_count';
             $arg['orderby'] = 'meta_value_num';
         break;
         case 'mostdiscussed':
             $arg['orderby'] = 'comment_count';
         break;
         default:
             $arg['orderby'] = 'date';
         break;
     }
        $settings['show_author'] = 'no';
        $query = new \WP_Query( $arg ); ?>
        
       <?php if ( $query->have_posts() ) : ?>
            <?php switch($settings['grid_style']): case 'style1' : ?>
                <div class="blog-post-slider-item owl-carousel vinazine-slider-grid vinazine-slider-block-<?php echo esc_attr($settings['grid_style']); ?>">
                    <?php while ($query->have_posts()) : $query->the_post(); ?>
                        <?php require VINKMAG_THEME_DIR . '/template-parts/blogs/contents/content-style9.php'; ?>
                    <?php endwhile; ?>
                </div>
                <?php break; ?>
                <?php case 'style2' :?>
                <div class="post-overflow-style owl-carousel vinazine-slider-grid vinazine-slider-block-<?php echo esc_attr($settings['grid_style']); ?>">
                    <?php while ($query->have_posts()) : $query->the_post(); ?>
                        <?php require VINKMAG_THEME_DIR . '/template-parts/blogs/contents/content-style9-b.php'; ?>
                    <?php endwhile; ?>
                </div>
                <?php break; ?>
            <?php endswitch; ?>
        <?php endif; ?>

      <?php  
    }
    protected function _content_template() { }
}