<?php

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit;

class Vinkmag_Post_Block_One_Widget extends Widget_Base {

  public $base;

    public function get_name() {
        return 'vinazine-post-block-one';
    }

    public function get_title() {
        return esc_html__( 'Post Block', 'vinkmag' );
    }

    public function get_icon() { 
        return 'eicon-menu-toggle';
    }

    public function get_categories() {
        return [ 'vinkmag-elements' ];
    }

    protected function _register_controls() {

        $this->start_controls_section(
            'section_tab',
            [
                'label' => esc_html__('Post', 'vinkmag'),
            ]
        );
 
 
        $this->add_control(
            'block_title_show',
            [
                'label' => esc_html__('Show block title', 'vinkmag'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Yes', 'vinkmag'),
                'label_off' => esc_html__('No', 'vinkmag'),
                'default' => 'yes',
            ]
        ); 
        $this->add_control(
            'block_title_style', [
                'label' => esc_html__('Block title style', 'vinkmag'),
                'type' => Vinkmag_Custom_Controls_Manager::IMAGECHOOSE,
                'default' => 'style1',
                'options' => require VINKMAG_EDITOR . '/elementor/widgets/widget-parts/helpers/block-title-styles-array.php',
                'condition' => [ 'block_title_show' => ['yes'] ]
            ]
        ); 
        $this->add_control(
            'block_title_markup',
            [
                'label'     =>esc_html__( 'Block title markup', 'vinkmag' ),
                'type'      => Controls_Manager::SELECT,
                'default'   => 'h2',
                'options'   => [
                        'h1'      =>esc_html__( 'H1', 'vinkmag' ),
                        'h2'      =>esc_html__( 'H2', 'vinkmag' ),
                        'h3'      =>esc_html__( 'H3', 'vinkmag' ),
                        'h4'      =>esc_html__( 'H4', 'vinkmag' ),
                        'h5'      =>esc_html__( 'H5', 'vinkmag' ),
                    ],
                'condition' => [ 'block_title_show' => ['yes'] ]
            ]
        );
        $this->add_control(
            'block_title_text',
            [
                'label' => esc_html__('Block title', 'vinkmag'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__( 'Post Slider', 'vinkmag' ),
                'condition' => [ 'block_title_show' => ['yes'] ]
            ]
        );

        
        $this->add_control(
         'block_title_color',
         [
             'label' => esc_html__('Block title color', 'vinkmag'),
             'type' => Controls_Manager::COLOR,
             'default' => '',
             'condition' => [ 'block_title_show' => ['yes'] ],
             'selectors' => [
                 '{{WRAPPER}} .title-text, {{WRAPPER}} .ts-title, {{WRAPPER}} .title-text' => 'color: {{VALUE}};',
             ],
         ]
     );

     $this->add_control(
         'block_title_background',
         [
             'label' => esc_html__('Title seperator background', 'vinkmag'),
             'type' => Controls_Manager::COLOR,
             'default' => '',
             'condition' => [ 'block_title_show' => ['yes'] ],
             'selectors' => [
                 '{{WRAPPER}} .title-text, {{WRAPPER}} .title-before, {{WRAPPER}} .title-after, {{WRAPPER}} .ts-title-item .topic-list, {{WRAPPER}} .owl-dots .owl-dot span' => 'background-color: {{VALUE}};',
             ],
         ]
     );
     $this->add_control(
        'block_title_url',
        [
            'label' => esc_html__('Link', 'vinkmag'),
            'type' => Controls_Manager::URL,
            'default' => [
                'url' => '#'
            ],
            'condition' => ['block_title_url_show' => 'no']
        ]
    );
    
    $this->add_control(
        'block_title_url_text',
        [
            'label' => esc_html__('Link', 'vinkmag'),
            'type' => Controls_Manager::TEXT,
            'default' => '',
            'condition' => ['block_title_url_show' => 'yes']
        ]
    );
    
          $this->add_control(
            'title_big',
            [
                'label' => esc_html__('Show big post title', 'vinkmag'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Yes', 'vinkmag'),
                'label_off' => esc_html__('No', 'vinkmag'),
                'default' => 'yes',
            ]
        );        
  

        $this->add_control(
            'show_desc',
            [
               'label' => esc_html__('Show big post desc', 'vinkmag'),
               'type' => Controls_Manager::SWITCHER,
               'label_on' => esc_html__('Yes', 'vinkmag'),
               'label_off' => esc_html__('No', 'vinkmag'),
               'default' => 'yes',
            ]
         );        
         $this->add_control(
            'desc_limit',
            [
              'label'         => esc_html__( 'Description limit', 'vinkmag' ),
              'type'          => Controls_Manager::NUMBER,
              'default' => '35',
              'condition' => [ 'show_desc' => ['yes'] ]
            ]
          );    
          
          $this->add_control(
            'post_title_limit',
            [
               'label'         => esc_html__( 'Small Post title crop', 'vinkmag' ),
               'type'          => Controls_Manager::NUMBER,
               'default'       => '100',
            ]
         );   
         
         $this->add_control(
            'shadow_opt',
            [
                'label' => esc_html__('Show shadow', 'vinkmag'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Yes', 'vinkmag'),
                'label_off' => esc_html__('No', 'vinkmag'),
                'default' => 'yes',
            ]
         ); 
        $this->add_control(
            'post_cats',
            [
                'label' =>esc_html__('Select Categories', 'vinkmag'),
                'type'      => Vinkmag_Custom_Controls_Manager::AJAXSELECT2,
                'options'   =>'category',
                'label_block' => true,
                'multiple'  => false,
            ]
        );
            $this->add_control(
               'show_author',
               [
                  'label' => esc_html__('Show Author', 'vinkmag'),
                  'type' => Controls_Manager::SWITCHER,
                  'label_on' => esc_html__('Yes', 'vinkmag'),
                  'label_off' => esc_html__('No', 'vinkmag'),
                  'default' => 'no',
               ]
         );

         $this->add_control(
               'show_author_image',
               [
                  'label' => esc_html__('Show Author Image', 'vinkmag'),
                  'type' => Controls_Manager::SWITCHER,
                  'label_on' => esc_html__('Yes', 'vinkmag'),
                  'label_off' => esc_html__('No', 'vinkmag'),
                  'default' => 'no',
               ]
         );

         $this->add_control(
            'show_view_count',
            [
               'label' => esc_html__('Show view Count', 'vinkmag'),
               'type' => Controls_Manager::SWITCHER,
               'label_on' => esc_html__('Yes', 'vinkmag'),
               'label_off' => esc_html__('No', 'vinkmag'),
               'default' => 'no',
               ]
         );

         
        $this->add_control(
            'show_date',
            [
                'label' => esc_html__('Show Date', 'vinkmag'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Yes', 'vinkmag'),
                'label_off' => esc_html__('No', 'vinkmag'),
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'show_cat',
            [
                'label' => esc_html__('Show Category', 'vinkmag'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Yes', 'vinkmag'),
                'label_off' => esc_html__('No', 'vinkmag'),
                'default' => 'yes',
            ]
        );
        $this->add_control(
            'post_sortby',
            [
                'label'     =>esc_html__( 'Post sort by', 'vinkmag' ),
                'type'      => Controls_Manager::SELECT,
                'default'   => 'latestpost',
                'options'   => [
                        'latestpost'      =>esc_html__( 'Latest posts', 'vinkmag' ),
                        'popularposts'    =>esc_html__( 'Popular posts', 'vinkmag' ),
                        'mostdiscussed'    =>esc_html__( 'Most discussed', 'vinkmag' ),
                    ],
            ]
        );
        $this->add_control(
            'post_order',
            [
                'label'     =>esc_html__( 'Post order', 'vinkmag' ),
                'type'      => Controls_Manager::SELECT,
                'default'   => 'DESC',
                'options'   => [
                        'DESC'      =>esc_html__( 'Descending', 'vinkmag' ),
                        'ASC'       =>esc_html__( 'Ascending', 'vinkmag' ),
                    ],
            ]
        );

        $this->end_controls_section();
    }

    protected function render( ) { 
        $settings = $this->get_settings();
      
        $arg = [
            'post_type'   =>  'post',
            'post_status' => 'publish',
            'order' => $settings['post_order'],
            'posts_per_page' => 5,
            'category__in' => $settings['post_cats'],
        ];

        switch($settings['post_sortby']){
            case 'popularposts':
                $arg['meta_key'] = 'vinkmag_post_views_count';
                $arg['orderby'] = 'meta_value_num';
            break;
            case 'mostdiscussed':
                $arg['orderby'] = 'comment_count';
            break;
            default:
                $arg['orderby'] = 'date';
            break;
        }


        $query = new \WP_Query( $arg ); ?>
        
        <?php if ( $query->have_posts() ) : ?>
            <div class="ts-grid-box category-box-item-3 <?php echo esc_attr(($settings['shadow_opt'] == 'yes') ? '' : 'grid-no-shadow'); ?>">
                <?php require VINKMAG_THEME_DIR . '/template-parts/blogs/block-titles/block-title-init.php'; ?>

                <div class="row">
                    <?php $i=1; while ($query->have_posts()) : $query->the_post(); ?>
                        
                        <?php if($i == 1): ?>
                            <div class="col-md-6">
                                <div class="item <?php echo esc_attr(($settings['title_big'] == 'yes') ? 'grid-md' : 'grid-sm'); ?> <?php echo esc_attr(($settings['show_desc'] == 'yes') ? '' : 'grid-no-desc'); ?>">
                                    <?php require VINKMAG_THEME_DIR . '/template-parts/blogs/contents/content-style1-c.php'; ?>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="row">
                               <?php else: ?>
                                 <div class="col-sm-6">
                                       <div class="item grid-no-desc no-post-cat">
                                          <?php require VINKMAG_THEME_DIR . '/template-parts/blogs/contents/content-style1-c-c.php'; ?>
                                       </div>
                                 </div>
                                 <?php endif; ?>
                                 <?php if($i == $query->post_count): ?>
                                </div>
                            </div>
                        <?php endif; ?>
                    <?php $i++; endwhile; ?>
                </div>
            </div>
        <?php endif; ?>
      <?php  
    }
    protected function _content_template() { }
}