<?php

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit;

class Vinkmag_Post_Accordion_Widget extends Widget_Base {

  public $base;

    public function get_name() {
        return 'vinazine-post-accordion';
    }

    public function get_title() {
        return esc_html__( 'Post Accordion', 'vinkmag' );
    }

    public function get_icon() { 
        return 'eicon-accordion';
    }

    public function get_categories() {
        return [ 'vinkmag-elements' ];
    }

    protected function _register_controls() {

        $this->start_controls_section(
            'section_tab',
            [
                'label' => esc_html__('Post', 'vinkmag'),
            ]
        );
        $this->add_control(
         'shadow_opt',
         [
               'label' => esc_html__('Show shadow', 'vinkmag'),
               'type' => Controls_Manager::SWITCHER,
               'label_on' => esc_html__('Yes', 'vinkmag'),
               'label_off' => esc_html__('No', 'vinkmag'),
               'default' => 'yes',
         ]
      ); 


      $this->add_control(
        'block_title_show',
        [
            'label' => esc_html__('Show block title', 'vinkmag'),
            'type' => Controls_Manager::SWITCHER,
            'label_on' => esc_html__('Yes', 'vinkmag'),
            'label_off' => esc_html__('No', 'vinkmag'),
            'default' => 'yes',
        ]
    ); 
    $this->add_control(
        'block_title_style', [
            'label' => esc_html__('Block title style', 'vinkmag'),
            'type' => Vinkmag_Custom_Controls_Manager::IMAGECHOOSE,
            'default' => 'style1',
            'options' => require VINKMAG_EDITOR . '/elementor/widgets/widget-parts/helpers/block-title-styles-array.php',

            'condition' => [ 'block_title_show' => ['yes'] ]
        ]
    ); 
    $this->add_control(
        'block_title_markup',
        [
            'label'     =>esc_html__( 'Block title markup', 'vinkmag' ),
            'type'      => Controls_Manager::SELECT,
            'default'   => 'h2',
            'options'   => [
                    'h1'      =>esc_html__( 'H1', 'vinkmag' ),
                    'h2'      =>esc_html__( 'H2', 'vinkmag' ),
                    'h3'      =>esc_html__( 'H3', 'vinkmag' ),
                    'h4'      =>esc_html__( 'H4', 'vinkmag' ),
                    'h5'      =>esc_html__( 'H5', 'vinkmag' ),
                ],
            'condition' => [ 'block_title_show' => ['yes'] ]
        ]
    );
    $this->add_control(
        'block_title_text',
        [
            'label' => esc_html__('Block title', 'vinkmag'),
            'type' => Controls_Manager::TEXT,
            'default' => esc_html__( 'Post Slider', 'vinkmag' ),
            'condition' => [ 'block_title_show' => ['yes'] ]
        ]
    );

    
    $this->add_control(
        'block_title_color',
        [
            'label' => esc_html__('Block title color', 'vinkmag'),
            'type' => Controls_Manager::COLOR,
            'default' => '',
            'condition' => [ 'block_title_show' => ['yes'] ],
            'selectors' => [
                '{{WRAPPER}} .title-text, {{WRAPPER}} .ts-title, {{WRAPPER}} .title-text' => 'color: {{VALUE}};',
            ],
        ]
    );

    $this->add_control(
        'block_title_background',
        [
            'label' => esc_html__('Title seperator background', 'vinkmag'),
            'type' => Controls_Manager::COLOR,
            'default' => '',
            'condition' => [ 'block_title_show' => ['yes'] ],
            'selectors' => [
                '{{WRAPPER}} .title-text, {{WRAPPER}} .title-before, {{WRAPPER}} .title-after, {{WRAPPER}} .ts-title-item .topic-list, {{WRAPPER}} .owl-dots .owl-dot span' => 'background-color: {{VALUE}};',
            ],
        ]
    );

        $this->add_control(
          'post_count',
          [
            'label'         => esc_html__( 'Post count', 'vinkmag' ),
            'type'          => Controls_Manager::NUMBER,
            'default'       => '8',
          ]
        );
      
        $this->add_control(
          'post_title_crop',
          [
            'label'         => esc_html__( 'Post title crop', 'vinkmag' ),
            'type'          => Controls_Manager::NUMBER,
            'default'       => '50',
          ]
        );
        $this->add_control(
            'post_cats',
            [
                'label' =>esc_html__('Select Categories', 'vinkmag'),
                'type'      => Vinkmag_Custom_Controls_Manager::AJAXSELECT2,
                'options'   =>'category',
                'label_block' => true,
                'multiple'  => true,
            ]
        );
        $this->add_control(
            'show_date',
            [
                'label' => esc_html__('Show Date', 'vinkmag'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Yes', 'vinkmag'),
                'label_off' => esc_html__('No', 'vinkmag'),
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'show_cat',
            [
                'label' => esc_html__('Show Category', 'vinkmag'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Yes', 'vinkmag'),
                'label_off' => esc_html__('No', 'vinkmag'),
                'default' => 'yes',
            ]
        );
        $this->add_control(
            'post_sortby',
            [
                'label'     =>esc_html__( 'Post sort by', 'vinkmag' ),
                'type'      => Controls_Manager::SELECT,
                'default'   => 'latestpost',
                'options'   => [
                        'latestpost'      =>esc_html__( 'Latest posts', 'vinkmag' ),
                        'popularposts'    =>esc_html__( 'Popular posts', 'vinkmag' ),
                        'mostdiscussed'    =>esc_html__( 'Most discussed', 'vinkmag' ),
                    ],
            ]
        );
        $this->add_control(
            'post_order',
            [
                'label'     =>esc_html__( 'Post order', 'vinkmag' ),
                'type'      => Controls_Manager::SELECT,
                'default'   => 'DESC',
                'options'   => [
                        'DESC'      =>esc_html__( 'Descending', 'vinkmag' ),
                        'ASC'       =>esc_html__( 'Ascending', 'vinkmag' ),
                    ],
            ]
        );

        $this->end_controls_section();
    }


    protected function render( ) { 
        $settings = $this->get_settings();
        
        $arg = [
            'post_type'   =>  'post',
            'post_status' => 'publish',
            'order' => $settings['post_order'],
            'posts_per_page' => $settings['post_count'],
            'category__in' => $settings['post_cats'],
        ];

        switch($settings['post_sortby']){
         case 'popularposts':
             $arg['meta_key'] = 'vinkmag_post_views_count';
             $arg['orderby'] = 'meta_value_num';
         break;
         case 'mostdiscussed':
             $arg['orderby'] = 'comment_count';
         break;
         default:
             $arg['orderby'] = 'date';
         break;
      }

        $settings['show_author'] = 'no';
        $query = new \WP_Query( $arg ); ?>
        
        <?php if ( $query->have_posts() ) : ?>
            <div id="accordion-<?php echo esc_attr($this->get_id()); ?>" class="ts-grid-box accordion-post-style  <?php echo esc_attr(($settings['shadow_opt'] == 'yes') ? '' : 'grid-no-shadow'); ?>" role="tablist">
            <?php require VINKMAG_THEME_DIR . '/template-parts/blogs/block-titles/block-title-init.php'; ?>
                <?php $i = 0; while ($query->have_posts()) : $query->the_post(); $i++?>
                <div class="card" 
                    style="background-image:url(<?php echo esc_attr(esc_url(vinkmag_post_thumbnail(get_the_ID(), 400, 280))); ?>)"
                >
                    <div 
                        id="collapse<?php echo esc_attr($this->get_id() . $i); ?>" 
                        class="collapse <?php echo esc_attr(($i > 1) ? '' : 'show');?>" 
                        role="tabpanel" 
                        aria-labelledby="heading<?php echo esc_attr($this->get_id() . $i); ?>" 
                        data-parent="#accordion-<?php echo esc_attr($this->get_id()); ?>">
                        <div class="card-body">
                            <div class="space"></div>
                            <a href="<?php the_permalink();?>" class="btn btn-detault"><?php esc_html_e('Details', 'vinkmag'); ?></a>
                        </div>
                    </div>
                    <div class="card-header" role="tab" id="heading<?php echo esc_attr($this->get_id() . $i); ?>">

                        <a data-toggle="collapse" href="#collapse<?php echo esc_attr($this->get_id() . $i); ?>" aria-expanded="true" aria-controls="collapse<?php echo esc_attr($this->get_id() . $i); ?>">
                            <i class="fa fa-map-marker"></i>
                            <h4 class="post-title md">
                            <?php echo esc_html(vinkmag_limited_title(get_the_title(), $settings['post_title_crop'])); ?>
                            </h4>
                            <span><?php 
                                $cat = get_the_category();
                                echo get_cat_name($cat[0]->term_id);
                            ?></span>
                        </a>

                    </div>
                </div>
                <?php endwhile; 
                wp_reset_query(); ?>
            </div>
        <?php endif; ?>



      <?php  
    }
    protected function _content_template() { }
}