<?php

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit;


class Vinkmag_Nav_search_Widget extends Widget_Base {


  public $base;

    public function get_name() {
        return 'vinazine-nav-search';
    }

    public function get_title() {

        return esc_html__( 'Search', 'vinkmag' );

    }

    public function get_icon() { 
        return 'eicon-search';
    }

    public function get_categories() {
        return [ 'vinkmag-elements' ];
    }

    protected function _register_controls() {

        $this->start_controls_section(
            'section_tab',
            [
                'label' => esc_html__('Title settings', 'vinkmag'),
            ]
        );

        $this->add_control(
            'icon_colors',
            [
                'label' => esc_html__('Primary Color', 'vinkmag'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .nav-search-button' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'icon_typography',
				'label' => __( 'Typography', 'vinkmag' ),
				'scheme' => Scheme_Typography::TYPOGRAPHY_1,
				'selector' => '{{WRAPPER}} .nav-search-button',
			]
        );
        

        $this->add_responsive_control(
            'date_text_align', [
                'label'             =>esc_html__( 'Alignment', 'vinkmag' ),
                'type'             => Controls_Manager::CHOOSE,
                'options'         => [
    
                    'left'         => [
                        'title'     =>esc_html__( 'Left', 'vinkmag' ),
                        'icon'     => 'fa fa-align-left',
                    ],
                    'center'     => [
                        'title'     =>esc_html__( 'Center', 'vinkmag' ),
                        'icon'     => 'fa fa-align-center',
                    ],
                    'right'         => [
                        'title'     =>esc_html__( 'Right', 'vinkmag' ),
                        'icon'     => 'fa fa-align-right',
                    ],
                ],
                'default'         => '',
               'selectors' => [
                   '{{WRAPPER}} .header-search-icon' => 'text-align: {{VALUE}};'
               ],
            ]
        );
 

        
        $this->end_controls_section();
    }

    protected function render( ) { 
        $settings = $this->get_settings();

    ?>
        <div class="header-search-icon">
           
            <a href="#modal-popup-2" class="navsearch-button nav-search-button xs-modal-popup"><i class="icon icon-search"></i></a>
        </div>
 

            	<!-- xs modal -->
<div class="zoom-anim-dialog mfp-hide modal-searchPanel ts-search-form" id="modal-popup-2">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="xs-search-panel">
                  <?php get_search_form(); ?>
            </div>
        </div>
    </div>
</div><!-- End xs modal --><!-- end language switcher strart -->
    <?php  
    }
    protected function _content_template() { }
}