<?php

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit;


class Vinkmag_instagram_Feed_Widget extends Widget_Base {


  public $base;

    public function get_name() {
        return 'vinazine-instagram-feed';
    }

    public function get_title() {

        return esc_html__( 'Gallery Images', 'vinkmag' );

    }

    public function get_icon() { 
        return 'eicon-photo-library';
    }

    public function get_categories() {
        return [ 'vinkmag-elements' ];
    }

    protected function _register_controls() {

        $this->start_controls_section(
            'section_tab',
            [
                'label' => esc_html__('Gallery settings', 'vinkmag'),
            ]
        );

        $this->add_control(
			'gallery',
			[
				'label' => __( 'Add Images', 'vinkmag' ),
				'type' => \Elementor\Controls_Manager::GALLERY,
				'default' => [],
			]
		);


        $this->end_controls_section();
    }

    protected function render( ) { 
        $settings = $this->get_settings();

	
    ?>
    <div class="instagramPhoto">
        <div class="row">
            <?php foreach ( $settings['gallery'] as $image ):  ?>
            <div class="col-md p-0">
                    <div class="ts-single-inst">
                        <a href="<?php echo esc_url($image['url']); ?>" class="">
                            <?php echo '<img src="' . $image['url'] . '">'; ?>
                        </a>
                    </div>
                    <!-- ts single inst-->
                </div>
                <!-- col end-->
                <?php  endforeach; ?>
            </div>
        </div>
    <?php  
    }
    protected function _content_template() {  }
}