<?php

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit;

class Vinkmag_Home_Featured_Slider_Widget extends Widget_Base {

  public $base;

    public function get_name() {
        return 'vinazine-home-featured-slider';
    }

    public function get_title() {
        return esc_html__( 'Home Features Slider', 'vinkmag' );
    }

    public function get_icon() { 
        return 'eicon-post-slider';
    }

    public function get_categories() {
        return [ 'vinkmag-elements' ];
    }

    protected function _register_controls() {

        $this->start_controls_section(
            'section_tab',
            [
                'label' => esc_html__('Post', 'vinkmag'),
            ]
        );
 

        $this->add_responsive_control(
			'thumbnail_height',
			[
				'label' =>esc_html__( 'Slider Height', 'vinkmag' ),
                'type' => \Elementor\Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000,
					],
				],
				'devices' => [ 'desktop', 'tablet', 'mobile' ],
				'desktop_default' => [
					'size' => 570,
					'unit' => 'px',
				],
				'tablet_default' => [
					'size' => 400,
					'unit' => 'px',
				],
				'mobile_default' => [
					'size' => 300,
					'unit' => 'px',
				],
				'selectors' => [
					'{{WRAPPER}} .featured-slider-item' => 'height: {{SIZE}}{{UNIT}};',
				],
			]
		);
        $this->add_control(
            'post_count',
            [
              'label'         => esc_html__( 'Post count', 'vinkmag' ),
              'type'          => Controls_Manager::NUMBER,
              'default'       => '3',
            ]
          );
  		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'content_title_typography',
				'label' => esc_html__( 'Typography', 'vinkmag' ),
				'scheme' => Scheme_Typography::TYPOGRAPHY_2,
				'selector' => '{{WRAPPER}} .hero-title',
			]
		);
        $this->add_control(
            'post_cats',
            [
                'label' =>  esc_html__('Select Categories', 'vinkmag'),
                'type'      => Vinkmag_Custom_Controls_Manager::AJAXSELECT2,
                'options'   =>'category',
                'label_block' => true,
                'multiple'  => true,
            ]
        );
        $this->add_control(
            'desc_limit',
            [
                'label' => esc_html__('Desc Limit', 'vinkmag'),
                'type' => Controls_Manager::NUMBER,
                'default'       => '15',

            ]
        );
        $this->add_control(
            'show_author',
            [
                'label' => esc_html__('Show Author', 'vinkmag'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Yes', 'vinkmag'),
                'label_off' => esc_html__('No', 'vinkmag'),
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'show_author_image',
            [
                'label' => esc_html__('Show Author image', 'vinkmag'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Yes', 'vinkmag'),
                'label_off' => esc_html__('No', 'vinkmag'),
                'default' => 'yes',
            ]
        );
        $this->add_control(
            'show_autoplay',
            [
                'label' => esc_html__('AutoPlay', 'vinkmag'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Yes', 'vinkmag'),
                'label_off' => esc_html__('No', 'vinkmag'),
                'default' => 'no',
            ]
        );
        $this->add_control(
            'show_date',
            [
                'label' => esc_html__('Show Date', 'vinkmag'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Yes', 'vinkmag'),
                'label_off' => esc_html__('No', 'vinkmag'),
                'default' => 'yes',
            ]
        );
        $this->add_control(
            'show_view_count',
            [
                'label' => esc_html__('Show view Count', 'vinkmag'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Yes', 'vinkmag'),
                'label_off' => esc_html__('No', 'vinkmag'),
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'show_cat',
            [
                'label' => esc_html__('Show Category', 'vinkmag'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Yes', 'vinkmag'),
                'label_off' => esc_html__('No', 'vinkmag'),
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'post_sortby',
            [
                'label'     =>esc_html__( 'Post sort by', 'vinkmag' ),
                'type'      => Controls_Manager::SELECT,
                'default'   => 'latestpost',
                'options'   => [
                        'latestpost'      =>esc_html__( 'Latest posts', 'vinkmag' ),
                        'popularposts'    =>esc_html__( 'Popular posts', 'vinkmag' ),
                        'mostdiscussed'    =>esc_html__( 'Most discussed', 'vinkmag' ),
                    ],
            ]
        );
        $this->add_control(
            'post_order',
            [
                'label'     =>esc_html__( 'Post order', 'vinkmag' ),
                'type'      => Controls_Manager::SELECT,
                'default'   => 'DESC',
                'options'   => [
                        'DESC'      =>esc_html__( 'Descending', 'vinkmag' ),
                        'ASC'       =>esc_html__( 'Ascending', 'vinkmag' ),
                    ],
            ]
        );

        $this->end_controls_section();
    }

    protected function render( ) { 
        $settings = $this->get_settings();
        $blog_cat_show			= (isset($settings['show_cat'])) 
                                ? $settings['show_cat'] 
                                : vinkmag_option( 'blog_cat_show', 'yes' );
                                
        $desc_limit			= (isset($settings['desc_limit']))
					         ? $settings['desc_limit']
                             : 15;

        $sticky = get_option( 'sticky_posts' );
        $arg = [
            'post_type'   =>  'post',
            'post_status' => 'publish',
            'order' => $settings['post_order'],
            'posts_per_page' => $settings['post_count'],
            'category__in' => $settings['post_cats'],
            'post__in'  => $sticky,
        ];

        switch($settings['post_sortby']){
            case 'popularposts':
                $arg['meta_key'] = 'vinkmag_post_views_count';
                $arg['orderby'] = 'meta_value_num';
            break;
            case 'mostdiscussed':
                $arg['orderby'] = 'comment_count';
            break;
            default:
                $arg['orderby'] = 'date';
            break;
        }
        $query = new \WP_Query( $arg );

        $thumb = [1600, 1000]; 
        
        
        if ( $query->have_posts() ) : ?>

                <div data-autoplay="<?php echo esc_attr($settings['show_autoplay']); ?>" class="grid-slider vinazine-featured-post owl-carousel hero-slider">
                    <?php while ($query->have_posts()) : $query->the_post(); ?>

                        <div  class="featured-slider-item" style="background-image: url(<?php echo esc_url(vinkmag_post_thumbnail(get_the_ID(), 'full')); ?>)">
                            <div class="featured-table">
                                <div class="table-cell">
                                    <div class="container">
                                        <div class="row">
                                            <div class="col-lg-6">
                                                <div class="hero-content">
                                                <?php if($blog_cat_show == 'yes'): ?> 
                                                    <?php $cat = get_the_category(); ?>
                                                    <a 
                                                        class="post-cat" 
                                                        href="<?php echo get_category_link($cat[0]->term_id); ?>"
                                                        style="<?php echo esc_attr(vinkmag_cat_style($cat[0]->term_id)); ?>"
                                                        >
                                                        <?php echo get_cat_name($cat[0]->term_id); ?>
                                                    </a>
                                                <?php endif; ?>                                              
                                                    <h2 class="hero-title">
                                                    <a href="<?php the_permalink(); ?>">
                                                        <?php echo esc_html(get_the_title()); ?>
                                                        </a>
                                                    </h2>
                                                    <p>
                                                        <?php vinkmag_excerpt($desc_limit); ?>
                                                    </p>
                                                </div>
                                            </div>
                                            <!-- col end-->
                                        </div>
                                        <!-- row end-->
                                    </div>
                                    <!-- container end-->
                                </div>
                            </div>
                        </div>

                <?php endwhile; ?>
                </div>

        <?php endif; ?>
      <?php  
    }
    protected function _content_template() { }
}