<?php

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit;

class Vinkmag_Featured_Post_Widget extends Widget_Base {

  public $base;

    public function get_name() {
        return 'vinazine-featured-post';
    }

    public function get_title() {
        return esc_html__( 'Featured Post Slider', 'vinkmag' );
    }

    public function get_icon() { 
        return 'eicon-post-slider';
    }

    public function get_categories() {
        return [ 'vinkmag-elements' ];
    }

    protected function _register_controls() {

        $this->start_controls_section(
            'section_tab',
            [
                'label' => esc_html__('Post', 'vinkmag'),
            ]
        );
 
        $this->add_control(

            'grid_style', [
                'label' => esc_html__('Choose Grid Style', 'vinkmag'),
                'type' => Vinkmag_Custom_Controls_Manager::IMAGECHOOSE,
                'default' => 'style1',
                'options' => [
					'style1' => [
						'title' => esc_html__( 'Style 1', 'vinkmag' ),
                        'imagelarge' => VINKMAG_IMG . '/admin/elementor/featured-post/style1.png',
                        'imagesmall' => VINKMAG_IMG . '/admin/elementor/featured-post/style-min1.png',
                        'width' => '50%',
					],
					'style2' => [
						'title' => esc_html__( 'Style 2', 'vinkmag' ),
                        'imagelarge' => VINKMAG_IMG . '/admin/elementor/featured-post/style2.png',
                        'imagesmall' => VINKMAG_IMG . '/admin/elementor/featured-post/style-min2.png',
                        'width' => '50%',
					],
					'style3' => [
						'title' => esc_html__( 'Style 3', 'vinkmag' ),
                        'imagelarge' => VINKMAG_IMG . '/admin/elementor/featured-post/style3.png',
                        'imagesmall' => VINKMAG_IMG . '/admin/elementor/featured-post/style-min3.png',
                        'width' => '50%',
					],
					'style4' => [
						'title' => esc_html__( 'Style 4', 'vinkmag' ),
                        'imagelarge' => VINKMAG_IMG . '/admin/elementor/featured-post/style4.png',
                        'imagesmall' => VINKMAG_IMG . '/admin/elementor/featured-post/style-min4.png',
                        'width' => '50%',
					],
				],
            ]
        ); 

        $this->add_responsive_control(
			'thumbnail_height',
			[
				'label' =>esc_html__( 'Slider Height', 'vinkmag' ),
                'type' => \Elementor\Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000,
					],
				],
				'devices' => [ 'desktop', 'tablet', 'mobile' ],
				'desktop_default' => [
					'size' => 570,
					'unit' => 'px',
				],
				'tablet_default' => [
					'size' => 400,
					'unit' => 'px',
				],
				'mobile_default' => [
					'size' => 300,
					'unit' => 'px',
				],
				'selectors' => [
					'{{WRAPPER}} .featured-post .item, .item.ts-grid-features-box' => 'min-height: {{SIZE}}{{UNIT}};',
				],
			]
		);
        $this->add_control(
            'post_count',
            [
              'label'         => esc_html__( 'Post count', 'vinkmag' ),
              'type'          => Controls_Manager::NUMBER,
              'default'       => '3',
            ]
          );
  		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'content_title_typography',
				'label' => __( 'Typography', 'vinkmag' ),
				'scheme' => Scheme_Typography::TYPOGRAPHY_2,
				'selector' => '{{WRAPPER}} .post-title',
			]
		);
        $this->add_control(
            'post_cats',
            [
                'label' =>esc_html__('Select Categories', 'vinkmag'),
                'type'      => Vinkmag_Custom_Controls_Manager::AJAXSELECT2,
                'options'   =>'category',
                'label_block' => true,
                'multiple'  => true,
            ]
        );
        $this->add_control(
            'show_author',
            [
                'label' => esc_html__('Show Author', 'vinkmag'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Yes', 'vinkmag'),
                'label_off' => esc_html__('No', 'vinkmag'),
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'show_author_image',
            [
                'label' => esc_html__('Show Author image', 'vinkmag'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Yes', 'vinkmag'),
                'label_off' => esc_html__('No', 'vinkmag'),
                'default' => 'yes',
            ]
        );
        $this->add_control(
            'show_autoplay',
            [
                'label' => esc_html__('AutoPlay', 'vinkmag'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Yes', 'vinkmag'),
                'label_off' => esc_html__('No', 'vinkmag'),
                'default' => 'no',
            ]
        );
        $this->add_control(
            'show_date',
            [
                'label' => esc_html__('Show Date', 'vinkmag'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Yes', 'vinkmag'),
                'label_off' => esc_html__('No', 'vinkmag'),
                'default' => 'yes',
            ]
        );
        $this->add_control(
            'show_view_count',
            [
                'label' => esc_html__('Show view Count', 'vinkmag'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Yes', 'vinkmag'),
                'label_off' => esc_html__('No', 'vinkmag'),
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'show_cat',
            [
                'label' => esc_html__('Show Category', 'vinkmag'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Yes', 'vinkmag'),
                'label_off' => esc_html__('No', 'vinkmag'),
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'post_sortby',
            [
                'label'     =>esc_html__( 'Post sort by', 'vinkmag' ),
                'type'      => Controls_Manager::SELECT,
                'default'   => 'latestpost',
                'options'   => [
                        'latestpost'      =>esc_html__( 'Latest posts', 'vinkmag' ),
                        'popularposts'    =>esc_html__( 'Popular posts', 'vinkmag' ),
                        'mostdiscussed'    =>esc_html__( 'Most discussed', 'vinkmag' ),
                    ],
            ]
        );
        $this->add_control(
            'post_order',
            [
                'label'     =>esc_html__( 'Post order', 'vinkmag' ),
                'type'      => Controls_Manager::SELECT,
                'default'   => 'DESC',
                'options'   => [
                        'DESC'      =>esc_html__( 'Descending', 'vinkmag' ),
                        'ASC'       =>esc_html__( 'Ascending', 'vinkmag' ),
                    ],
            ]
        );

        $this->end_controls_section();
    }

    protected function render( ) { 
        $settings = $this->get_settings();

        $arg = [
            'post_type'   =>  'post',
            'post_status' => 'publish',
            'order' => $settings['post_order'],
            'posts_per_page' => $settings['post_count'],
            'category__in' => $settings['post_cats'],
        ];

        switch($settings['post_sortby']){
            case 'popularposts':
                $arg['meta_key'] = 'vinkmag_post_views_count';
                $arg['orderby'] = 'meta_value_num';
            break;
            case 'mostdiscussed':
                $arg['orderby'] = 'comment_count';
            break;
            default:
                $arg['orderby'] = 'date';
            break;
        }
        $query = new \WP_Query( $arg );

        $thumb = [850, 560]; 
        
        
        if ( $query->have_posts() ) : ?>
            <?php switch($settings['grid_style']): case 'style1' : ?>

                <div data-autoplay="<?php echo esc_attr($settings['show_autoplay']); ?>" id="featured-slider" class="owl-carousel grid-slider vinazine-featured-post slider-grid-<?php echo esc_attr($settings['grid_style']); ?>">
                    <?php while ($query->have_posts()) : $query->the_post(); ?>
                        <?php require VINKMAG_THEME_DIR . '/template-parts/blogs/contents/content-style3-b.php'; ?>
                    <?php endwhile; ?>
                </div>

                <?php break; ?>
                <?php case 'style2': ?>
                <div data-autoplay="<?php echo esc_attr($settings['show_autoplay']); ?>" class="ts-overlay-style owl-carousel slider-grid slider-grid-<?php echo esc_attr($settings['grid_style']); ?>">
                    <?php while ($query->have_posts()) : $query->the_post(); ?>
                        <?php require VINKMAG_THEME_DIR . '/template-parts/blogs/contents/content-style3-e.php'; ?>
                    <?php endwhile; ?>
                </div>
                <?php break; ?>

                <?php case 'style3': ?>
                <div data-autoplay="<?php echo esc_attr($settings['show_autoplay']); ?>" class="ts-overlay-style owl-carousel slider-grid ts-featured-post slider-grid-<?php echo esc_attr($settings['grid_style']); ?>">
                    <?php while ($query->have_posts()) : $query->the_post(); ?>
                        <?php require VINKMAG_THEME_DIR . '/template-parts/blogs/contents/content-style3-e.php'; ?>
                    <?php endwhile; ?>
                </div>
                <?php break; ?>

                <?php case 'style4': ?>
                <div data-autoplay="<?php echo esc_attr($settings['show_autoplay']); ?>" class="owl-carousel slider-grid ts-featured-post slider-grid-<?php echo esc_attr($settings['grid_style']); ?>">
                    <?php while ($query->have_posts()) : $query->the_post(); ?>
                        <?php require VINKMAG_THEME_DIR . '/template-parts/blogs/contents/content-style7.php'; ?>
                    <?php endwhile; ?>
                </div>
                <?php break; ?>

            <?php endswitch; ?>
        <?php endif; ?>
      <?php  
    }
    protected function _content_template() { }
}