<?php

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit;


class Vinkmag_date_Widget extends Widget_Base {


  public $base;

    public function get_name() {
        return 'vinazine-date';
    }

    public function get_title() {

        return esc_html__( 'Date', 'vinkmag' );

    }

    public function get_icon() { 
        return 'eicon-date';
    }

    public function get_categories() {
        return [ 'vinkmag-elements' ];
    }

    protected function _register_controls() {

        $this->start_controls_section(
            'section_tab',
            [
                'label' => esc_html__('Title settings', 'vinkmag'),
            ]
        );

        $this->add_control(
            'date_bg_color',
            [
                'label' => esc_html__('Background Color', 'vinkmag'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .vinkmag-date .ts-date-item' => 'background: {{VALUE}};',
                ],
            ]
        );
        $this->add_control(
            'date_color',
            [
                'label' => esc_html__('Color', 'vinkmag'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .vinkmag-date .ts-date-item' => 'color: {{VALUE}};',
                ],
            ]
        );
        $this->add_responsive_control(
			'date_padding',
			[
				'label' =>esc_html__( 'Padding', 'vinkmag' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'selectors' => [
					'{{WRAPPER}} .ts-date-item' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
      );

        $this->add_responsive_control(
            'date_text_align', [
                'label'             =>esc_html__( 'Alignment', 'vinkmag' ),
                'type'             => Controls_Manager::CHOOSE,
                'options'         => [
    
                    'left'         => [
                        'title'     =>esc_html__( 'Left', 'vinkmag' ),
                        'icon'     => 'fa fa-align-left',
                    ],
                    'center'     => [
                        'title'     =>esc_html__( 'Center', 'vinkmag' ),
                        'icon'     => 'fa fa-align-center',
                    ],
                    'right'         => [
                        'title'     =>esc_html__( 'Right', 'vinkmag' ),
                        'icon'     => 'fa fa-align-right',
                    ],
                ],
                'default'         => '',
               'selectors' => [
                   '{{WRAPPER}} .vinkmag-date' => 'text-align: {{VALUE}};'
               ],
            ]
        );

        
        $this->end_controls_section();
    }

    protected function render( ) { 
        $settings = $this->get_settings();

    ?>
        <div class="vinkmag-date">
            <div class="ts-date-item">
                    <i class="fa fa-clock-o"></i>
                    <?php echo current_time(get_option('date_format')); ?>
            </div>
        </div>

    <?php  
    }
    protected function _content_template() { }
}