<?php

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit;

class Vinkmag_Category_List_Widget extends Widget_Base {

  public $base;

    public function get_name() {
        return 'vinazine-category-list';
    }

    public function get_title() {
        return esc_html__( 'Category List', 'vinkmag' );
    }

    public function get_icon() { 
        return 'eicon-post-list';
    }

    public function get_categories() {
        return [ 'vinkmag-elements' ];
    }

    protected function _register_controls() {

        $this->start_controls_section(
            'section_tab',
            [
                'label' => esc_html__('Category', 'vinkmag'),
            ]
        );
 
       

        
        $this->add_control(
            'block_title_show',
            [
                'label' => esc_html__('Show block title', 'vinkmag'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Yes', 'vinkmag'),
                'label_off' => esc_html__('No', 'vinkmag'),
                'default' => 'yes',
            ]
        ); 
        $this->add_control(
            'block_title_style', [
                'label' => esc_html__('Block title style', 'vinkmag'),
                'type' => Vinkmag_Custom_Controls_Manager::IMAGECHOOSE,
                'default' => 'style1',
                'options' => require VINKMAG_EDITOR . '/elementor/widgets/widget-parts/helpers/block-title-styles-array.php',

                'condition' => [ 'block_title_show' => ['yes'] ]
            ]
        ); 
        $this->add_control(
            'block_title_markup',
            [
                'label'     =>esc_html__( 'Block title markup', 'vinkmag' ),
                'type'      => Controls_Manager::SELECT,
                'default'   => 'h2',
                'options'   => [
                        'h1'      =>esc_html__( 'H1', 'vinkmag' ),
                        'h2'      =>esc_html__( 'H2', 'vinkmag' ),
                        'h3'      =>esc_html__( 'H3', 'vinkmag' ),
                        'h4'      =>esc_html__( 'H4', 'vinkmag' ),
                        'h5'      =>esc_html__( 'H5', 'vinkmag' ),
                    ],
                'condition' => [ 'block_title_show' => ['yes'] ]
            ]
        );
        $this->add_control(
            'block_title_text',
            [
                'label' => esc_html__('Block title', 'vinkmag'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__( 'Post Slider', 'vinkmag' ),
                'condition' => [ 'block_title_show' => ['yes'] ]
            ]
        );

        $this->add_control(
         'block_title_color',
         [
             'label' => esc_html__('Block title color', 'vinkmag'),
             'type' => Controls_Manager::COLOR,
             'default' => '',
             'condition' => [ 'block_title_show' => ['yes'] ],
             'selectors' => [
                 '{{WRAPPER}} .title-text, {{WRAPPER}} .ts-title, {{WRAPPER}} .title-text' => 'color: {{VALUE}};',
             ],
         ]
     );

     $this->add_control(
         'block_title_background',
         [
             'label' => esc_html__('Title seperator background', 'vinkmag'),
             'type' => Controls_Manager::COLOR,
             'default' => '',
             'condition' => [ 'block_title_show' => ['yes'] ],
             'selectors' => [
                 '{{WRAPPER}} .title-text, {{WRAPPER}} .title-before, {{WRAPPER}} .title-after, {{WRAPPER}} .ts-title-item .topic-list, {{WRAPPER}} .owl-dots .owl-dot span' => 'background-color: {{VALUE}};',
             ],
         ]
     );


        $this->add_control(
         'shadow_opt',
         [
               'label' => esc_html__('Show shadow', 'vinkmag'),
               'type' => Controls_Manager::SWITCHER,
               'label_on' => esc_html__('Yes', 'vinkmag'),
               'label_off' => esc_html__('No', 'vinkmag'),
               'default' => 'yes',
         ]
      ); 
  
        $this->add_control(
          'category_count',
          [
            'label'         => esc_html__( 'Category count', 'vinkmag' ),
            'type'          => Controls_Manager::NUMBER,
            'default'       => '3',

          ]
        );
        $this->add_control(
            'show_cat_selector',
            [
                'label' => esc_html__('Show Category Selector', 'vinkmag'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Yes', 'vinkmag'),
                'label_off' => esc_html__('No', 'vinkmag'),
                'default' => 'yes',
            ]
        );
        $this->add_control(
            'cats',
            [
                'label' =>esc_html__('Select Categories', 'vinkmag'),
                'type'      => Vinkmag_Custom_Controls_Manager::AJAXSELECT2,
                'options'   =>'category',
                'label_block' => true,
                'multiple'  => true,
                'condition' => [ 'show_cat_selector' => 'yes' ]
            ]
        );

        $this->end_controls_section();
    }

    protected function render( ) { 
        $settings = $this->get_settings();
        $arg = [
            'orderby' => 'name',
            'number'   => $settings['category_count'],
            'order'   => 'ASC'
        ];
        if($settings['show_cat_selector'] == 'yes'):
            $categories = $settings['cats'];?>
            <div class="ts-grid-box widgets category-list-item  <?php echo esc_attr(($settings['shadow_opt'] == 'yes') ? '' : 'grid-no-shadow'); ?>">
                <?php require VINKMAG_THEME_DIR . '/template-parts/blogs/block-titles/block-title-init.php'; ?>
                <ul class="category-list">
                    <?php foreach( $categories as $category ) {
                        $cat = get_category($category);?>
                        <?php echo sprintf( 
                            '<li><a href="%1$s">%2$s<span style="%3$s">%4$s</span></a></li>',
                            esc_url( get_category_link( $cat->term_id ) ),
                            esc_html( $cat->name ),
                            esc_attr(vinkmag_cat_style($cat->term_id)),
                            esc_html( $cat->count )
                        );
                    } ?>
                </ul>
            </div>
        <?php else:
            $categories = get_categories($arg); ?>
            <div class="ts-grid-box widgets category-list-item  <?php echo esc_attr(($settings['shadow_opt'] == 'yes') ? '' : 'grid-no-shadow'); ?>">
                <?php require VINKMAG_THEME_DIR . '/template-parts/blogs/block-titles/block-title-init.php'; ?>
                <ul class="category-list">
                    <?php foreach( $categories as $category ) { ?>
                        <?php echo sprintf( 
                            '<li><a href="%1$s">%2$s<span style="%3$s">%4$s</span></a></li>',
                            esc_url( get_category_link( $category->term_id ) ),
                            esc_html( $category->name ),
                            esc_attr(vinkmag_cat_style($category->term_id)),
                            esc_html( $category->count )
                        );
                    } ?>
                </ul>
            </div>
        <?php endif; ?>
        
    <?php }
    protected function _content_template() { }
}