<?php

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit;


class Vinkmag_Block_Title_Widget extends Widget_Base {


  public $base;

    public function get_name() {
        return 'vinazine-block-title';
    }

    public function get_title() {

        return esc_html__( 'Block Title', 'vinkmag' );

    }

    public function get_icon() { 
        return 'eicon-site-title';
    }

    public function get_categories() {
        return [ 'vinkmag-elements' ];
    }

    protected function _register_controls() {

        $this->start_controls_section(
            'section_tab',
            [
                'label' => esc_html__('Title settings', 'vinkmag'),
            ]
        );


        $this->add_control(
            'block_title_style', [
                'label' => esc_html__('Block title style', 'vinkmag'),
                'type' => Vinkmag_Custom_Controls_Manager::IMAGECHOOSE,
                'default' => 'style1',
                'options' => require VINKMAG_EDITOR . '/elementor/widgets/widget-parts/helpers/block-title-styles-array.php',
            ]
        ); 
        $this->add_control(
            'block_title_markup',
            [
                'label'     =>esc_html__( 'Block title markup', 'vinkmag' ),
                'type'      => Controls_Manager::SELECT,
                'default'   => 'h2',
                'options'   => [
                        'h1'      =>esc_html__( 'H1', 'vinkmag' ),
                        'h2'      =>esc_html__( 'H2', 'vinkmag' ),
                        'h3'      =>esc_html__( 'H3', 'vinkmag' ),
                        'h4'      =>esc_html__( 'H4', 'vinkmag' ),
                        'h5'      =>esc_html__( 'H5', 'vinkmag' ),
                    ],
            ]
        );
        $this->add_control(
            'block_title_text',
            [
                'label' => esc_html__('Block title', 'vinkmag'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__( 'block title', 'vinkmag' ),
            ]
        );


        $this->add_control(
            'block_title_color',
            [
                'label' => esc_html__('Block title color', 'vinkmag'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .title-text, {{WRAPPER}} .ts-title,  {{WRAPPER}} .view-all-link,  {{WRAPPER}} .view-all-link:hover, {{WRAPPER}} .title-text' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'block_title_background',
            [
                'label' => esc_html__('Title seperator background', 'vinkmag'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .title-text, {{WRAPPER}} .title-before, {{WRAPPER}} .title-after, {{WRAPPER}} .ts-title-item .topic-list, {{WRAPPER}} .owl-dots .owl-dot span' => 'background-color: {{VALUE}};',
                ],
            ]
        );

         $this->add_control(
            'block_title_url_show',
            [
                'label' => esc_html__('Show link', 'vinkmag'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Yes', 'vinkmag'),
                'label_off' => esc_html__('No', 'vinkmag'),
                'default' => 'no',
            ]
        ); 

        $this->add_control(
         'shadow_opt',
         [
             'label' => esc_html__('Show shadow', 'vinkmag'),
             'type' => Controls_Manager::SWITCHER,
             'label_on' => esc_html__('Yes', 'vinkmag'),
             'label_off' => esc_html__('No', 'vinkmag'),
             'default' => 'yes',
         ]
         ); 
        $this->add_control(
            'block_title_url',
            [
                'label' => esc_html__('Link', 'vinkmag'),
                'type' => Controls_Manager::URL,
                'default' => [
                    'url' => '#'
                ],
                'condition' => ['block_title_url_show' => 'yes']
            ]
        );
        
        $this->add_control(
            'block_title_url_text',
            [
                'label' => esc_html__('Link', 'vinkmag'),
                'type' => Controls_Manager::TEXT,
                'default' => '',
                'condition' => ['block_title_url_show' => 'yes']
            ]
        );
        
        
        
        $this->end_controls_section();
    }

    protected function render( ) { 
        $settings = $this->get_settings();
        $settings['block_title_show'] = 'yes';

    ?>
    <div class="title-area">
        <?php require VINKMAG_THEME_DIR . '/template-parts/blogs/block-titles/block-title-init.php'; ?>
    </div>
    <?php  
    }
    protected function _content_template() { }
}