<?php

if ( ! defined( 'ABSPATH' ) ) exit;

if(defined('ELEMENTOR_VERSION')):

include_once VINKMAG_COMPONENTS . '/editor/elementor/manager/controls.php';

class VINKMAG_Shortcode{

	/**
     * Holds the class object.
     *
     * @since 1.0
     *
     */
    public static $_instance;
    

    /**
     * Localize data array
     *
     * @var array
     */
    public $localize_data = array();

	/**
     * Load Construct
     * 
     * @since 1.0
     */

	public function __construct(){

		add_action('elementor/init', array($this, 'VINKMAG_elementor_init'));
        add_action('elementor/controls/controls_registered', array( $this, 'VINKMAG_icon_pack' ), 11 );
        add_action('elementor/controls/controls_registered', array( $this, 'control_image_choose' ), 13 );
        add_action('elementor/controls/controls_registered', array( $this, 'VINKMAG_ajax_select2' ), 13 );
        add_action('elementor/widgets/widgets_registered', array($this, 'VINKMAG_shortcode_elements'));
        add_action( 'elementor/editor/after_enqueue_styles', array( $this, 'editor_enqueue_styles' ) );
        add_action( 'elementor/frontend/before_enqueue_scripts', array( $this, 'enqueue_scripts' ) );
        add_action( 'elementor/preview/enqueue_styles', array( $this, 'preview_enqueue_scripts' ) );
        
	}


    /**
     * Enqueue Scripts
     *
     * @return void  
     */ 
    
     public function enqueue_scripts() {
         wp_enqueue_script( 'vinkmag-main-elementor', VINKMAG_JS  . '/elementor.js',array( 'jquery', 'elementor-frontend' ), VINKMAG_VERSION, true );
    }

    /**
     * Enqueue editor styles
     *
     * @return void
     */

    public function editor_enqueue_styles() {
        wp_enqueue_style( 'vinkmag-panel', VINKMAG_CSS.'/panel.css',null, VINKMAG_VERSION );
        wp_enqueue_style( 'vinkmag-icon-elementor', VINKMAG_CSS.'/icofonts.css',null, VINKMAG_VERSION );

    }

    /**
     * Preview Enqueue Scripts
     *
     * @return void
     */

    public function preview_enqueue_scripts() {}
	/**
     * Elementor Initialization
     *
     * @since 1.0
     *
     */

    public function VINKMAG_elementor_init(){
        \Elementor\Plugin::$instance->elements_manager->add_category(
            'vinkmag-elements',
            [
                'title' =>esc_html__( 'Vinkmag', 'vinkmag' ),
                'icon' => 'fa fa-plug',
            ],
            1
        );
    }

    /**
     * Extend Icon pack core controls.
     *
     * @param  object $controls_manager Controls manager instance.
     * @return void
     */ 

    public function VINKMAG_icon_pack( $controls_manager ) {

        require_once VINKMAG_EDITOR_ELEMENTOR. '/controls/icon.php';

        $controls = array(
            $controls_manager::ICON => 'VINKMAG_Icon_Controler',
        );

        foreach ( $controls as $control_id => $class_name ) {
            $controls_manager->unregister_control( $control_id );
            $controls_manager->register_control( $control_id, new $class_name() );
        }

    }
    // registering ajax select 2 control
    public function VINKMAG_ajax_select2( $controls_manager ) {
        require_once VINKMAG_EDITOR_ELEMENTOR. '/controls/select2.php';
        $controls_manager->register_control( 'ajaxselect2', new \Vinkmag_Control_Ajax_Select2() );
    }
    
    // registering image choose
    public function control_image_choose( $controls_manager ) {
        require_once VINKMAG_EDITOR_ELEMENTOR. '/controls/choose.php';
        $controls_manager->register_control( 'imagechoose', new \Control_Image_Choose() );
    }

    public function VINKMAG_shortcode_elements($widgets_manager){

        require_once VINKMAG_EDITOR_ELEMENTOR.'/widgets/home-featured-slider.php';
        $widgets_manager->register_widget_type(new Elementor\Vinkmag_Home_Featured_Slider_Widget());

        require_once VINKMAG_EDITOR_ELEMENTOR.'/widgets/trending-slider-post.php';
        $widgets_manager->register_widget_type(new Elementor\Vinkmag_Breaking_Slider_post_Widget());

        require_once VINKMAG_EDITOR_ELEMENTOR.'/widgets/block-title.php';
        $widgets_manager->register_widget_type(new Elementor\Vinkmag_Block_title_Widget());

        require_once VINKMAG_EDITOR_ELEMENTOR.'/widgets/post-grid.php';
        $widgets_manager->register_widget_type(new Elementor\Vinkmag_Post_Grid_Widget());

        require_once VINKMAG_EDITOR_ELEMENTOR.'/widgets/featured-post.php';
        $widgets_manager->register_widget_type(new Elementor\Vinkmag_Featured_Post_Widget());

        require_once VINKMAG_EDITOR_ELEMENTOR.'/widgets/vertical-slider-1.php';
        $widgets_manager->register_widget_type(new Elementor\Vinkmag_V_Slider_One_Widget());

        require_once VINKMAG_EDITOR_ELEMENTOR.'/widgets/vertical-slider-4.php';
        $widgets_manager->register_widget_type(new Elementor\Vinkmag_V_Slider_Four_Widget());

        require_once VINKMAG_EDITOR_ELEMENTOR.'/widgets/vertical-slider-3.php';
        $widgets_manager->register_widget_type(new Elementor\Vinkmag_V_Slider_Three_Widget());

        require_once VINKMAG_EDITOR_ELEMENTOR.'/widgets/vertical-slider-2.php';
        $widgets_manager->register_widget_type(new Elementor\Vinkmag_V_Slider_Two_Widget());
 
        require_once VINKMAG_EDITOR_ELEMENTOR.'/widgets/post-list.php';
        $widgets_manager->register_widget_type(new Elementor\Vinkmag_Post_List_Widget());

        require_once VINKMAG_EDITOR_ELEMENTOR.'/widgets/post-list-tab.php';
        $widgets_manager->register_widget_type(new Elementor\Vinkmag_Post_List_Tab_Widget());

        require_once VINKMAG_EDITOR_ELEMENTOR.'/widgets/post-tab.php';
        $widgets_manager->register_widget_type(new Elementor\Vinkmag_Post_Tab_Widget());

        require_once VINKMAG_EDITOR_ELEMENTOR.'/widgets/post-tab-2.php';
        $widgets_manager->register_widget_type(new Elementor\Vinkmag_Post_Tab_Two_Widget());

        require_once VINKMAG_EDITOR_ELEMENTOR.'/widgets/video-post-tab.php';
        $widgets_manager->register_widget_type(new Elementor\Vinkmag_Video_Post_Tab_Widget());

        require_once VINKMAG_EDITOR_ELEMENTOR.'/widgets/video-post-slider.php';
        $widgets_manager->register_widget_type(new Elementor\Vinkmag_Video_Post_Slider_Widget());

        require_once VINKMAG_EDITOR_ELEMENTOR.'/widgets/category-list.php';
        $widgets_manager->register_widget_type(new Elementor\Vinkmag_Category_List_Widget());

        require_once VINKMAG_EDITOR_ELEMENTOR.'/widgets/trending-post.php';
        $widgets_manager->register_widget_type(new Elementor\Vinkmag_Trending_Post_Widget());

        require_once VINKMAG_EDITOR_ELEMENTOR.'/widgets/post-block-one.php';
        $widgets_manager->register_widget_type(new Elementor\Vinkmag_Post_Block_One_Widget());
    
        require_once VINKMAG_EDITOR_ELEMENTOR.'/widgets/block-title.php';
        $widgets_manager->register_widget_type(new Elementor\Vinkmag_Block_Title_Widget());
    
        require_once VINKMAG_EDITOR_ELEMENTOR.'/widgets/post-accordion.php';
        $widgets_manager->register_widget_type(new Elementor\Vinkmag_Post_Accordion_Widget());
    
        require_once VINKMAG_EDITOR_ELEMENTOR.'/widgets/call-to-action.php';
        $widgets_manager->register_widget_type(new Elementor\Vinkmag_Call_To_Action_Widget());
    
        require_once VINKMAG_EDITOR_ELEMENTOR.'/widgets/post-block-slider.php';
        $widgets_manager->register_widget_type(new Elementor\Vinkmag_Post_Block_Slider_Widget());

        require_once VINKMAG_EDITOR_ELEMENTOR.'/widgets/post-featured-tab.php';
        $widgets_manager->register_widget_type(new Elementor\Vinkmag_Post_Featured_Tab_Widget());

        require_once VINKMAG_EDITOR_ELEMENTOR.'/widgets/instagram-feed.php';
        $widgets_manager->register_widget_type(new Elementor\Vinkmag_instagram_Feed_Widget());

        require_once VINKMAG_EDITOR_ELEMENTOR.'/widgets/video-popup.php';
        $widgets_manager->register_widget_type(new Elementor\Vinkmag_Video_Popup_Widget());

        require_once VINKMAG_EDITOR_ELEMENTOR.'/widgets/date.php';
        $widgets_manager->register_widget_type(new Elementor\Vinkmag_date_Widget());

        require_once VINKMAG_EDITOR_ELEMENTOR.'/widgets/nav-search.php';
        $widgets_manager->register_widget_type(new Elementor\Vinkmag_Nav_search_Widget());
    
        require_once VINKMAG_EDITOR_ELEMENTOR.'/widgets/logo.php';
        $widgets_manager->register_widget_type(new Elementor\Vinkmag_Site_Logo_Widget());
    
    }
    
	public static function VINKMAG_get_instance() {
        if (!isset(self::$_instance)) {
            self::$_instance = new VINKMAG_Shortcode();
        }
        return self::$_instance;
    }

}
$VINKMAG_Shortcode = VINKMAG_Shortcode::VINKMAG_get_instance();

endif;