<?php 
session_start();
error_reporting(E_ALL);
include("includes/head.php");
$error = false;
function success($text) {
	?>
	<div class="alert alert-success" role="alert">
		<i class="fa fa-smile-o fa-lg"></i><?php echo $text; ?>
	</div>
	<?php
}
function error($text) {
	?>
	<div class="alert alert-danger" role="alert">
		<i class="fa fa-frown-o fa-lg"></i><?php echo $text; ?>
	</div>
	<?php
}
function isEnabled($func) {
	return is_callable($func) && false === stripos(ini_get('disable_functions'), $func);
}
					
function getMySQLVersion() { 
	$output = shell_exec('mysql -V'); 
	preg_match('@[0-9]+\.[0-9]+\.[0-9]+@', $output, $version); 
	return $version[0]; 
}

function isMysqlInstalled()
{
    $exts     = get_loaded_extensions();
    
    $exts_str = implode(",", $exts);
    
    return strpos($exts_str, "mysqlnd");
    
}

?>
<title>Server Requirements</title>
<?php include("includes/header.php"); ?>
<?php include("includes/sidebar.php"); ?>
<div class="rightSide">
	<div class="col-xs-12">
		<div class="tab-content shadow-1">
			<div role="tabpanel" class="tab-pane active">
				<form class="form-horizontal">
					
					<div class="form-group">
						<label class="col-sm-3 control-label">Web Server</label>
						<?php $web_server = $_SERVER["SERVER_SOFTWARE"]; ?>
						<div class="col-sm-9">
							<?php
							if(($web_server == "Apache") || (strpos($web_server, "Apache") !== false)) {
								success($web_server);
							}
							else {
								success($web_server ." : Apache is recomended");
							}
							?>
						</div>
					</div>
					<div class="form-group">
						<label class="col-sm-3 control-label">PHP Version</label>
						<?php $php_version = phpversion(); ?>
						<div class="col-sm-9">
							<?php
							if($php_version >= 5.6) {
								success($php_version);
							}
							else {
								error($php_version." : Less Than 5.6");
								$error = true;
							}
							?>
						</div>
					</div>
					<div class="form-group">
						<label class="col-sm-3 control-label">PHP CURL</label>
						<div class="col-sm-9">
							<?php
							if(function_exists('curl_version')) {
								success("Installed");
							}
							else {
								error("Not Installed");
								$error = true;
							}
							?>
						</div>
					</div>
					<div class="form-group">
						<label class="col-sm-3 control-label">PHP allow_url_fopen</label>
						<div class="col-sm-9">
							<?php
							if( ini_get('allow_url_fopen') ) {
								success("Open");
							}
							else {
								error("Closed");
								$error = true;
							}
							?>
						</div>
					</div>
					<div class="form-group">
						<label class="col-sm-3 control-label">PHP libxml</label>
						<div class="col-sm-9">
							<?php
							if(extension_loaded('libxml')) {
								success("Enabled");
							}
							else {
								error("Not Enabled");
								$error = true;
							}
							?>
						</div>
					</div>
					<?php
					//if(isEnabled('shell_exec')) {
						?>
						<div class="form-group">
							<label class="col-sm-3 control-label">MYSQL </label>
							
							<div class="col-sm-9">
								<?php
								if(isMysqlInstalled()) {
									success("installed");
								}
								else {
									error($mysql_version . " Mysql should be installed");
									$error = true;
								}
								?>
							</div>
						</div>
						<?php
					//}

					if($error == true) {
						?>
						<div class="row">
							<div class="col-sm-offset-3 col-sm-9">
								<div class="alert alert-danger">
									Server Does not meet all the requirements.
								</div>
							</div>
						</div>
						<div class="form-group">
							<div class="col-sm-offset-3 col-sm-8">
								<a href="./requirements.php" class="btn btn-theme btn-lg">Refresh</a>
							</div>
						</div>
						<?php
					}
					else {
						$_SESSION['update_step'] = 2;
						?>
						<div class="form-group">
							<div class="col-sm-offset-3 col-sm-8">
								<a href="./database_details.php" class="btn btn-success btn-lg">Next</a>
							</div>
						</div>
						<?php
					}
					?>
				</form>
			</div>
		</div>
	</div>
</div>
<?php include("includes/footer.php"); ?>