<?php 
session_start();
error_reporting(E_ALL);
if(!isset($_SESSION['update_step']) || $_SESSION['update_step'] < 5) {
	header("location:./database_quries.php");
	exit();
}
unset($_SESSION['update_step']);

$dir = '../application/cache';
$leave_files = array('.htaccess', 'index.html');
foreach(glob("$dir/*") as $file) {
    if(!in_array(basename($file), $leave_files)) {
		unlink($file);
	}
}

$baseUrl = (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] == "on"? 'https://' : 'http://').$_SERVER['SERVER_NAME'] . str_replace("/update","",dirname($_SERVER['SCRIPT_NAME']));

include("includes/head.php"); 
?>
<title>Finish Installation</title>
<?php include("includes/header.php"); ?>
<?php include("includes/sidebar.php"); ?>
<div class="rightSide">
	<div class="col-xs-12">
		<div class="tab-content shadow-1">
			<div role="tabpanel" class="tab-pane finish text-center active">
				<div class="row">
					<div style="margin:0 auto;float:none;" class="col-sm-10">
						<div style="text-align:left" class="well">	
							<p><strong>Important Note :</strong></p>
							<p>After updating the script please do all the steps below.</p>
							<ul>
								<li>Goto to <strong><a target="_blank" href="<?php echo $baseUrl; ?>/admin/api-keys"><?php echo $baseUrl; ?>/admin/api-keys</strong></a> and update all the API keys</li>
								<li>Goto to <strong><a target="_blank" href="<?php echo $baseUrl; ?>/admin/languages"><?php echo $baseUrl; ?>/admin/languages</strong></a> edit all the languages and update the missing values.</li>
							</ul>
						</div>
					</div>
				</div>
				<div class="form-group">
					<a href="<?php echo $baseUrl; ?>" class="btn btn-theme btn-lg">Visit Website</a>
				</div>
				<div class="alert alert-info">
					<i class="fa fa-exclamation-circle fa-lg"></i> Script has been updated successfully.
				</div>
				<p style="margin-top:10px">Note : Don't forget to delete the <strong>update</strong> and <strong>install</strong> directories.</p>
			</div>
		</div>
	</div>
</div>
<?php include("includes/footer.php"); ?>