SET NAMES utf8;
SET time_zone = '+00:00';
SET foreign_key_checks = 0;
SET sql_mode = 'NO_AUTO_VALUE_ON_ZERO';

DROP TABLE IF EXISTS `ads-settings`;
CREATE TABLE `ads-settings` (
  `ad728x90Status` int(11) DEFAULT NULL,
  `ad728x90ResponsiveStatus` int(11) DEFAULT NULL,
  `ad728x90` text COLLATE utf8_unicode_ci,
  `ad250x250Status` int(11) DEFAULT NULL,
  `ad250x250ResponsiveStatus` int(11) DEFAULT NULL,
  `ad250x250` text COLLATE utf8_unicode_ci,
  `popAdStatus` int(11) DEFAULT NULL,
  `popAd` text COLLATE utf8_unicode_ci,
  `popAdFrequency` int(11) DEFAULT NULL,
  `displayOnHomePage` int(11) DEFAULT NULL,
  `displayOnDynamicPages` int(11) DEFAULT NULL,
  `displayOnContactPage` int(11) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

INSERT INTO `ads-settings` (`ad728x90Status`, `ad728x90ResponsiveStatus`, `ad728x90`, `ad250x250Status`, `ad250x250ResponsiveStatus`, `ad250x250`, `popAdStatus`, `popAd`, `popAdFrequency`, `displayOnHomePage`, `displayOnDynamicPages`, `displayOnContactPage`) VALUES
(0,	0,	null,	0,	0,	null,	0,	null,	0,	0,	0,	0);

DROP TABLE IF EXISTS `analytics-settings`;
CREATE TABLE `analytics-settings` (
  `status` int(11) DEFAULT NULL,
  `code` text COLLATE utf8_unicode_ci
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

INSERT INTO `analytics-settings` (`status`, `code`) VALUES
(0,	null);

DROP TABLE IF EXISTS `captcha-settings`;
CREATE TABLE `captcha-settings` (
  `siteKey` varchar(300) COLLATE utf8_unicode_ci NULL,
  `secretKey` varchar(300) COLLATE utf8_unicode_ci DEFAULT NULL,
  `loginCaptcha` int(11) DEFAULT NULL,
  `forgotPasswordCaptcha` int(11) DEFAULT NULL,
  `contactCaptcha` int(11) DEFAULT NULL,
  `resetPasswordCaptcha` int(11) DEFAULT NULL,
  `captchaShowFailedAttempts` int(11) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

INSERT INTO `captcha-settings` (`siteKey`, `secretKey`, `loginCaptcha`, `forgotPasswordCaptcha`, `contactCaptcha`, `resetPasswordCaptcha`, `captchaShowFailedAttempts`) VALUES
(null,	null,	0,	0,	0,	0,	3);

DROP TABLE IF EXISTS `general-settings`;
CREATE TABLE `general-settings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `description` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL,
  `keywords` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL,
  `facebookAppId` varchar(60) COLLATE utf8_unicode_ci DEFAULT NULL,
  `coverImage` varchar(60) COLLATE utf8_unicode_ci DEFAULT NULL,
  `backgroundImage` varchar(60) COLLATE utf8_unicode_ci DEFAULT NULL,
  `logo` varchar(60) COLLATE utf8_unicode_ci DEFAULT NULL,
  `logoLight` varchar(60) COLLATE utf8_unicode_ci DEFAULT NULL,
  `favicon` varchar(60) COLLATE utf8_unicode_ci DEFAULT NULL,
  `https` int(11) DEFAULT NULL,
  `www` int(11) DEFAULT NULL,
  `version` varchar(10) COLLATE utf8_unicode_ci DEFAULT NULL,
  `installed` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

INSERT INTO `general-settings` (`id`, `title`, `description`, `keywords`, `facebookAppId`, `coverImage`, `backgroundImage`, `logo`, `logoLight`, `favicon`, `https`, `www`, `version`, `installed`) VALUES
(1,	'Video Downloader Script',	'The #1 Free Online Video Downloader allows you to download videos from Facebook, Vimeo, Break, Liveleak, Instagram, Soundcloud, Imgur and many more!',	'download facebook videos, video downloader, facebook downloader, download online videos, download streaming videos',	null,	'cover.png',	'bg-cover.jpg',	'logo.png',	'logoLight.png',	'favicon.png',	0,	0,	'1.0',	0);

DROP TABLE IF EXISTS `languages`;
CREATE TABLE `languages` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `code` varchar(10) COLLATE utf8_unicode_ci DEFAULT NULL,
  `flag` varchar(10) COLLATE utf8_unicode_ci DEFAULT NULL,
  `status` int(11) DEFAULT '0',
  `displayOrder` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `status` (`status`),
  KEY `languageName` (`name`),
  KEY `languageCode` (`code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

INSERT INTO `languages` (`id`, `name`, `code`, `flag`, `status`, `displayOrder`) VALUES
(1,	'English',	'en',	'US',	1,	1),
(2,	'Italiano',	'it',	'IT',	1,	2);

DROP TABLE IF EXISTS `mail-settings`;
CREATE TABLE `mail-settings` (
  `smtpStatus` int(11) DEFAULT NULL,
  `host` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `port` int(11) DEFAULT NULL,
  `username` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `password` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `contactEmail` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

INSERT INTO `mail-settings` (`smtpStatus`, `host`, `port`, `username`, `password`, `contactEmail`) VALUES
(0,	null,	null,	null,	null,	null);

DROP TABLE IF EXISTS `pages`;
CREATE TABLE `pages` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `permalink` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `description` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL,
  `keywords` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL,
  `content` text COLLATE utf8_unicode_ci,
  `position` int(11) DEFAULT '3' COMMENT '1 = Header, 2 = Footer, 3 = Both',
  `status` int(11) DEFAULT NULL,
  `displayOrder` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `permalink` (`permalink`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

DROP TABLE IF EXISTS `social-sharing`;
CREATE TABLE `social-sharing` (
  `status` int(11) DEFAULT NULL,
  `facebookSharing` int(11) DEFAULT NULL,
  `facebookPageName` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `googleplusSharing` int(11) DEFAULT NULL,
  `googleplusPageId` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `twitterSharing` int(11) DEFAULT NULL,
  `twitterTweetText` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `linkedinSharing` int(11) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

INSERT INTO `social-sharing` (`status`, `facebookSharing`, `facebookPageName`, `googleplusSharing`, `googleplusPageId`, `twitterSharing`, `twitterTweetText`, `linkedinSharing`) VALUES
(1,	1,	'nexthon',	1,	'100619388243402364794',	1,	'Download Videos from {{website title}}',	1);

DROP TABLE IF EXISTS `statistics`;
CREATE TABLE `statistics` (
  `date` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `pageViews` bigint(20) DEFAULT '0',
  `uniqueViews` bigint(20) DEFAULT '0',
  `downloads` bigint(20) DEFAULT '0',
  KEY `date` (`date`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;


DROP TABLE IF EXISTS `users`;
CREATE TABLE `users` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `username` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL,
  `email` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL,
  `password` varchar(32) COLLATE utf8_unicode_ci DEFAULT NULL,
  `role` varchar(32) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

ALTER TABLE `general-settings` DROP `facebookAppId`;

ALTER TABLE `general-settings` ADD `allowDirectLink` int NULL AFTER `favicon`;

UPDATE `general-settings` SET `allowDirectLink` = '0';

update `general-settings` SET `version`='1.3';