<?php
$this->load->view("includes/head");
$pageUrl = pageUrl();
?>
<title><?php echo $page['title']." - ".$settings['title']; ?></title>
<meta name="description" content="<?php echo $page['description']; ?>">
<meta name="keywords" content="<?php echo $page['keywords']; ?>">

<!-- Facebook Open Graph Meta Tags -->
<meta property="og:title" content="<?php echo $page['title']." - ".$settings['title']; ?>" />
<meta property="og:description" content="<?php echo $page['description']; ?>" />
<meta property="og:url" content="<?php echo $pageUrl; ?>" />
<meta property="og:type" content="website" />
<meta property="og:image" content="<?php echo $cover['path']; ?>" />
<meta property="og:image:type" content="<?php echo $cover['porperties']['mime']; ?>" />
<meta property="og:image:width" content="<?php echo $cover['porperties'][0]; ?>" />
<meta property="og:image:height" content="<?php echo $cover['porperties'][1]; ?>" />
<meta property="og:image:alt" content="<?php echo $page['title']." - ".$settings['title']; ?>" />
<meta property="fb:app_id" content="<?php echo $facebookAppId; ?>">

<!-- Twitter Meta Tags -->
<meta name="twitter:card" content="website" />
<meta name="twitter:title" content="<?php echo $page['title']." - ".$settings['title']; ?>" />
<meta name="twitter:description" content="<?php echo $page['description']; ?>" />
<meta name="twitter:image" content="<?php echo $cover['path']; ?>" />

<?php
$this->load->view("includes/header");
$this->load->view("includes/url-search");
if($adsSettings['displayOnDynamicPages'] == 1 && $adsSettings['ad728x90Status'] == 1) {
	$this->load->view("includes/ad728x90");
}
?>
<div class="page-content pages">
	<div class="container">
	    <div class="page-inner">
			<h2><?php echo $page['title']; ?></h2>
			<p>
				<?php echo stripcslashes(html_entity_decode($page['content'],ENT_QUOTES,"UTF-8")); ?>
			</p>
	    </div>
	</div>
</div>
<?php
if($adsSettings['displayOnDynamicPages'] == 1 && $adsSettings['ad728x90Status'] == 1) {
	$this->load->view("includes/ad728x90");
}
$this->load->view("includes/footer");
if($adsSettings['displayOnDynamicPages'] == 1 && $adsSettings['popAdStatus'] == 1) {
	$this->load->view("includes/popAd");
}	
$this->load->view("includes/footer-end");
?>