<?php
$this->load->view("includes/head");
$pageUrl = pageUrl();
if(isset($url) && isset($mediaData['found']) && $mediaData['found'] == 1) {
	$title = "Download ".$mediaData['title']." From ".$source." - ".$settings['title'];
	?>
	<title><?php echo $title; ?></title>
	<meta name="description" content="<?php echo $mediaData['description']; ?>">
	<meta name="keywords" content="<?php echo $settings['keywords']; ?>">

	<!-- Facebook Open Graph Meta Tags -->
	<meta property="og:title" content="<?php echo $title; ?>" />
	<meta property="og:description" content="<?php echo $mediaData['description']; ?>" />
	<meta property="og:url" content="<?php echo $pageUrl; ?>" />
	<meta property="og:type" content="website" />
	<meta property="og:image" content="<?php echo $mediaData['cover']['path']; ?>" />
	<meta property="og:image:type" content="<?php echo $mediaData['cover']['porperties']['mime']; ?>" />
	<meta property="og:image:width" content="<?php echo $mediaData['cover']['porperties'][0]; ?>" />
	<meta property="og:image:height" content="<?php echo $mediaData['cover']['porperties'][1]; ?>" />
	<meta property="og:image:alt" content="<?php echo $mediaData['title']; ?>" />
	<meta property="fb:app_id" content="<?php echo $facebookAppId; ?>">

	<!-- Twitter Meta Tags -->
	<meta name="twitter:card" content="website" />
	<meta name="twitter:title" content="<?php echo $title; ?>" />
	<meta name="twitter:description" content="<?php echo $mediaData['description']; ?>" />
	<meta name="twitter:image" content="<?php echo $mediaData['cover']['path']; ?>" />
	<?php 
}
else {
	?>
	<title><?php echo $settings['title']; ?></title>
	<meta name="description" content="<?php echo $settings['description']; ?>">
	<meta name="keywords" content="<?php echo $settings['keywords']; ?>">

	<!-- Facebook Open Graph Meta Tags -->
	<meta property="og:title" content="<?php echo $settings['title']; ?>" />
	<meta property="og:description" content="<?php echo $settings['description']; ?>" />
	<meta property="og:url" content="<?php echo $pageUrl; ?>" />
	<meta property="og:type" content="website" />
	<meta property="og:image" content="<?php echo $cover['path']; ?>" />
	<meta property="og:image:type" content="<?php echo $cover['porperties']['mime']; ?>" />
	<meta property="og:image:width" content="<?php echo $cover['porperties'][0]; ?>" />
	<meta property="og:image:height" content="<?php echo $cover['porperties'][1]; ?>" />
	<meta property="og:image:alt" content="<?php echo $settings['title']; ?>" />
	<meta property="fb:app_id" content="<?php echo $facebookAppId; ?>">

	<!-- Twitter Meta Tags -->
	<meta name="twitter:card" content="website" />
	<meta name="twitter:title" content="<?php echo $settings['title']; ?>" />
	<meta name="twitter:description" content="<?php echo $settings['description']; ?>" />
	<meta name="twitter:image" content="<?php echo $cover['path']; ?>" />
	<?php 
}
?>
<!-- Google Structured Data -->
<script type='application/ld+json'>{"@context":"http:\/\/schema.org","@type":"WebSite","@id":"#website","url":"<?php echo base_url(); ?>","name":"<?php echo $settings['title']; ?>","potentialAction":{"@type":"SearchAction","target":"<?php echo base_url("?url={url}"); ?>","query-input":"required name=url"}}</script>

<?php
$this->load->view("includes/header"); 
$this->load->view("includes/url-search");
if($socialSharing['status'] == 1) {
	$this->load->view("follow-us");
}
if($adsSettings['displayOnHomePage'] == 1 && $adsSettings['ad728x90Status'] == 1) {
	$this->load->view("includes/ad728x90");
}
?>

<div id="loader-div" class="p-t-40 p-b-40 text-center hide">
	<img src="<?php echo base_url("assets/images/loader.svg"); ?>" />
</div>
<div class="page-content">
	<div id="video-data">
		<?php
		if(isset($url)) {
			?>
			<div class="container">
				<?php
				if(isset($mediaData['found']) && $mediaData['found'] == 1 && $error == false) {
					if($settings['allowDirectLink'] == 1 && $source == "dailymotion") {
						?>
						<div id="download-modal" data-backdrop="static" data-keyboard="false" class="modal fade" role="dialog">
							<div class="modal-dialog">
								<div class="modal-content">
									<div class="modal-header">
										<button type="button" class="close" data-dismiss="modal">&times;</button>
										<h4 class="modal-title">
											<?php echo showLanguageVar($languageValues,"download"); ?> : <?php echo $mediaData['title']; ?>
										</h4>
									</div>
									<form method="post" id="download-dailymotion-form">
										<div class="modal-body">
											<p><?php echo showLanguageVar($languageValues,"dm_download_guide_heading"); ?><p>
											<ol>
												<li>
													<p><?php echo showLanguageVar($languageValues,"dm_download_guide_step_1",true); ?> <a target="_blank" href="<?php echo $url; ?>"><?php echo showLanguageVar($languageValues,"here"); ?></a></p>
												</li>
												<li>
													<p><?php echo showLanguageVar($languageValues,"dm_download_guide_step_2",true); ?></p>
												</li>
												<li>
													<p><?php echo showLanguageVar($languageValues,"dm_download_guide_step_3",true); ?></p>
												</li>
												<li>
													<p><?php echo showLanguageVar($languageValues,"dm_download_guide_step_4",true); ?></p>
												</li>
												<li>
													<p><?php echo showLanguageVar($languageValues,"dm_download_guide_step_5",true); ?></p>
												</li>
											</ol>
											<div class="form-group">
												<textarea id="source-dm" class="form-control" rows="6" placeholder="<?php echo showLanguageVar($languageValues,"paste_source_code_here"); ?>" required="required"></textarea>
											</div>
										</div>
										<div class="modal-footer">
											<button id="submit-dm-source" type="submit" class="btn btn-success"><?php echo showLanguageVar($languageValues,"generate_link"); ?></button>
											<a download="download" id="download-dm-video" class="btn btn-primary hide"></a>
											<button type="button" class="btn btn-default" data-dismiss="modal"><?php echo showLanguageVar($languageValues,"close"); ?></button>
										</div>
									</form>
								</div>
							</div>
						</div>
						<?php
					}
					
					if(isset($mediaData['embedIframe']) && !empty($mediaData['embedIframe'])) {
						?>
						<div id="embedModal" class="modal fade" role="dialog">
							<button type="button" class="cross-modal close" data-dismiss="modal">&times;</button>
							<div class="modal-dialog">
								<div class="modal-content">
									<div id="player-body" class="modal-body">
										<?php 
										if(isset($mediaData['embedIframeDirect']) && $mediaData['embedIframeDirect'] == "true") {
											echo $mediaData['embedIframe']; 
										}
										?>
									</div>
								</div>
							</div>
						</div>
						<?php
					}
					?>
					<div class="video-holder">
						<div class="coll-left">
							<div <?php echo(isset($mediaData['embedIframe']) && !empty($mediaData['embedIframe']) ? 'data-toggle="modal" data-target="#embedModal"' : ""); ?> class="video-thumb">
								<?php
								if(isset($mediaData['time']) && $mediaData['time'] != "empty") {
									?>
									<span class="time"><?php echo $mediaData['time']; ?></span>
									<?php
								}
								?>
								<img class="img-responsive" src="<?php echo $mediaData['image']; ?>" />
								<?php
								if(isset($mediaData['embedIframe']) && !empty($mediaData['embedIframe'])) {
									?>
									<div class="playIcon"><i aria-hidden="true" class="fa fa-play-circle"></i></div>
									<?php
								}
								?>
							</div>
							<div class="video-details">
								<div class="title">
									<?php echo $mediaData['title']; ?>
								</div>
								<div class="source">
									<?php echo showLanguageVar($languageValues,"source"); ?>:<span><?php echo $source; ?></span>
								</div>
								<div class="share-btns">
									<a data-width="560" data-height="662" class="share-link fb" href="https://www.facebook.com/sharer/sharer.php?display=popup&u=<?php echo urlencode($pageUrl); ?>">
										<i class="fa fa-facebook"></i> <span><?php echo showLanguageVar($languageValues,"share_on_facebook"); ?></span>
									</a>
									<a data-width="560" data-height="450" class="share-link tw" href="http://twitter.com/share?url=<?php echo urlencode($pageUrl); ?>&text=<?php echo $title; ?>">
										<i class="fa fa-twitter"></i> <span><?php echo showLanguageVar($languageValues,"share_on_twitter"); ?></span>
									</a>
									<a data-width="410" data-height="520" class="share-link gp" href="https://plus.google.com/share?url=<?php echo urlencode($pageUrl); ?>">
										<i class="fa fa-google-plus"></i> <span><?php echo showLanguageVar($languageValues,"share_on_googleplus"); ?></span>
									</a>
									<a data-width="567" data-height="567" class="share-link vk" href="http://vkontakte.ru/share.php?url=<?php echo urlencode($pageUrl); ?>">
										<i class="fa fa-vk"></i> <span><?php echo showLanguageVar($languageValues,"share_on_vk"); ?></span>
									</a>
									<?php
									if(isset($isMobile) && $isMobile == true) {
										?>
										<a class="wa" href="whatsapp://send?text=*<?php echo $title; ?>* %0A %0A <?php echo $pageUrl; ?>">
											<i class="fa fa-whatsapp"></i> <span><?php echo showLanguageVar($languageValues,"share_on_whatsapp"); ?></span>
										</a>
										<?php
									}
									?>
								</div>
							</div>
							<?php
							if($adsSettings['displayOnHomePage'] == 1 && $adsSettings['ad250x250Status'] == 1) {
								$this->load->view("includes/ad250x250");
							}
							?>
						</div>
						<div class="coll-right">
							<?php
							if(isset($mediaData['videos']) && count($mediaData['videos']) > 0) {
								?>
								<div class="type-divider">
									<div class="video"><span><?php echo showLanguageVar($languageValues,"video"); ?></span></div>
								</div>
								<div class="table-responsive p-b-30">
									<table class="formats-table table">
										<thead>
											<tr>
												<th class="quality" width="25%">
													<?php echo showLanguageVar($languageValues,"quality"); ?>
												</th>
												<th class="format" width="25%">
													<?php echo showLanguageVar($languageValues,"format"); ?>
												</th>
												<th class="size" width="25%">
													<?php echo showLanguageVar($languageValues,"size"); ?>
												</th>
												<th class="downloads" width="25%">
													<?php echo showLanguageVar($languageValues,"downloads"); ?>
												</th>
											</tr>
										</thead>
										<tbody>
											<?php
											foreach($mediaData['videos'] as $video) {
												?>
												<tr>
													<td><?php echo $video['data']['resolution']; ?></td>
													<td><?php echo strtoupper($video['data']['ext']); ?></td>
													<td id="format-id-size-<?php echo $video['formatId']; ?>">
														<?php echo($video['size'] != "unknown" ? $video['size'] : '<img width="27" src="'.base_url("assets/images/loader.svg").'" />'); ?>
													</td>
													<td>
														<?php $downloadUrl = ($settings['allowDirectLink'] == 1 ? $video['url'] : base_url("main/download?source=".$source."&id=".$mediaData['id']."&format=".$video['formatId']."&url=".urlencode($video['url'])."&title=".urlencode($video['title']))); ?>
														<a <?php echo($settings['allowDirectLink'] == 1 ? 'download="'.$video['title'].'"' : ""); ?> data-size="<?php echo $video['size']; ?>" data-formatId="<?php echo $video['formatId']; ?>" data-href="<?php echo $video['url']; ?>" href="<?php echo $downloadUrl; ?>" class="vd-down btn btn-default btn-download"><?php echo showLanguageVar($languageValues,"download"); ?></a>
													</td>
												</tr>
												<?php
											}
											?>
										</tbody>
									</table>
								</div>
								<?php
							}
							if(isset($mediaData['videosOnly']) && count($mediaData['videosOnly']) > 0) {
							?>
								<div class="video-only">
									<span class="head-title"><?php echo showLanguageVar($languageValues,"video_only"); ?>
										<span class="fa-stack">
											<i class="fa fa-volume-up fa-stack-1x"></i>
											<i class="fa fa-ban fa-stack-2x text-danger"></i>
										</span>
										<a class="pull-right show-btn"><?php echo showLanguageVar($languageValues,"more"); ?> <i class="fa fa-caret-down"></i></a>
									</span>
									<div class="video-only-table hide">
										<div class="table-responsive">
											<table class="formats-table table">
												<thead>
													<tr>
														<th class="quality" width="25%">
															<?php echo showLanguageVar($languageValues,"quality"); ?>
														</th>
														<th class="format" width="25%">
															<?php echo showLanguageVar($languageValues,"format"); ?>
														</th>
														<th class="size" width="25%">
															<?php echo showLanguageVar($languageValues,"size"); ?>
														</th>
														<th class="downloads" width="25%">
															<?php echo showLanguageVar($languageValues,"downloads"); ?>
														</th>
													</tr>
												</thead>
												<tbody>
													<?php
													foreach($mediaData['videosOnly'] as $video) {
														?>
														<tr>
															<td><?php echo $video['data']['resolution']; ?></td>
															<td><?php echo strtoupper($video['data']['ext']); ?></td>
															<td id="format-id-size-<?php echo $video['formatId']; ?>">
																<?php echo($video['size'] != "unknown" ? $video['size'] : '<img width="27" src="'.base_url("assets/images/loader.svg").'" />'); ?>
															</td>
															<td>
																<?php $downloadUrl = ($settings['allowDirectLink'] == 1 ? $video['url'] : base_url("main/download?source=".$source."&id=".$mediaData['id']."&format=".$video['formatId']."&url=".urlencode($video['url'])."&title=".urlencode($video['title']))); ?>
																<a <?php echo($settings['allowDirectLink'] == 1 ? 'download="'.$video['title'].'"' : ""); ?> data-size="<?php echo $video['size']; ?>" data-formatId="<?php echo $video['formatId']; ?>" data-href="<?php echo $video['url']; ?>" href="<?php echo $downloadUrl; ?>" class="btn btn-default btn-download"><?php echo showLanguageVar($languageValues,"download"); ?></a>
															</td>
														</tr>
														<?php
													}
													?>
												</tbody>
											</table>
										</div>
									</div>
								</div>
								<?php
							}
							if(isset($mediaData['audios']) && count($mediaData['audios']) > 0) {
							?>
								<div class="type-divider">
									<div class="audio"><span><?php echo showLanguageVar($languageValues,"audio"); ?></span></div>
								</div>
								<div class="table-responsive">
									<table class="formats-table table">
										<thead>
											<tr>
												<th class="quality" width="25%">
													<?php echo showLanguageVar($languageValues,"quality"); ?>
												</th>
												<th class="format" width="25%">
													<?php echo showLanguageVar($languageValues,"format"); ?>
												</th>
												<th class="size" width="25%">
													<?php echo showLanguageVar($languageValues,"size"); ?>
												</th>
												<th class="downloads" width="25%">
													<?php echo showLanguageVar($languageValues,"downloads"); ?>
												</th>
											</tr>
										</thead>
										<tbody>
											<?php
											foreach($mediaData['audios'] as $audio) {
												?>
												<tr>
													<td><?php echo $audio['data']['resolution']; ?></td>
													<td><?php echo strtoupper($audio['data']['ext']); ?></td>
													<td id="format-id-size-<?php echo $audio['formatId']; ?>">
														<?php echo($audio['size'] != "unknown" ? $audio['size'] : '<img width="27" src="'.base_url("assets/images/loader.svg").'" />'); ?>
													</td>
													<td>
														<?php $downloadUrl = ($settings['allowDirectLink'] == 1 ? $audio['url'] : base_url("main/download?source=".$source."&id=".$mediaData['id']."&format=".$audio['formatId']."&url=".urlencode($audio['url'])."&title=".urlencode($audio['title']))); ?>
														<a <?php echo($settings['allowDirectLink'] == 1 ? 'download="'.$audio['title'].'"' : ""); ?> data-size="<?php echo $audio['size']; ?>" data-formatId="<?php echo $audio['formatId']; ?>" data-href="<?php echo $audio['url']; ?>" href="<?php echo $downloadUrl; ?>" class="btn btn-default btn-download"><?php echo showLanguageVar($languageValues,"download"); ?></a>
													</td>
												</tr>
												<?php
											}
											?>
										</tbody>
									</table>
								</div>
								<?php
							}
							if(isset($mediaData['gifs']) && count($mediaData['gifs']) > 0) {
							?>
								<div class="type-divider">
									<div class="gif"><span><?php echo showLanguageVar($languageValues,"gif"); ?></span></div>
								</div>
								<div class="table-responsive">
									<table class="formats-table table">
										<thead>
											<tr>
												<th class="quality" width="25%">
													<?php echo showLanguageVar($languageValues,"quality"); ?>
												</th>
												<th class="format" width="25%">
													<?php echo showLanguageVar($languageValues,"format"); ?>
												</th>
												<th class="size" width="25%">
													<?php echo showLanguageVar($languageValues,"size"); ?>
												</th>
												<th class="downloads" width="25%">
													<?php echo showLanguageVar($languageValues,"downloads"); ?>
												</th>
											</tr>
										</thead>
										<tbody>
											<?php
											foreach($mediaData['gifs'] as $gif) {
												?>
												<tr>
													<td><?php echo $gif['data']['resolution']; ?></td>
													<td><?php echo strtoupper($gif['data']['ext']); ?></td>
													<td id="format-id-size-<?php echo $gif['formatId']; ?>">
														<?php echo($gif['size'] != "unknown" ? $gif['size'] : '<img width="27" src="'.base_url("assets/images/loader.svg").'" />'); ?>
													</td>
													<td>
														<?php $downloadUrl = ($settings['allowDirectLink'] == 1 ? $gif['url'] : base_url("main/download?source=".$source."&id=".$mediaData['id']."&format=".$gif['formatId']."&url=".urlencode($gif['url'])."&title=".urlencode($gif['title']))); ?>
														<a <?php echo($settings['allowDirectLink'] == 1 ? 'download="'.$gif['title'].'"' : ""); ?> data-size="<?php echo $gif['size']; ?>" data-formatId="<?php echo $gif['formatId']; ?>" data-href="<?php echo $gif['url']; ?>" href="<?php echo $downloadUrl; ?>" class="btn btn-default btn-download"><?php echo showLanguageVar($languageValues,"download"); ?></a>
													</td>
												</tr>
												<?php
											}
											?>
										</tbody>
									</table>
								</div>
								<?php
							}
							?>
						</div>
						<div class="clearfix"></div>
					</div>
					<?php
				}
				else {
					?>
					<div class="alert alert-<?php echo $errorType; ?> alert-dismissable">
						<a class="close" data-dismiss="alert" aria-label="close">&times;</a>
						<strong><?php echo showLanguageVar($languageValues,"error"); ?> !</strong> <?php echo $errorMsg; ?>
					</div>
					<?php
				}
				?>
			</div>
			<?php
		}
		?>
	</div>
	
	<div class="features-list">
	    <div class="container">
			<h2 class="hide"><?php echo showLanguageVar($languageValues,"features_heading"); ?></h2>
			<div class="row p-b-30">
				<div class="col-xs-12 col-md-5">
					<h3><?php echo showLanguageVar($languageValues,"multiple_sources_heading"); ?></h3>
					<p>
						<?php echo showLanguageVar($languageValues,"multiple_sources_description"); ?>
					</p>
				</div>
				<div class="col-xs-12 col-md-7">
					<img class="img-responsive" src="<?php echo base_url("assets/images/macbook-bg.png")?>" alt="Multiple Sources">
				</div>
			</div>
			<div class="row p-t-40 p-b-20">
				<div class="col-xs-12 col-md-6 pull-right">
					<h3><?php echo showLanguageVar($languageValues,"multiple_formats_heading"); ?></h3>
					<p>
						<?php echo showLanguageVar($languageValues,"multiple_formats_description"); ?>
					</p>
				</div>
				<div class="col-xs-12 col-md-6 pull-left">
					<img class="img-responsive formates-image" src="<?php echo base_url("assets/images/formats.png"); ?>" alt="Multiple Formats">
				</div>
			</div>
	    </div>
	</div>
	
	<?php
	if($adsSettings['displayOnHomePage'] == 1 && $adsSettings['ad728x90Status'] == 1) {
		$this->load->view("includes/ad728x90");
	}
	?>
	
	<div class="bg-alt">
	    <div class="container">
			<div class="supported-sources">
				<h2><?php echo showLanguageVar($languageValues,"supported_sources"); ?> <span class="badge custom"><?php echo count($sources); ?></span></h2>
				<div class="s-list">
					<?php
					foreach($sources as $source) {
						?>
						<div class="product-sList">
							<div class="s-img">
								<img class="img-responsive" src="<?php echo base_url("assets/images/sources/".$source['icon']); ?>">
							</div>
							<div class="s-name"><?php echo ucfirst($source['name']); ?></div>
						</div>
						<?php
					}
					?>
					<div class="product-sList">
						<div class="s-img">
							<img src="<?php echo base_url("assets/images/sources/more.png"); ?>">
						</div>
						<div class="s-name"><?php echo showLanguageVar($languageValues,"more_coming_soon"); ?></div>
					</div>
				</div>
			</div>
	    </div>
	</div>
</div>
<?php $this->load->view("includes/footer"); ?>
<script id="script-append" type="text/javascript">
	$(document).ready(function() {
		function showVideo(ajaxresult,fromHistory) {
			$(document).off("click",".video-thumb");
			$(document).off("click",".vd-down");
			$("#loader-div").addClass("hide");
			$("#video-data").removeClass("hide").html(ajaxresult.pageContent);
			$("#scripts").remove();
			$("#script-append").after(ajaxresult.scriptContent);
			if(ajaxresult.found == 1 && fromHistory == false) {
				var state = ajaxresult;
				window.history.pushState(state,ajaxresult.title,baseUrl+"?url="+ajaxresult.url);
				document.title = ajaxresult.title;
			}
			else {
				$("#url").val(ajaxresult.url);
			}
			$('html, body').animate({
				scrollTop: $("#video-data").offset().top
			},800);
		}
		
		$("#url-form").submit(function(e) {
			e.preventDefault();
			var url = $("#url").val();
			if(url != null) {
				$("#loader-div").removeClass("hide");
				$("#video-data").html("").addClass("hide");
				$.ajax ({
					type: "POST",
					url: baseUrl+"main/get_video_data_ajax",
					data: {"url":url},
					dataType: "json",
					success: function(ajaxresult) {
						showVideo(ajaxresult,false);
					}
				});
			}
		});
		
		$(window).on("popstate", function () {
			if (history.state) {
				showVideo(history.state,true);
			}
			else {
				$("#video-data").html("").addClass("hide");
				$("#scripts").remove();
				$("#url").val("");
			}
		});
	});
	var lang_vars = [];
	lang_vars['download'] = '<?php echo showLanguageVar($languageValues,"download"); ?>';
	lang_vars['more'] = '<?php echo showLanguageVar($languageValues,"more"); ?>';
	lang_vars['less'] = '<?php echo showLanguageVar($languageValues,"less"); ?>';
</script>
<?php
if(isset($url) && isset($mediaData['found']) && $mediaData['found'] == 1) {
	?>
	<div id="scripts">
		<?php
		if(isset($mediaData['scriptFiles']) && !empty($mediaData['scriptFiles'])) {
			echo $mediaData['scriptFiles'];
		}
		?>
		<script type="text/javascript" src="<?php echo base_url("assets/js/popup.js"); ?>"></script>
		<script type="text/javascript">
			var videoUrl = "<?php echo $url; ?>";
			$(document).ready(function() {
				$('.share-link').on("click", function(e) {
					$(this).customerPopup(e,$(this).attr('data-width'),$(this).attr("data-height"),"yes");
				});
				<?php
				if(isset($mediaData['videosOnly']) && count($mediaData['videosOnly']) > 0) {
					?>
					$('.show-btn').on('click', function(event) {
						var table = $('.video-only-table');
						var btn = $('.show-btn');
						if (table.hasClass('hide')) {
							table.removeClass('hide');
							btn.html(lang_vars['less']+' <i class="fa fa-caret-up"></i>');
						}
						else {
							table.addClass('hide');
							btn.html(lang_vars['more']+' <i class="fa fa-caret-down"></i>');
						}
					});
					<?php
				}
				if(isset($mediaData['script']) && !empty($mediaData['script'])) {
					echo $mediaData['script'];
				}
				?>
			});
		</script>
		<script type="text/javascript" src="<?php echo base_url("assets/js/main.js"); ?>"></script>
	</div>
	<script type="text/javascript">
		var curState = [];
		curState.pageContent = $("#video-data").html();
		curState.scriptContent = $("#scripts").get(0).outerHTML;
		curState.title = document.title;
		curState.found = 1;
		curState.url = $("#url").val();
		window.history.pushState(curState,document.title,'<?php echo $pageUrl; ?>');
	</script>
	<?php
}
if($adsSettings['displayOnHomePage'] == 1 && $adsSettings['popAdStatus'] == 1) {
	$this->load->view("includes/popAd");
}	
$this->load->view("includes/footer-end");
?>