<?php if($analytics['status'] == 1) { echo stripcslashes(html_entity_decode($analytics['code'],ENT_QUOTES,"UTF-8")); } ?>
</head>
<body>
	<header>
		<div class="navbar navbar-default navbar-static-top transparent" role="navigation">
			<div class="container">
				<div class="navbar-header">
					<button class="navbar-toggle collapsed" type="button" data-toggle="collapse" data-target="#main-navbar">
						<span class="sr-only">Toggle navigation</span>
						<span class="icon-bar top-bar"></span>
						<span class="icon-bar middle-bar"></span>
						<span class="icon-bar bottom-bar"></span>
					</button>
					<a class="navbar-brand" href="<?php echo base_url(); ?>">
						<img class="img-responsive" src="<?php echo base_url("assets/images/".$settings['logo']); ?>" />
					</a>
				</div>
				<nav class="collapse navbar-collapse" id="main-navbar">
					<ul class="nav navbar-nav navbar-right">
						<li>
							<a class="btn normal-lined" href="<?php echo base_url(); ?>"><?php echo showLanguageVar($languageValues,"home"); ?></a>
						</li>
						<?php
						foreach($headerPages as $page) {
							?>
							<li>
								<a class="btn normal-lined" href="<?php echo base_url("page/".$page['permalink']); ?>"><?php echo $page['title']; ?></a>
							</li>
							<?php
						}
						?>
						<li>
							<a class="btn normal-lined" href="<?php echo base_url("contact"); ?>"><?php echo showLanguageVar($languageValues,"contact_us"); ?></a>
						</li>
						<?php
						if(count($languages) > 1) {
							?>
							<li class="dropdown">
								<a class="btn normal-lined dropdown-toggle" id="languages-dropdown" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
									<img width="20" src="<?php echo base_url("assets/countries/flags/".$language['flag'].".svg"); ?>">
									<?php echo strtoupper($language['code']); ?>
									<span class="caret"></span>
								</a>
								<ul class="dropdown-menu language-dropdown" aria-labelledby="languages-dropdown">
									<?php
									foreach($languages as $languageRow) {
										?>
										<li class="lang-li <?php echo($language['id'] == $languageRow['id'] ? "active" : "not-active"); ?>">
											<a href="<?php echo base_url("main/select-language/".$languageRow['id']); ?>">
												<img width="20" src="<?php echo base_url("assets/countries/flags/".$languageRow['flag'].".svg"); ?>">
												<?php echo $languageRow['name']; ?>
											</a>
										</li>
										<?php
									}
									?>
								</ul>
							</li>
							<?php
						}
						?>
					</ul>
				</nav>
			</div>
		</div> 
	</header>