<!DOCTYPE html>
<html>
	<head>
		<meta charset="UTF-8" />
		<meta name="viewport" content="width=device-width, initial-scale=1">
		<link rel="icon" href="<?php echo base_url("assets/images/".$settings['favicon']); ?>">
		<title><?php echo $settings['title']." - Forgot Password"; ?></title>
		<meta name="description" content="<?php echo $settings['description']; ?>">
		<meta name="keywords" content="<?php echo $settings['keywords']; ?>">
		<link type="text/css" href="<?php echo base_url("assets/bootstrap/css/bootstrap.min.css"); ?>" rel="stylesheet">
		<link type="text/css" href="<?php echo base_url("assets/font-awesome/css/font-awesome.min.css"); ?>" rel="stylesheet">
		<link type="text/css" href="<?php echo base_url("assets/css/vert-offset.css"); ?>" rel="stylesheet">
		<link type="text/css" href="<?php echo base_url("assets/css/style.css"); ?>" rel="stylesheet">
		<style>
			html, body{
				height: 100%;
			}
		</style>
	</head>
	<body>
		 
			<div class="login-box login-sidebar">
				<div class="white-box form-horizontal form-material">
					<a href="<?php echo base_url(); ?>" class="text-center center-block">
						<img src="<?php echo base_url("assets/images/".$settings['logo']); ?>" alt="Logo">
					</a>
					<?php
					if(isset($_POST['submit'])) {
						if($error == true) {
							?>
							<div class="m-t-40 alert alert-danger">
								<a class="close" data-dismiss="alert" aria-label="close">&times;</a>
								<i class="fa fa-warning"></i> <?php echo $message; ?>
							</div>
							<?php
						}
						else {
							?>
							<div class="m-t-40 alert alert-success">
								<a class="close" data-dismiss="alert" aria-label="close">&times;</a>
								<i class="fa fa-check-square-o"></i> <?php echo $message; ?>
							</div>
							<?php
						}
					}
					?>
					<form role="form" method="post" action="<?php echo base_url(AUTH_CONTROLLER."/forgot-password"); ?>">
						<div class="form-group m-t-20">
							<div class="col-xs-12">
								<div class="enter-forgot">Enter Username or Email below to reset your password</div>
							</div>
						</div>
						<div class="form-group">
							<div class="col-xs-12">
								<input type="text" class="form-control login-controler" id="uoe" name="uoe" placeholder="Enter Username or Email" value="<?php echo(isset($uoe) ? $uoe : ""); ?>" required autofocus />
							</div>
						</div>
						<?php
						if(isset($captchaCheck) && $captchaCheck == true) {
							?>
							<div class="form-group">
								<div class="col-md-12">
									<div style="display: inline-block;">
										<div class="g-recaptcha" data-sitekey="<?php echo $captchaSettings['siteKey']; ?>"></div>
									</div>
								</div>
							</div>
							<?php
						}
						?>
						<div class="form-group text-center m-t-20">
							<div class="col-xs-12">
								<button class="btn btn-block text-uppercase login-btn" type="submit" name="submit" ><i class="fa fa-window-restore"></i> Reset</button>
							</div>
						</div>
						<a class="text-center center-block text-dark" href="<?php echo base_url(AUTH_CONTROLLER."/login"); ?>"><i class="fa fa-reply" aria-hidden="true"></i> Back to Login</a>
					</form>
				</div>
			</div>
			
		<script type="text/javascript" src="<?php echo base_url("assets/jquery/jquery.min.js"); ?>"></script>
		<script type="text/javascript" src="<?php echo base_url("assets/bootstrap/js/bootstrap.min.js"); ?>"></script>
		<?php
		if(isset($captchaCheck) && $captchaCheck == true) {
			?>
			<script type="text/javascript" src="https://www.google.com/recaptcha/api.js"></script>
			<?php
		}
		?>
	</body>
</html>