<?php
$this->load->view("includes/head");
$pageUrl = pageUrl();
?>
<title><?php echo "Contact Us - ".$settings['title']; ?></title>
<meta name="description" content="<?php echo $settings['description']; ?>">
<meta name="keywords" content="<?php echo $settings['keywords']; ?>">

<!-- Facebook Open Graph Meta Tags -->
<meta property="og:title" content="<?php echo "Contact Us  - ".$settings['title']; ?>" />
<meta property="og:description" content="<?php echo $settings['description']; ?>" />
<meta property="og:url" content="<?php echo $pageUrl; ?>" />
<meta property="og:type" content="website" />
<meta property="og:image" content="<?php echo $cover['path']; ?>" />
<meta property="og:image:type" content="<?php echo $cover['porperties']['mime']; ?>" />
<meta property="og:image:width" content="<?php echo $cover['porperties'][0]; ?>" />
<meta property="og:image:height" content="<?php echo $cover['porperties'][1]; ?>" />
<meta property="og:image:alt" content="<?php echo "Contact Us  - ".$settings['title']; ?>" />
<meta property="fb:app_id" content="<?php echo $facebookAppId; ?>">

<!-- Twitter Meta Tags -->
<meta name="twitter:card" content="website" />
<meta name="twitter:title" content="<?php echo "Contact Us  - ".$settings['title']; ?>" />
<meta name="twitter:description" content="<?php echo $settings['description']; ?>" />
<meta name="twitter:image" content="<?php echo $cover['path']; ?>" />

<?php
$this->load->view("includes/header");
$this->load->view("includes/url-search");
if($adsSettings['displayOnContactPage'] == 1 && $adsSettings['ad728x90Status'] == 1) {
	$this->load->view("includes/ad728x90");
}
?>
<div class="page-content pages">
	<div class="container">
		<div class="page-inner">
			<h2><?php echo showLanguageVar($languageValues,"contact_page_heading"); ?></h2>
			<div class="contact-us">
				<?php
				if(isset($_POST['submit'])) {
					if($error == true) {
						?>
						<div class="alert alert-danger">
							<a class="close" data-dismiss="alert" aria-label="close">&times;</a>
							<i class="fa fa-warning"></i> Some error occured cannot send message.
						</div>
						<?php
					}
					else {
						?>
						<div class="alert alert-success">
							<a class="close" data-dismiss="alert" aria-label="close">&times;</a>
							<i class="fa fa-check-square-o"></i> Your message has been received.
						</div>
						<?php
					}
				}
				?>
				<form method="post" action="<?php echo base_url("contact"); ?>">
					<div class="row">
						<div class="col-md-4">
							<div class="form-group">
								<input class="form-control" type="text" name="name" placeholder="<?php echo showLanguageVar($languageValues,"enter_your_name"); ?>" value="<?php echo(isset($name) && $error == true ? $name : ""); ?>" required />
								<?php
								if(isset($nameError)) {
									?>
									<div class="label label-danger"><?php echo $nameError; ?></div>
									<?php
								}
								?>
							</div>
						</div>
						<div class="col-md-4">
							<div class="form-group">
								<input class="form-control" type="email" name="email" placeholder="<?php echo showLanguageVar($languageValues,"enter_your_email"); ?>" value="<?php echo(isset($email) && $error == true ? $email : ""); ?>" required />
								<?php
								if(isset($emailError)) {
									?>
									<div class="label label-danger"><?php echo $emailError; ?></div>
									<?php
								}
								?>
							</div>
						</div>
						<div class="col-md-4">
							<div class="form-group">
								<input class="form-control" type="text" name="subject" placeholder="<?php echo showLanguageVar($languageValues,"enter_subject"); ?>" value="<?php echo(isset($subject) && $error == true ? $subject : ""); ?>" required />
								<?php
								if(isset($subjectError)) {
									?>
									<div class="label label-danger"><?php echo $subjectError; ?></div>
									<?php
								}
								?>
							</div>
						</div>
					</div>
					<div class="row">
						<div class="col-md-12">
							<div class="form-group">
								<textarea rows="5" name="message" class="form-control" placeholder="<?php echo showLanguageVar($languageValues,"enter_your_message"); ?>" required><?php echo(isset($message) && $error == true ? $message : ""); ?></textarea>
								<?php
								if(isset($messageError)) {
									?>
									<div class="label label-danger"><?php echo $messageError; ?></div>
									<?php
								}
								?>
							</div>
						</div>
					</div>
					<?php
					if(isset($captchaCheck) && $captchaCheck == true) {
						?>
						<div class="row">
							<div class="col-md-12">
								<div class="form-group">
									<div style="display: inline-block;">
										<div class="g-recaptcha" data-sitekey="<?php echo $captchaSettings['siteKey']; ?>"></div>
									</div>
									<?php
									if(isset($captchaError)) {
										?>
										<div>
											<span class="label label-danger"><?php echo $captchaError; ?></span>
										</div>
										<?php
									}
									?>
								</div>
							</div>
						</div>
						<?php
					}
					?>
					<div class="row">
						<div class="col-md-12">
							<div class="form-group">
								<button class="btn btn-default" name="submit" type="submit"><i class="fa fa-send"></i> &nbsp;<?php echo showLanguageVar($languageValues,"send"); ?></button>
							</div>
						</div>
					</div>
				</form>
			</div>
		</div>
	</div>
</div>
<?php
if($adsSettings['displayOnContactPage'] == 1 && $adsSettings['ad728x90Status'] == 1) {
	$this->load->view("includes/ad728x90");
}
$this->load->view("includes/footer");
if(isset($captchaCheck) && $captchaCheck == true) {
	?>
	<script type="text/javascript" src="https://www.google.com/recaptcha/api.js"></script>
	<?php
}
if($adsSettings['displayOnContactPage'] == 1 && $adsSettings['popAdStatus'] == 1) {
	$this->load->view("includes/popAd");
}	
$this->load->view("includes/footer-end");
?>