<?php $this->load->view("admin/includes/head"); ?>
<link href="<?php echo base_url("assets/jquery-confirm/jquery-confirm.min.css"); ?>" rel="stylesheet" type="text/css">
<title>All Sources - <?php echo $settings['title']; ?></title>
<?php $this->load->view("admin/includes/header"); ?>
<?php $this->load->view("admin/includes/sidebar"); ?> 
<div id="page-wrapper">
	<div class="container-fluid">
		<div class="row bg-title">
			<div class="col-lg-3 col-md-4 col-sm-4 col-xs-12">
				<h4 class="page-title"><i class="fa fa-file-o"></i> All Sources</h4>
			</div>
			<div class="col-lg-9 col-sm-8 col-md-8 col-xs-12">
				<ol class="breadcrumb">
					<li><a href="<?php echo base_url(ADMIN_CONTROLLER."/dashboard"); ?>">Dashboard</a></li>
					<li class="active">Sources</li>
				</ol>
			</div>
		</div>
		<p><small><strong>Note : </strong>Drag the sources to change their order</small></p>
		<div class="row">
			<div class="col-md-12">
				<div class="white-box">
					<ul class="list-group">
						<li class="active list-group-item">
							<div class="row">
								<div class="col-xs-3">Name</div>
								<div class="col-xs-3">Link Cache Time <small>(Seconds)</small></div>
								<div class="col-xs-2">Icon</div>
								<div class="col-xs-2">Status</div>
								<div class="col-xs-2">Actions</div>
							</div>
						</li>
						<?php
						foreach($sources as $index => $source) {
							?>
							<li class="sources-lists list-group-item" id="<?php echo $index; ?>">
								<div class="row">
									<div class="col-xs-3"><?php echo $source['name']; ?></div>
									<div class="col-xs-3"><?php echo $source['linkCacheTime']; ?></div>
									<div class="col-xs-2">
										<img style="max-width:30px" src="<?php echo base_url("assets/images/sources/".$source['icon']); ?>"/>
									</div>
									<div class="col-xs-2">
										<?php
										if($source['status'] == 1) {
											?>
											<a href="#" data-id="<?php echo $index; ?>" data-name="<?php echo $source['name']; ?>" data-action="off" class="status">
												<span class="label label-success">On</span>
											</a>
											<?php
										}
										else {
											?>
											<a href="#" data-id="<?php echo $index; ?>" data-name="<?php echo $source['name']; ?>" data-action="on" class="status">
												<span class="label label-warning">Off</span>
											</a>
											<?php
										}
										?>
									</div>
									<div class="col-xs-2">
										<a title="Edit Source" href="<?php echo base_url(ADMIN_CONTROLLER."/edit-source/".$index)?>" class="btn btn-xs btn-primary"><i class="fa fa-pencil"></i></a>
									</div>
								</div>
							</li>
							<?php
						}
						?>
					</ul>
				</div>
			</div>
		</div>
	</div>
	<?php $this->load->view("admin/includes/footer-tag"); ?>
</div>
<?php $this->load->view("admin/includes/footer-script-files"); ?>
<script type="text/javascript" src="<?php echo base_url("assets/jquery-ui/jquery-ui.min.js"); ?>"></script>
<script type="text/javascript" src="<?php echo base_url("assets/jquery-confirm/jquery-confirm.min.js"); ?>"></script>
<script type="text/javascript">
	$(document).ready(function() {
		$("ul.list-group").sortable ({ 
			opacity: 0.8, 
			cursor: 'move',
			axis: "y",
			items: ".sources-lists",
			containment: ".white-box",
			update: function(event,ui)  {
				var order = $(this).sortable("toArray");
				$.ajax ({
					type: "POST",
					url: baseURL+adminURL+"/update-sources-order",
					data: {"updateSourcesOrder":"updateSourcesOrder","order":order}
				});
			},
			stop: function() {
				$(".ui-sortable-handle").css ({
					'top' : 'auto',
					'left' : 'auto'
				});
			}
		});
		
		$(".status").click(function(e) {
			e.preventDefault();
			var action = $(this).attr("data-action");
			var contentLine = (action == "on" ? "Do you want to enabled this source?" : "Do you want to disabled this source");
			var context = $(this);
			var alertContext = $.confirm ({
				title: 'Confirm!',
				content: contentLine,
				theme: 'dark',
				buttons: {
					confirm: {
						text: 'Confirm',
						btnClass: 'btn-green',
						action: function(){
							var name = context.attr("data-name");
							var id = context.attr("data-id");
							this.buttons.confirm.setText('Wait <i class="fa fa-spinner fa-spin"></i>');
							$.ajax ({
								type: 'POST',
								dataType: 'json',
								url: baseURL+adminURL+"/change-source-status",
								data: {"changeSourceStatus":"changeSourceStatus","action":action,"name":name,"id":id},
								success: function (result) {
									alertContext.close();
									if(result.status == "success") {
										if(action == "on") {
											context.attr("data-action","off");
											context.html('<span class="label label-success">On</span>');
										}
										else {
											context.attr("data-action","on");
											context.html('<span class="label label-warning">Off</span>');
										}
										$.confirm ({
											title: 'Success!',
											theme: 'dark',
											content: result.message,
											type: 'green',
											typeAnimated: true,
											buttons: {
												close: function () {
												}
											}
										});
									}
								}
							});
							return false;
						}
					},
					close: {
						text: 'Cancel',
						action: function(){}
					}
				}
			});
		});
	});
</script>
<?php $this->load->view("admin/includes/footer-end"); ?>