<?php $this->load->view("admin/includes/head"); ?>
<link href="<?php echo base_url("assets/bootstrap-toggle/css/bootstrap-toggle.min.css"); ?>" rel="stylesheet" type="text/css">
<title>Social Sharing - <?php echo $settings['title']; ?></title>
<?php $this->load->view("admin/includes/header"); ?>
<?php $this->load->view("admin/includes/sidebar"); ?> 
<div id="page-wrapper">
	<div class="container-fluid">
		<div class="row bg-title">
			<div class="col-lg-3 col-md-4 col-sm-4 col-xs-12">
				<h4 class="page-title"><i class="fa fa-share"></i> Social Sharing</h4>
			</div>
			<div class="col-lg-9 col-sm-8 col-md-8 col-xs-12">
				<ol class="breadcrumb">
					<li><a href="<?php echo base_url(ADMIN_CONTROLLER."/dashboard"); ?>">Dashboard</a></li>
					<li class="active">Social Sharing</li>
				</ol>
			</div>
		</div>
		<div class="row">
			<div class="col-md-12">
				<?php
				if(isset($_POST['submit'])) {
					if($error == false) {
						?>
						<div class="alert alert-success">
							<a class="close" data-dismiss="alert" aria-label="close">&times;</a>
							<i class="fa fa-check-square-o"></i> Social sharing settings updated successfully.
						</div>
						<?php
					}
					else {
						?>
						<div class="alert alert-danger">
							<a class="close" data-dismiss="alert" aria-label="close">&times;</a>
							<i class="fa fa-warning"></i> Some error occured cannot update social sharing settings.
						</div>
						<?php
					}
				}
				?>
				<div class="white-box">
					<form method="post" action="<?php echo base_url(ADMIN_CONTROLLER."/social-sharing"); ?>">
						<div class="form-group">
							<label>Status</label>
							<div>
								<input class="status-check" data-div="#settings-panel" type="checkbox" name="status" data-toggle="toggle" data-size="small" data-onstyle="success" <?php echo(isset($status) && $status == 1 ? "checked" : ""); ?> />
							</div>
						</div>
						<div id="settings-panel" class="<?php echo (isset($status) && $status != 1 ? "hide" : ""); ?>">
							<div class="form-group">
								<div class="row">
									<div class="col-xs-6 col-sm-4">
										<label>Facebook Sharing</label>
									</div>
									<div class="col-xs-6 col-sm-4">
										<input class="status-check" data-div="#facebook-sharing" type="checkbox" name="facebookSharing" data-toggle="toggle" data-size="small" data-onstyle="success" <?php echo(isset($facebookSharing) && $facebookSharing == 1 ? "checked" : ""); ?> />
									</div>
								</div>
							</div>
							<div class="form-group <?php echo (isset($facebookSharing) && $facebookSharing != 1 ? "hide" : ""); ?>" id="facebook-sharing">
								<label>Facebook Page Name</label>
								<input type="text" name="facebookPageName" class="form-control" placeholder="Enter Facebook Page Name..." value="<?php echo (isset($facebookPageName) ? $facebookPageName : ""); ?>" />
								<?php
								if(isset($facebookPageNameError)) {
									?>
									<div class="m-t-5 text-danger"><small><?php echo $facebookPageNameError; ?></small></div>
									<?php
								}
								?>
							</div>
							<div class="form-group">
								<div class="row">
									<div class="col-xs-6 col-sm-4">
										<label>GooglePlus Sharing</label>
									</div>
									<div class="col-xs-6 col-sm-4">
										<input class="status-check" data-div="#googleplus-sharing" type="checkbox" name="googleplusSharing" data-toggle="toggle" data-size="small" data-onstyle="success" <?php echo(isset($googleplusSharing) && $googleplusSharing == 1 ? "checked" : ""); ?> />
									</div>
								</div>
							</div>
							<div class="form-group <?php echo (isset($googleplusSharing) &&  $googleplusSharing != 1 ? "hide" : ""); ?>" id="googleplus-sharing">
								<label>GooglePlus Page Id</label>
								<input type="text" name="googleplusPageId" class="form-control" placeholder="Enter GooglePlus Page Id..." value="<?php echo (isset($googleplusPageId) ? $googleplusPageId : ""); ?>" />
								<?php
								if(isset($googleplusPageIdError)) {
									?>
									<div class="m-t-5 text-danger"><small><?php echo $googleplusPageIdError; ?></small></div>
									<?php
								}
								?>
							</div>
							<div class="form-group">
								<div class="row">
									<div class="col-xs-6 col-sm-4">
										<label>Twitter Sharing</label>
									</div>
									<div class="col-xs-6 col-sm-4">
										<input class="status-check" data-div="#twitter-sharing" type="checkbox" name="twitterSharing" data-toggle="toggle" data-size="small" data-onstyle="success" <?php echo(isset($twitterSharing) && $twitterSharing == 1 ? "checked" : ""); ?> />
									</div>
								</div>
							</div>
							<div class="form-group <?php echo (isset($twitterSharing) && $twitterSharing != 1 ? "hide" : ""); ?>" id="twitter-sharing">
								<label>Twitter Tweet Text</label>
								<input type="text" name="twitterTweetText" class="form-control" placeholder="Enter Twitter Tweet Text..." value="<?php echo (isset($twitterTweetText) ? $twitterTweetText : ""); ?>" />
								<?php
								if(isset($twitterTweetTextError)) {
									?>
									<div class="m-t-5 text-danger"><small><?php echo $twitterTweetTextError; ?></small></div>
									<?php
								}
								?>
							</div>
							<div class="form-group">
								<div class="row">
									<div class="col-xs-6 col-sm-4">
										<label>LinkedIn Sharing</label>
									</div>
									<div class="col-xs-6 col-sm-4">
										<input type="checkbox" name="linkedinSharing" data-toggle="toggle" data-size="small" data-onstyle="success" <?php echo(isset($linkedinSharing) && $linkedinSharing == 1 ? "checked" : ""); ?> />
									</div>
								</div>
							</div>
						</div>
						<div class="form-group m-b-0">
							<button type="submit" name="submit" class="btn btn-primary">
								<i class="fa fa-check-square-o"></i> Update
							</button>
						</div>
					</form>
				</div>
			</div>
		</div>
	</div>
	<?php $this->load->view("admin/includes/footer-tag"); ?>
</div>
<?php $this->load->view("admin/includes/footer-script-files"); ?>
<script type="text/javascript" src="<?php echo base_url("assets/bootstrap-toggle/js/bootstrap-toggle.min.js"); ?>"></script>
<script type="text/javascript">
	$(document).ready(function() {
		$('.status-check').change(function() {
			var div = $(this).attr("data-div");
			if($(this).prop('checked') == true) {
				$(div).removeClass("hide");
			}
			else {
				$(div).addClass("hide");
			}
		})
	});
</script>
<?php $this->load->view("admin/includes/footer-end"); ?>