<?php $this->load->view("admin/includes/head"); ?>
<link href="<?php echo base_url("assets/bootstrap-toggle/css/bootstrap-toggle.min.css"); ?>" rel="stylesheet" type="text/css">
<title>General Settings - <?php echo $settings['title']; ?></title>
<?php $this->load->view("admin/includes/header"); ?>
<?php $this->load->view("admin/includes/sidebar"); ?> 
<div id="page-wrapper">
	<div class="container-fluid">
		<div class="row bg-title">
			<div class="col-lg-3 col-md-4 col-sm-4 col-xs-12">
				<h4 class="page-title"><i class="fa fa-cog"></i> General Settings</h4>
			</div>
			<div class="col-lg-9 col-sm-8 col-md-8 col-xs-12">
				<ol class="breadcrumb">
					<li><a href="<?php echo base_url(ADMIN_CONTROLLER."/dashboard"); ?>">Dashboard</a></li>
					<li class="active">General Settings</li>
				</ol>
			</div>
		</div>
		<div class="row">
			<div class="col-md-12">
				<?php
				if(isset($_POST['submit'])) {
					if($error == false) {
						?>
						<div class="alert alert-success">
							<a class="close" data-dismiss="alert" aria-label="close">&times;</a>
							<i class="fa fa-check-square-o"></i> General settings updated successfully.
						</div>
						<?php
					}
					else {
						?>
						<div class="alert alert-danger">
							<a class="close" data-dismiss="alert" aria-label="close">&times;</a>
							<i class="fa fa-warning"></i> Some error occured cannot update general settings.
						</div>
						<?php
					}
				}
				?>
				<div class="white-box">
					<form method="post" action="<?php echo base_url(ADMIN_CONTROLLER."/general-settings"); ?>" enctype="multipart/form-data">
						<div class="form-group">
							<label>Title</label>
							<input type="text" name="title" class="form-control" placeholder="Enter Title..." value="<?php echo (isset($title) ? $title : ""); ?>" />
							<?php
							if(isset($titleError)) {
								?>
								<div class="m-t-5 text-danger"><small><?php echo $titleError; ?></small></div>
								<?php
							}
							?>
						</div>
						<div class="form-group">
							<label>Description</label>
							<textarea name="description" class="form-control" placeholder="Enter Description..." rows="4"><?php echo (isset($description) ? $description : ""); ?></textarea>
							<?php
							if(isset($descriptionError)) {
								?>
								<div class="m-t-5 text-danger"><small><?php echo $descriptionError; ?></small></div>
								<?php
							}
							?>
						</div>
						<div class="form-group">
							<label>Keywords</label>
							<input type="text" name="keywords" class="form-control" placeholder="Enter Keywords..." value="<?php echo (isset($keywords) ? $keywords : ""); ?>" />
							<?php
							if(isset($keywordsError)) {
								?>
								<div class="m-t-5 text-danger"><small><?php echo $keywordsError; ?></small></div>
								<?php
							}
							?>
						</div>
						<div class="form-group">
							<label>Cover Image</label>
							<div>
								<img style="max-width:300px;" id="coverImageShow" class="img-responsive img-thumbnail" src="<?php echo base_url("assets/images/".$coverImage); ?>" />
								<input type="hidden" name="oldCoverImage" value="<?php echo $coverImage; ?>" />
							</div>
							<div class="m-t-5">
								<input id="coverImage" type="file" class="hide" name="coverImage" />
								<button id="coverImageSelect" type="button" class="btn btn-xs btn-info"><small><i class="fa fa-upload"></i> &nbsp;Change Cover Image</small></button>
							</div>
							<?php
							if(isset($coverImageError)) {
								?>
								<div class="m-t-5 text-danger"><small><?php echo $coverImageError; ?></small></div>
								<?php
							}
							?>
						</div>
						<div class="form-group">
							<label>Background Image</label>
							<div>
								<img style="max-width:300px;" id="backgroundImageShow" class="img-responsive img-thumbnail" src="<?php echo base_url("assets/images/".$backgroundImage); ?>" />
								<input type="hidden" name="oldBackgroundImage" value="<?php echo $backgroundImage; ?>" />
							</div>
							<div class="m-t-5">
								<input id="backgroundImage" type="file" class="hide" name="backgroundImage" />
								<button id="backgroundImageSelect" type="button" class="btn btn-xs btn-info"><small><i class="fa fa-upload"></i> &nbsp;Change Background Image</small></button>
							</div>
							<?php
							if(isset($backgroundImageError)) {
								?>
								<div class="m-t-5 text-danger"><small><?php echo $backgroundImageError; ?></small></div>
								<?php
							}
							?>
						</div>
						<div class="form-group">
							<label>Logo</label>
							<div>
								<img style="max-width:160px;" id="logoShow" class="img-responsive img-thumbnail" src="<?php echo base_url("assets/images/".$logo); ?>" />
								<input type="hidden" name="oldLogo" value="<?php echo $logo; ?>" />
							</div>
							<div class="m-t-5">
								<input id="logo" type="file" class="hide" name="logo" />
								<button id="logoSelect" type="button" class="btn btn-xs btn-info"><small><i class="fa fa-upload"></i> &nbsp;Change Logo</small></button>
							</div>
							<?php
							if(isset($logoError)) {
								?>
								<div class="m-t-5 text-danger"><small><?php echo $logoError; ?></small></div>
								<?php
							}
							?>
						</div>
						<div class="form-group">
							<label>Logo Light</label>
							<div>
								<img style="background-color:#e8e8e8;max-width:160px;" id="logoLightShow" class="img-responsive img-thumbnail" src="<?php echo base_url("assets/images/".$logoLight); ?>" />
								<input type="hidden" name="oldLogoLight" value="<?php echo $logoLight; ?>" />
							</div>
							<div class="m-t-5">
								<input id="logoLight" type="file" class="hide" name="logoLight" />
								<button id="logoLightSelect" type="button" class="btn btn-xs btn-info"><small><i class="fa fa-upload"></i> &nbsp;Change Logo Light</small></button>
							</div>
							<?php
							if(isset($logoLightError)) {
								?>
								<div class="m-t-5 text-danger"><small><?php echo $logoLightError; ?></small></div>
								<?php
							}
							?>
						</div>
						<div class="form-group">
							<label>Favicon</label>
							<div>
								<img style="max-width:100px;" id="faviconShow" class="img-responsive img-thumbnail" src="<?php echo base_url("assets/images/".$favicon); ?>" />
								<input type="hidden" name="oldFavicon" value="<?php echo $favicon; ?>" />
							</div>
							<div class="m-t-5">
								<input id="favicon" type="file" class="hide" name="favicon" />
								<button id="faviconSelect" type="button" class="btn btn-xs btn-info"><small><i class="fa fa-upload"></i> &nbsp; Change Favicon</small></button>
							</div>
							<?php
							if(isset($faviconError)) {
								?>
								<div class="m-t-5 text-danger"><small><?php echo $faviconError; ?></small></div>
								<?php
							}
							?>
						</div>
						<div class="form-group">
							<label>Allow Direct Link <strong><small>(Download Links)</small></strong></label>
							<div>
								<input type="checkbox" name="allowDirectLink" data-toggle="toggle" data-size="small" data-onstyle="success" <?php echo(isset($allowDirectLink) && $allowDirectLink == 1 ? "checked" : ""); ?> />
							</div>
						</div>
						<div class="form-group">
							<label>Force <strong>(www)</strong></label>
							<div>
								<input type="checkbox" name="www" data-toggle="toggle" data-size="small" data-onstyle="success" <?php echo(isset($www) && $www == 1 ? "checked" : ""); ?> />
							</div>
						</div>
						<div class="form-group">
							<label>Force <strong>(https)</strong></label>
							<div>
								<input type="checkbox" name="https" data-toggle="toggle" data-size="small" data-onstyle="success" <?php echo(isset($https) && $https == 1 ? "checked" : ""); ?> />
							</div>
						</div>
						<div class="form-group m-b-0">
							<button type="submit" name="submit" class="btn btn-primary">
								<i class="fa fa-check-square-o"></i> Update
							</button>
						</div>
					</form>
				</div>
			</div>
		</div>
	</div>
	<?php $this->load->view("admin/includes/footer-tag"); ?>
</div>
<?php $this->load->view("admin/includes/footer-script-files"); ?>
<script type="text/javascript" src="<?php echo base_url("assets/bootstrap-toggle/js/bootstrap-toggle.min.js"); ?>"></script>
<script type="text/javascript">
	$(document).ready(function() {
		function showImage(file,element,match,context) {
			var imagefile = file.type;
			if($.inArray(imagefile,match) != -1) {
				var reader = new FileReader();
				reader.readAsDataURL(file);
				reader.onload = function(e) {
					$(element).attr("src",e.target.result);
				};
			}
			else {
				context.val("");
			}
		}
			
		/*** Cover Image ***/	
		$("#coverImageSelect").click(function() {
			$("#coverImage").trigger("click");
		});
			
		$("#coverImage").change(function() {
			var file = this.files[0];
			var match = ["image/jpeg","image/png","image/jpg"];
			showImage(file,"#coverImageShow",match,$(this))
		});
		
		/*** Background Image ***/
		$("#backgroundImageSelect").click(function() {
			$("#backgroundImage").trigger("click");
		});
			
		$("#backgroundImage").change(function() {
			var file = this.files[0];
			var match = ["image/jpeg","image/png","image/jpg"];
			showImage(file,"#backgroundImageShow",match,$(this))
		});
		
		/*** Logo ***/
		$("#logoSelect").click(function() {
			$("#logo").trigger("click");
		});
			
		$("#logo").change(function() {
			var file = this.files[0];
			var match = ["image/jpeg","image/png","image/jpg"];
			showImage(file,"#logoShow",match,$(this))
		});
		
		/*** Logo Light***/
		$("#logoLightSelect").click(function() {
			$("#logoLight").trigger("click");
		});
			
		$("#logoLight").change(function() {
			var file = this.files[0];
			var match = ["image/jpeg","image/png","image/jpg"];
			showImage(file,"#logoLightShow",match,$(this))
		});
		
		/*** Favicon ***/
		$("#faviconSelect").click(function() {
			$("#favicon").trigger("click");
		});
			
		$("#favicon").change(function() {
			var file = this.files[0];
			var match = ["image/jpeg","image/png","image/jpg","image/ico"];
			showImage(file,"#faviconShow",match,$(this))
		});
	});
</script>
<?php $this->load->view("admin/includes/footer-end"); ?>