<?php $this->load->view("admin/includes/head"); ?>
<link href="<?php echo base_url("assets/bootstrap-toggle/css/bootstrap-toggle.min.css"); ?>" rel="stylesheet" type="text/css">
<title>Edit Source - <?php echo $name; ?> - <?php echo $settings['title']; ?></title>
<?php $this->load->view("admin/includes/header"); ?>
<?php $this->load->view("admin/includes/sidebar"); ?> 
<div id="page-wrapper">
	<div class="container-fluid">
		<div class="row bg-title">
			<div class="col-lg-3 col-md-4 col-sm-4 col-xs-12">
				<h4 class="page-title"><i class="fa fa-cog"></i> Edit Source (<?php echo $name; ?>)</h4>
			</div>
			<div class="col-lg-9 col-sm-8 col-md-8 col-xs-12">
				<ol class="breadcrumb">
					<li><a href="<?php echo base_url(ADMIN_CONTROLLER."/dashboard"); ?>">Dashboard</a></li>
					<li><a href="<?php echo base_url(ADMIN_CONTROLLER."/sources"); ?>">Sources</a></li>
					<li class="active">Edit Source</li>
				</ol>
			</div>
		</div>
		<div class="row">
			<div class="col-md-12">
				<?php
				if(isset($_POST['submit'])) {
					if($error == false) {
						?>
						<div class="alert alert-success">
							<a class="close" data-dismiss="alert" aria-label="close">&times;</a>
							<i class="fa fa-check-square-o"></i> Source updated successfully.
						</div>
						<?php
					}
					else {
						?>
						<div class="alert alert-danger">
							<a class="close" data-dismiss="alert" aria-label="close">&times;</a>
							<i class="fa fa-warning"></i> Some error occured cannot update source.
						</div>
						<?php
					}
				}
				?>
				<div class="white-box">
					<form method="post" action="<?php echo base_url(ADMIN_CONTROLLER."/edit-source/".$id); ?>" enctype="multipart/form-data">
						<div class="form-group">
							<label>Name</label>
							<input readonly type="text" name="name" class="form-control" placeholder="Enter Name..." value="<?php echo (isset($name) ? $name : ""); ?>" />
						</div>
						<div class="form-group">
							<label>Website</label>
							<input readonly type="text" name="website" class="form-control" placeholder="Enter Website..." value="<?php echo (isset($website) ? $website : ""); ?>" />
						</div>
						<div class="form-group">
							<label>Link Cache Time (In Seconds)</label>
							<input type="text" name="linkCacheTime" class="form-control" placeholder="Enter Link Cache Time..." value="<?php echo (isset($linkCacheTime) ? $linkCacheTime : ""); ?>" />
							<?php
							if(isset($linkCacheTimeError)) {
								?>
								<div class="m-t-5 text-danger"><small><?php echo $linkCacheTimeError; ?></small></div>
								<?php
							}
							?>
						</div>
                                            
                                                <?php if(!empty($fields)) :?>
                                                    <?php foreach($fields as $field) : ?>
                                                        <div class="form-group">
                                                            <label><?php echo $field['label'];?></label>
                                                            <input type="text" name="fields[<?php echo $field['name'];?>]" class="form-control" value="<?php echo @${$field['name']};?>" />
															<small><?php echo @$field['description'];?></small>
                                                        </div>
                                                    <?php endforeach;?>
                                                <?php endif;?>
                                                
                                            
						<div class="form-group">
							<label>Icon</label>
							<div>
								<img style="max-width:100px;" id="iconShow" class="img-responsive img-thumbnail" src="<?php echo base_url("assets/images/sources/".$icon); ?>" />
								<input type="hidden" name="oldIcon" value="<?php echo $icon; ?>" />
							</div>
							<div class="m-t-5">
								<input id="icon" type="file" class="hide" name="icon" />
								<button id="iconSelect" type="button" class="btn btn-xs btn-info"><small><i class="fa fa-upload"></i> &nbsp; Change Icon</small></button>
							</div>
							<?php
							if(isset($iconError)) {
								?>
								<div class="m-t-5 text-danger"><small><?php echo $iconError; ?></small></div>
								<?php
							}
							?>
						</div>
						<div class="form-group">
							<label>Status</label>
							<div>
								<input type="checkbox" name="status" data-toggle="toggle" data-size="small" data-onstyle="success" <?php echo(isset($status) && $status == 1 ? "checked" : ""); ?> />
							</div>
						</div>
						<div class="form-group m-b-0">
							<button type="submit" name="submit" class="btn btn-primary">
								<i class="fa fa-check-square-o"></i> Update
							</button>
						</div>
					</form>
				</div>
			</div>
		</div>
	</div>
	<?php $this->load->view("admin/includes/footer-tag"); ?>
</div>
<?php $this->load->view("admin/includes/footer-script-files"); ?>
<script type="text/javascript" src="<?php echo base_url("assets/bootstrap-toggle/js/bootstrap-toggle.min.js"); ?>"></script>
<script type="text/javascript">
	$(document).ready(function() {
		function showImage(file,element,match,context) {
			var imagefile = file.type;
			if($.inArray(imagefile,match) != -1) {
				var reader = new FileReader();
				reader.readAsDataURL(file);
				reader.onload = function(e) {
					$(element).attr("src",e.target.result);
				};
			}
			else {
				context.val("");
			}
		}
			
		$("#iconSelect").click(function() {
			$("#icon").trigger("click");
		});
			
		$("#icon").change(function() {
			var file = this.files[0];
			var match = ["image/jpeg","image/png","image/jpg","image/ico"];
			showImage(file,"#iconShow",match,$(this))
		});
	});
</script>
<?php $this->load->view("admin/includes/footer-end"); ?>