<?php $this->load->view("admin/includes/head"); ?>
<title>Edit Language Values - <?php echo $language['name']." - ".$settings['title']; ?></title>
<?php $this->load->view("admin/includes/header"); ?>
<?php $this->load->view("admin/includes/sidebar"); ?> 
<div id="page-wrapper">
	<button class="btn btn-success" id="btn-check-empty"><i class="fa fa-check"></i> Goto next empty field</button>
	<div class="container-fluid">
		<div class="row bg-title">
			<div class="col-lg-3 col-md-4 col-sm-4 col-xs-12">
				<h4 class="page-title"><i class="fa fa-pencil-square-o"></i> Edit Language Values (<?php echo $language['name']; ?>)</h4>
			</div>
			<div class="col-lg-9 col-sm-8 col-md-8 col-xs-12">
				<ol class="breadcrumb">
					<li><a href="<?php echo base_url(ADMIN_CONTROLLER."/dashboard"); ?>">Dashboard</a></li>
					<li><a href="<?php echo base_url(ADMIN_CONTROLLER."/languages"); ?>">languages</a></li>
					<li class="active">Edit Language Values</li>
				</ol>
			</div>
		</div>
		<p><small><strong>Note : </strong>Text between <strong>*{* YOUR TEXT *}*</strong> will be bold</small></p>
		<div class="row">
			<div class="col-md-12">
				<?php
				if(isset($_POST['submit'])) {
					if($error == false) {
						?>
						<div class="alert alert-success">
							<a class="close" data-dismiss="alert" aria-label="close">&times;</a>
							<i class="fa fa-check-square-o"></i> Language values updated successfully.
						</div>
						<?php
					}
				}
				?>
				<div class="white-box">
					<form method="post" action="<?php echo base_url(ADMIN_CONTROLLER."/edit-language-values/".$id); ?>">
						<?php
							foreach($languageRec as $index => $rec) {
							?>	
							<div class="form-group">
								<label for="<?php echo $rec['title'] ?>"><?php echo $rec['title']; ?></label>
								<div style="margin-bottom: 5px;"><small><strong>Original Text : </strong><?php echo $rec['value']; ?></small></div>
								<input type="text" name="<?php echo $index; ?>" class="form-control" placeholder="Value in <?php echo $language['name']; ?>..." value="<?php echo (isset($languageValues[$index]) ? $languageValues[$index] : "") ?>" />	
							</div>
							<?php
						}
						?>
						<div class="form-group m-b-0">
							<button type="submit" name="submit" class="btn btn-primary">
								<i class="fa fa-check-square-o"></i> Update
							</button>
						</div>
					</form>
				</div>
			</div>
		</div>
	</div>
	<?php $this->load->view("admin/includes/footer-tag"); ?>
</div>
<?php $this->load->view("admin/includes/footer-script-files"); ?>
<script type="text/javascript">
	$(document).ready(function() {
		$("#btn-check-empty").click(function(e) {
			e.preventDefault();
			$("input[value='']:visible:first").focus();
		});
	});
</script>
<?php $this->load->view("admin/includes/footer-end"); ?>