<?php $this->load->view("admin/includes/head"); ?>
<link rel="stylesheet" type="text/css" href="<?php echo base_url("assets/bootstrap-toggle/css/bootstrap-toggle.min.css"); ?>">
<title>Edit Language - <?php echo $name ." - ". $settings['title']; ?></title>
<?php $this->load->view("admin/includes/header"); ?>
<?php $this->load->view("admin/includes/sidebar"); ?> 
<div id="page-wrapper">
	<div class="container-fluid">
		<div class="row bg-title">
			<div class="col-lg-3 col-md-4 col-sm-4 col-xs-12">
				<h4 class="page-title"><i class="fa fa-pencil-square-o"></i> Edit Language (<?php echo $name; ?>)</h4>
			</div>
			<div class="col-lg-9 col-sm-8 col-md-8 col-xs-12">
				<ol class="breadcrumb">
					<li><a href="<?php echo base_url(ADMIN_CONTROLLER."/dashboard"); ?>">Dashboard</a></li>
					<li><a href="<?php echo base_url(ADMIN_CONTROLLER."/languages"); ?>">languages</a></li>
					<li class="active">Edit Language</li>
				</ol>
			</div>
		</div>
		<div class="row">
			<div class="col-md-12">
				<?php
				if(isset($_POST['submit'])) {
					if($error == false) {
						?>
						<div class="alert alert-success">
							<a class="close" data-dismiss="alert" aria-label="close">&times;</a>
							<i class="fa fa-check-square-o"></i> Language updated successfully.
						</div>
						<?php
					}
					else {
						?>
						<div class="alert alert-danger">
							<a class="close" data-dismiss="alert" aria-label="close">&times;</a>
							<i class="fa fa-warning"></i> Some error occured cannot update language.
						</div>
						<?php
					}
				}
				?>
				<div class="white-box">
					<form method="post" action="<?php echo base_url(ADMIN_CONTROLLER."/edit-language/".$id); ?>">
						<div class="form-group">
							<label>Name</label>
							<input type="text" name="name" class="form-control" placeholder="Enter Language Name..." value="<?php echo (isset($name) ? $name : ""); ?>" />
							<?php
							if(isset($nameError)) {
								?>
								<div class="m-t-5 text-danger"><small><?php echo $nameError; ?></small></div>
								<?php
							}
							?>
						</div>
						<div class="form-group">
							<label>Code</label>
							<input type="hidden" name="oldCode" value="<?php echo(isset($oldCode) ? $oldCode : $code); ?>"/>
							<input type="text" name="code" class="form-control" placeholder="Enter Language Code..." value="<?php echo (isset($code) ? $code : ""); ?>" />
							<?php
							if(isset($codeError)) {
								?>
								<div class="m-t-5 text-danger"><small><?php echo $codeError; ?></small></div>
								<?php
							}
							?>
						</div>
						<div class="form-group">
							<label>Flag</label>
							<div>
								<img style="max-width:100px;" id="countryFlagShow" class="img-responsive img-thumbnail" src="<?php echo base_url("assets/countries/flags/".$flag.".svg"); ?>" />
							</div>
							<div class="m-t-10">
								<select id="countries" class="form-control" name="flag">
									<?php
									foreach($countries as $index => $value) {
										?>
										<option value="<?php echo $index; ?>" <?php echo(isset($flag) && $flag == $index ? "selected" : ""); ?>><?php echo $value; ?></option>
										<?php
									}
									?>
								</select>
							</div>
						</div>
						<div class="form-group">
							<label>Status</label>
							<div>
								<input type="checkbox" name="status" data-toggle="toggle" data-size="small" data-onstyle="success" <?php echo(isset($status) && $status == 1 ? "checked" : ""); ?> />
							</div>
						</div>
						<div class="form-group m-b-0">
							<button type="submit" name="submit" class="btn btn-primary">
								<i class="fa fa-pencil-square-o"></i> Update
							</button>
						</div>
					</form>
				</div>
			</div>
		</div>
	</div>
	<?php $this->load->view("admin/includes/footer-tag"); ?>
</div>
<?php $this->load->view("admin/includes/footer-script-files"); ?>
<script type="text/javascript" src="<?php echo base_url("assets/bootstrap-toggle/js/bootstrap-toggle.min.js"); ?>"></script>
<script type="text/javascript">
	$(document).ready(function() {
		$("#countries").change(function() {
			var value = $(this).val();
			$("#countryFlagShow").attr("src",baseURL+"assets/countries/flags/"+value+".svg");
		});
	});
</script>
<?php $this->load->view("admin/includes/footer-end"); ?>