<?php $this->load->view("admin/includes/head"); ?>
<title>Change Password - <?php echo $settings['title']; ?></title>
<?php $this->load->view("admin/includes/header"); ?>
<?php $this->load->view("admin/includes/sidebar"); ?> 
<div id="page-wrapper">
	<div class="container-fluid">
		<div class="row bg-title">
			<div class="col-lg-3 col-md-4 col-sm-4 col-xs-12">
				<h4 class="page-title"><i class="fa fa-key"></i> Change Password</h4>
			</div>
			<div class="col-lg-9 col-sm-8 col-md-8 col-xs-12">
				<ol class="breadcrumb">
					<li><a href="<?php echo base_url(ADMIN_CONTROLLER."/dashboard"); ?>">Dashboard</a></li>
					<li class="active">Change Password</li>
				</ol>
			</div>
		</div>
		<div class="row">
			<div class="col-md-12">
				<?php
				if(isset($_POST['submit'])) {
					if($error == false) {
						?>
						<div class="alert alert-success">
							<a class="close" data-dismiss="alert" aria-label="close">&times;</a>
							<i class="fa fa-check-square-o"></i> Password changed successfully.
						</div>
						<?php
					}
					else {
						?>
						<div class="alert alert-danger">
							<a class="close" data-dismiss="alert" aria-label="close">&times;</a>
							<i class="fa fa-warning"></i> Some error occured cannot update password.
						</div>
						<?php
					}
				}
				?>
				<div class="white-box">
					<form method="post" action="<?php echo base_url(ADMIN_CONTROLLER."/change-password"); ?>">
						<div class="form-group">
							<label>Old Password</label>
							<input type="password" name="oldPassword" class="form-control" placeholder="Enter Old Password..." value="<?php echo (isset($oldPassword) && $error == true ? $oldPassword : ""); ?>" />
							<?php
							if(isset($oldPasswordError)) {
								?>
								<div class="m-t-5 text-danger"><small><?php echo $oldPasswordError; ?></small></div>
								<?php
							}
							?>
						</div>
						<div class="form-group">
							<label>New Password</label>
							<input type="password" name="newPassword" class="form-control" placeholder="Enter New Password..." value="<?php echo (isset($newPassword) && $error == true ? $newPassword : ""); ?>" />
							<?php
							if(isset($newPasswordError)) {
								?>
								<div class="m-t-5 text-danger"><small><?php echo $newPasswordError; ?></small></div>
								<?php
							}
							?>
						</div>
						<div class="form-group">
							<label>Confirm New Password</label>
							<input type="password" name="confirmNewPassword" class="form-control" placeholder="Confirm New Password..." value="<?php echo (isset($confirmNewPassword) && $error == true ? $confirmNewPassword : ""); ?>" />
							<?php
							if(isset($confirmNewPasswordError)) {
								?>
								<div class="m-t-5 text-danger"><small><?php echo $confirmNewPasswordError; ?></small></div>
								<?php
							}
							?>
						</div>
						<div class="form-group m-b-0">
							<button type="submit" name="submit" class="btn btn-primary">
								<i class="fa fa-check-square-o"></i> Update
							</button>
						</div>
					</form>
				</div>
			</div>
		</div>
	</div>
	<?php $this->load->view("admin/includes/footer-tag"); ?>
</div>
<?php $this->load->view("admin/includes/footer-script-files"); ?>
<?php $this->load->view("admin/includes/footer-end"); ?>