<?php $this->load->view("admin/includes/head"); ?>
<title>API Keys - <?php echo $settings['title']; ?></title>
<?php $this->load->view("admin/includes/header"); ?>
<?php $this->load->view("admin/includes/sidebar"); ?> 
<div id="page-wrapper">
	<div class="container-fluid">
		<div class="row bg-title">
			<div class="col-lg-3 col-md-4 col-sm-4 col-xs-12">
				<h4 class="page-title"><i class="fa fa-stack-overflow"></i> API Keys</h4>
			</div>
			<div class="col-lg-9 col-sm-8 col-md-8 col-xs-12">
				<ol class="breadcrumb">
					<li><a href="<?php echo base_url(ADMIN_CONTROLLER."/dashboard"); ?>">Dashboard</a></li>
					<li class="active">API Keys</li>
				</ol>
			</div>
		</div>
		<div class="row">
			<div class="col-md-12">
				<?php
				if(isset($_POST['submit'])) {
					if($error == false) {
						?>
						<div class="alert alert-success">
							<a class="close" data-dismiss="alert" aria-label="close">&times;</a>
							<i class="fa fa-check-square-o"></i> API keys updated successfully.
						</div>
						<?php
					}
					else {
						?>
						<div class="alert alert-danger">
							<a class="close" data-dismiss="alert" aria-label="close">&times;</a>
							<i class="fa fa-warning"></i> Some error occured cannot update API keys.
						</div>
						<?php
					}
				}
				?>
				<div class="white-box">
					<form method="post" action="<?php echo base_url(ADMIN_CONTROLLER."/api-keys"); ?>">
						<div class="form-group">
							<label>Facebook App ID</label>
							<input type="text" name="facebookAppId" class="form-control" placeholder="Enter Facebook App ID..." value="<?php echo (isset($facebookAppId) ? $facebookAppId : ""); ?>" />
							<small>Get your <strong>Facebook Credentials</strong> form <a target="_blank" href="https://developers.facebook.com/">here</a>. For more information <strong>read documentation</strong></small>
						</div>
						<div class="form-group">
							<label>Facebook App Secret</label>
							<input type="text" name="facebookAppSecret" class="form-control" placeholder="Enter Facebook App Secret..." value="<?php echo (isset($facebookAppSecret) ? $facebookAppSecret : ""); ?>" />
						</div>
						<div class="form-group">
							<label>SoundCloud</label>
							<input type="text" name="soundcloud" class="form-control" placeholder="Enter SoundCloud API Key..." value="<?php echo (isset($soundcloud) ? $soundcloud : ""); ?>" />
						</div>
						<div class="form-group m-b-0">
							<button type="submit" name="submit" class="btn btn-primary">
								<i class="fa fa-check-square-o"></i> Update
							</button>
						</div>
					</form>
				</div>
			</div>
		</div>
	</div>
	<?php $this->load->view("admin/includes/footer-tag"); ?>
</div>
<?php $this->load->view("admin/includes/footer-script-files"); ?>
<?php $this->load->view("admin/includes/footer-end"); ?>