<?php $this->load->view("admin/includes/head"); ?>
<link href="<?php echo base_url("assets/bootstrap-toggle/css/bootstrap-toggle.min.css"); ?>" rel="stylesheet" type="text/css">
<title>Analytics Settings - <?php echo $settings['title']; ?></title>
<?php $this->load->view("admin/includes/header"); ?>
<?php $this->load->view("admin/includes/sidebar"); ?> 
<div id="page-wrapper">
	<div class="container-fluid">
		<div class="row bg-title">
			<div class="col-lg-3 col-md-4 col-sm-4 col-xs-12">
				<h4 class="page-title"><i class="fa fa-line-chart"></i> Analytics Settings</h4>
			</div>
			<div class="col-lg-9 col-sm-8 col-md-8 col-xs-12">
				<ol class="breadcrumb">
					<li><a href="<?php echo base_url(ADMIN_CONTROLLER."/dashboard"); ?>">Dashboard</a></li>
					<li class="active">Analytics Settings</li>
				</ol>
			</div>
		</div>
		<div class="row">
			<div class="col-md-12">
				<?php
				if(isset($_POST['submit'])) {
					if($error == false) {
						?>
						<div class="alert alert-success">
							<a class="close" data-dismiss="alert" aria-label="close">&times;</a>
							<i class="fa fa-check-square-o"></i> Analytics updated successfully.
						</div>
						<?php
					}
					else {
						?>
						<div class="alert alert-danger">
							<a class="close" data-dismiss="alert" aria-label="close">&times;</a>
							<i class="fa fa-warning"></i> Some error occured cannot update analytics.
						</div>
						<?php
					}
				}
				?>
				<div class="white-box">
					<form method="post" action="<?php echo base_url(ADMIN_CONTROLLER."/analytics-settings"); ?>">
						<div class="form-group">
							<label>Status</label>
							<div>
								<input id="status-check" type="checkbox" name="status" data-toggle="toggle" data-size="small" data-onstyle="success" <?php echo(isset($status) && $status == 1 ? "checked" : ""); ?> />
							</div>
						</div>
						<div id="code-field" class="form-group <?php echo ($status != 1 ? "hide" : ""); ?>">
							<label>Code</label>
							<textarea name="code" class="form-control" placeholder="Enter Analytics Code..." rows="7"><?php echo (isset($code) ? stripcslashes($code) : ""); ?></textarea>
							<?php
							if(isset($codeError)) {
								?>
								<div class="m-t-5 text-danger"><small><?php echo $codeError; ?></small></div>
								<?php
							}
							?>
						</div>
						<div class="form-group m-b-0">
							<button type="submit" name="submit" class="btn btn-primary">
								<i class="fa fa-check-square-o"></i> Update
							</button>
						</div>
					</form>
				</div>
			</div>
		</div>
	</div>
	<?php $this->load->view("admin/includes/footer-tag"); ?>
</div>
<?php $this->load->view("admin/includes/footer-script-files"); ?>
<script type="text/javascript" src="<?php echo base_url("assets/bootstrap-toggle/js/bootstrap-toggle.min.js"); ?>"></script>
<script type="text/javascript">
	$(document).ready(function() {
		$('#status-check').change(function() {
			if($(this).prop('checked') == true) {
				$("#code-field").removeClass("hide");
			}
			else {
				$("#code-field").addClass("hide");
			}
		});
	});
</script>
<?php $this->load->view("admin/includes/footer-end"); ?>