<?php $this->load->view("admin/includes/head"); ?>
<link href="<?php echo base_url("assets/bootstrap-toggle/css/bootstrap-toggle.min.css"); ?>" rel="stylesheet" type="text/css">
<title>Ads Settings - <?php echo $settings['title']; ?></title>
<?php $this->load->view("admin/includes/header"); ?>
<?php $this->load->view("admin/includes/sidebar"); ?> 
<div id="page-wrapper">
	<div class="container-fluid">
		<div class="row bg-title">
			<div class="col-lg-3 col-md-4 col-sm-4 col-xs-12">
				<h4 class="page-title"><i class="fa fa-code"></i> Ads Settings</h4>
			</div>
			<div class="col-lg-9 col-sm-8 col-md-8 col-xs-12">
				<ol class="breadcrumb">
					<li><a href="<?php echo base_url(ADMIN_CONTROLLER."/dashboard"); ?>">Dashboard</a></li>
					<li class="active">Ads Settings</li>
				</ol>
			</div>
		</div>
		<div class="row">
			<div class="col-md-12">
				<?php
				if(isset($_POST['submit'])) {
					if($error == false) {
						?>
						<div class="alert alert-success">
							<a class="close" data-dismiss="alert" aria-label="close">&times;</a>
							<i class="fa fa-check-square-o"></i> Ads settings updated successfully.
						</div>
						<?php
					}
					else {
						?>
						<div class="alert alert-danger">
							<a class="close" data-dismiss="alert" aria-label="close">&times;</a>
							<i class="fa fa-warning"></i> Some error occured cannot update ads settings.
						</div>
						<?php
					}
				}
				?>
				<div class="white-box">
					<form method="post" action="<?php echo base_url(ADMIN_CONTROLLER."/ads-settings"); ?>">
						<div class="row">
							<div class="col-sm-10">
								<h3 class="m-t-0">Ad - 728 x 90</h3>
								<hr class="m-t-0" />
								<div class="row">
									<div class="col-sm-2 m-b-10">
										<div class="form-group m-b-0">
											<label>Status</label>
											<div>
												<input type="checkbox" name="ad728x90Status" data-toggle="toggle" data-size="small" data-onstyle="success" <?php echo(isset($ad728x90Status) && $ad728x90Status == 1 ? "checked" : ""); ?> />
											</div>
										</div>
									</div>
									<div class="col-sm-2 m-b-10">
										<div class="form-group m-b-0">
											<label>Responsive</label>
											<div>
												<input type="checkbox" name="ad728x90ResponsiveStatus" data-toggle="toggle" data-size="small" data-onstyle="success" <?php echo(isset($ad728x90ResponsiveStatus) && $ad728x90ResponsiveStatus == 1 ? "checked" : ""); ?> />
											</div>
										</div>
									</div>
									<div class="col-sm-8">
										<div class="form-group">
											<label>Code</label>
											<textarea name="ad728x90" rows="5" class="text-re-no form-control" placeholder="Enter Ad Code"><?php echo (isset($ad728x90) ? stripcslashes($ad728x90) : ""); ?></textarea>
											<?php
											if(isset($ad728x90Error)) {
												?>
												<div class="m-t-5 text-danger"><small><?php echo $ad728x90Error; ?></small></div>
												<?php
											}
											?>
										</div>
									</div>
								</div>
							</div>
						</div>
						
						<div class="row">
							<div class="col-sm-10">
								<h3 class="m-t-0">Ad - 250 x 250</h3>
								<hr class="m-t-0" />
								<div class="row">
									<div class="col-sm-2 m-b-10">
										<div class="form-group m-b-0">
											<label>Status</label>
											<div>
												<input type="checkbox" name="ad250x250Status" data-toggle="toggle" data-size="small" data-onstyle="success" <?php echo(isset($ad250x250Status) && $ad250x250Status == 1 ? "checked" : ""); ?> />
											</div>
										</div>
									</div>
									<div class="col-sm-2 m-b-10">
										<div class="form-group m-b-0">
											<label>Responsive</label>
											<div>
												<input type="checkbox" name="ad250x250ResponsiveStatus" data-toggle="toggle" data-size="small" data-onstyle="success" <?php echo(isset($ad250x250ResponsiveStatus) && $ad250x250ResponsiveStatus == 1 ? "checked" : ""); ?> />
											</div>
										</div>
									</div>
									<div class="col-sm-8">
										<div class="form-group">
											<label>Code</label>
											<textarea name="ad250x250" rows="5" class="text-re-no form-control" placeholder="Enter Ad Code"><?php echo (isset($ad250x250) ? stripcslashes($ad250x250) : ""); ?></textarea>
											<?php
											if(isset($ad250x250Error)) {
												?>
												<div class="m-t-5 text-danger"><small><?php echo $ad250x250Error; ?></small></div>
												<?php
											}
											?>
										</div>
									</div>
								</div>
							</div>
						</div>
						
						<div class="row">
							<div class="col-sm-10">
								<h3 class="m-t-0">POP Ad</h3>
								<hr class="m-t-0" />
								<div class="row">
									<div class="col-sm-4 m-b-10">
										<div class="form-group m-b-0">
											<label>Status</label>
											<div>
												<input type="checkbox" name="popAdStatus" data-toggle="toggle" data-size="small" data-onstyle="success" <?php echo(isset($popAdStatus) && $popAdStatus == 1 ? "checked" : ""); ?> />
											</div>
										</div>
									</div>
									<div class="col-sm-8">
										<div class="form-group">
											<label>Code</label>
											<textarea name="popAd" rows="5" class="text-re-no form-control" placeholder="Enter Ad Code"><?php echo (isset($popAd) ? stripcslashes($popAd) : ""); ?></textarea>
											<?php
											if(isset($popAdError)) {
												?>
												<div class="m-t-5 text-danger"><small><?php echo $popAdError; ?></small></div>
												<?php
											}
											?>
										</div>
									</div>
									<div class="col-sm-12">
										<div class="form-group">
											<label>POP Ad Fequency <small>(Per Day For A Visitor)</small></label>
											<div class="m-b-5">
												<small>Enter 0 to show on every page load</small>
											</div>
											<input name="popAdFrequency" class="form-control" placeholder="Enter POP Ad Frequency..." value="<?php echo(isset($popAdFrequency) ? $popAdFrequency : ""); ?>" />
											<?php
											if(isset($popAdFrequencyError)) {
												?>
												<div class="m-t-5 text-danger"><small><?php echo $popAdFrequencyError; ?></small></div>
												<?php
											}
											?>
										</div>
									</div>
								</div>
							</div>
						</div>
						<hr class="m-t-0" />
						<div class="form-group">
							<label>Display On Home Page</label>
							<div>
								<input type="checkbox" name="displayOnHomePage" data-toggle="toggle" data-size="small" data-onstyle="success" <?php echo(isset($displayOnHomePage) && $displayOnHomePage == 1 ? "checked" : ""); ?> />
							</div>
						</div>
						<div class="form-group">
							<label>Display On Dynamic Pages</label>
							<div>
								<input type="checkbox" name="displayOnDynamicPages" data-toggle="toggle" data-size="small" data-onstyle="success" <?php echo(isset($displayOnDynamicPages) && $displayOnDynamicPages == 1 ? "checked" : ""); ?> />
							</div>
						</div>
						<div class="form-group">
							<label>Display On Contact Page</label>
							<div>
								<input type="checkbox" name="displayOnContactPage" data-toggle="toggle" data-size="small" data-onstyle="success" <?php echo(isset($displayOnContactPage) && $displayOnContactPage == 1 ? "checked" : ""); ?> />
							</div>
						</div>
						<div class="form-group m-b-0">
							<button type="submit" name="submit" class="btn btn-primary">
								<i class="fa fa-check-square-o"></i> Update
							</button>
						</div>
					</form>
				</div>
			</div>
		</div>
	</div>
	<?php $this->load->view("admin/includes/footer-tag"); ?>
</div>
<?php $this->load->view("admin/includes/footer-script-files"); ?>
<script type="text/javascript" src="<?php echo base_url("assets/bootstrap-toggle/js/bootstrap-toggle.min.js"); ?>"></script>
<?php $this->load->view("admin/includes/footer-end"); ?>