<?php $this->load->view("admin/includes/head"); ?>
<title>Add Language - <?php echo $settings['title']; ?></title>
<?php $this->load->view("admin/includes/header"); ?>
<?php $this->load->view("admin/includes/sidebar"); ?> 
<div id="page-wrapper">
	<div class="container-fluid">
		<div class="row bg-title">
			<div class="col-lg-3 col-md-4 col-sm-4 col-xs-12">
				<h4 class="page-title"><i class="fa fa-plus-circle"></i> Add New Language</h4>
			</div>
			<div class="col-lg-9 col-sm-8 col-md-8 col-xs-12">
				<ol class="breadcrumb">
					<li><a href="<?php echo base_url(ADMIN_CONTROLLER."/dashboard"); ?>">Dashboard</a></li>
					<li><a href="<?php echo base_url(ADMIN_CONTROLLER."/languages"); ?>">languages</a></li>
					<li class="active">Add New Language</li>
				</ol>
			</div>
		</div>
		<div class="row">
			<div class="col-md-12">
				<?php
				if(isset($_POST['submit'])) {
					if($error == false) {
						?>
						<div class="alert alert-success">
							<a class="close" data-dismiss="alert" aria-label="close">&times;</a>
							<i class="fa fa-check-square-o"></i> Language added successfully.
						</div>
						<?php
					}
					else {
						?>
						<div class="alert alert-danger">
							<a class="close" data-dismiss="alert" aria-label="close">&times;</a>
							<i class="fa fa-warning"></i> Some error occured cannot add language.
						</div>
						<?php
					}
				}
				?>
				<div class="white-box">
					<form method="post" action="<?php echo base_url(ADMIN_CONTROLLER."/add-language"); ?>">
						<div class="form-group">
							<label>Name</label>
							<input type="text" name="name" class="form-control" placeholder="Enter Language Name..." value="<?php echo (isset($name) && $error == true ? $name : ""); ?>" />
							<?php
							if(isset($nameError)) {
								?>
								<div class="m-t-5 text-danger"><small><?php echo $nameError; ?></small></div>
								<?php
							}
							?>
						</div>
						<div class="form-group">
							<label>Code</label>
							<input type="text" name="code" class="form-control" placeholder="Enter Language Code..." value="<?php echo (isset($code) && $error == true ? $code : ""); ?>" />
							<?php
							if(isset($codeError)) {
								?>
								<div class="m-t-5 text-danger"><small><?php echo $codeError; ?></small></div>
								<?php
							}
							?>
						</div>
						<div class="form-group">
							<label>Flag</label>
							<div id="flag-show" class="m-b-10 <?php echo(!isset($flag) || empty($flag) || $error == false ? "hide" : ""); ?>">
								<img style="max-width:100px;" id="countryFlagShow" class="img-responsive img-thumbnail" src="<?php echo(isset($flag) && !empty($flag) && $error == true ? base_url("assets/countries/flags/".$flag.".svg") : ""); ?>"/>
							</div>
							<div>
								<select id="countries" class="form-control" name="flag">
									<option value="">Select Country</option>
									<?php
									foreach($countries as $index => $value) {
										?>
										<option value="<?php echo $index; ?>" <?php echo(isset($flag) && $flag == $index && $error == true ? "selected" : ""); ?>><?php echo $value; ?></option>
										<?php
									}
									?>
								</select>
								<?php
								if(isset($flagError)) {
									?>
									<div class="m-t-5 text-danger"><small><?php echo $flagError; ?></small></div>
									<?php
								}
								?>
							</div>
						</div>
						<div class="form-group m-b-0">
							<button type="submit" name="submit" class="btn btn-primary">
								<i class="fa fa-plus-circle"></i> Add
							</button>
						</div>
					</form>
				</div>
			</div>
		</div>
	</div>
	<?php $this->load->view("admin/includes/footer-tag"); ?>
</div>
<?php $this->load->view("admin/includes/footer-script-files"); ?>
<script type="text/javascript">
	$(document).ready(function() {
		$("#countries").change(function() {
			var value = $(this).val();
			if(value && value.length !== 0) {
				$("#flag-show").removeClass("hide");
				$("#countryFlagShow").attr("src",baseURL+"assets/countries/flags/"+value+".svg");
			}
			else {
				$("#flag-show").addClass("hide");
				$("#countryFlagShow").removeAttr("src");
			}
		});
	});
</script>
<?php $this->load->view("admin/includes/footer-end"); ?>