<?php
class DefaultModel extends CI_Model {
	public function __construct() {
		parent::__construct();
		$this->load->driver('cache', array('adapter' => 'file'));
	}
	
	public function escapeValues($esData) {
		if(is_array($esData)) {
			foreach ($esData as $key => $val) {
				$esData[$key] = $this->db->escape_str($val);
			}
		}
		else {
			$esData = $this->db->escape_str($esData);
		}
		return $esData;
	}
	
	public function generalSettings() {
		$cacheVar = "vds_general_settings";
		if(!$settings = $this->cache->get($cacheVar)) {
			$settings = $this->db->limit(1)->get("general-settings")->row_array();
			$this->cache->save($cacheVar,$settings,86400);
		}
		return $settings;
	}
	
	public function sources() {
		$cacheVar = "vds_sources";
		if(!$sources = $this->cache->get($cacheVar)) {
			$sources = $this->db->where("status",1)->order_by("displayOrder","asc")->get("sources")->result_array();
			$this->cache->save($cacheVar,$sources,86400);
		}
		return $sources;
	}
	
	public function getSource($name) {
		$name = $this->escapeValues($name);
		$cacheVar = "vds_source_".$name;
		if(!$source = $this->cache->get($cacheVar)) {
			$source = $this->db->where(["status" => 1,"name" => $name])->limit(1)->get("sources")->row_array();
			if(is_array($source) && count($source) > 0) {
				$this->cache->save($cacheVar,$source,86400);
			}
			else {
				$source = false;
			}
		}
		return $source;
	}
	
	public function captchaSettings() {
		$cacheVar = "vds_captcha_settings";
		if(!$captchaSettings = $this->cache->get($cacheVar)) {
			$captchaSettings = $this->db->limit(1)->get("captcha-settings")->row_array();
			$this->cache->save($cacheVar,$captchaSettings,86400);
		}
		return $captchaSettings;
	}
	
	public function analyticsSettings() {
		$cacheVar = "vds_analytics_settings";
		if(!$analyticsSettings = $this->cache->get($cacheVar)) {
			$analyticsSettings = $this->db->limit(1)->get("analytics-settings")->row_array();
			$this->cache->save($cacheVar,$analyticsSettings,86400);
		}
		return $analyticsSettings;
	}
	
	public function adsSettings() {
		$cacheVar = "vds_ads_settings";
		if(!$adsSettings = $this->cache->get($cacheVar)) {
			$adsSettings = $this->db->limit(1)->get("ads-settings")->row_array();
			$this->cache->save($cacheVar,$adsSettings,86400);
		}
		return $adsSettings;
	}
	
	public function socialSharing() {
		$cacheVar = "vds_social_settings";
		if(!$socialSharing = $this->cache->get($cacheVar)) {
			$socialSharing = $this->db->limit(1)->get("social-sharing")->row_array();
			$this->cache->save($cacheVar,$socialSharing,86400);
		}
		return $socialSharing;
	}
	
	public function mailSettings() {
		$cacheVar = "vds_mail_settings";
		if(!$mailSettings = $this->cache->get($cacheVar)) {
			$mailSettings = $this->db->limit(1)->get("mail-settings")->row_array();
			$this->cache->save($cacheVar,$mailSettings,86400);
		}
		return $mailSettings;
	}
	
	public function pages() {
		$cacheVar = "vds_pages";
		if(!$pages = $this->cache->get($cacheVar)) {
			$pages = $this->db->select("id,title,permalink,position,status")->where("status",1)->order_by("displayOrder","asc")->get("pages")->result_array();
			$this->cache->save($cacheVar,$pages,86400);
		}
		return $pages;
	}
	
	public function getPageByPermalink($permalink) {
		$permalink = $this->escapeValues($permalink);
		$cacheVar = "vds_page_".$permalink;
		if(!$page = $this->cache->get($cacheVar)) {
			$page = $this->db->where(["status" => 1, "permalink" => $permalink])->limit(1)->get("pages")->row_array();
			$this->cache->save($cacheVar,$page,86400);
		}
		return $page;
	}
	
	public function languages() {
		$cacheVar = "vds_languages";
		if(!$languages = $this->cache->get($cacheVar)) {
			$languages = $this->db->where("status",1)->order_by("displayOrder","asc")->get("languages")->result_array();
			$this->cache->save($cacheVar,$languages,86400);
		}
		return $languages;
	}
	
	public function getDefaultLanguage() {
		$cacheVar = "vds_default_language";
		if(!$language = $this->cache->get($cacheVar)) {
			$language = $this->db->where("status",1)->order_by("displayOrder","asc")->limit(1)->get("languages")->row_array();
			$this->cache->save($cacheVar,$language,86400);
		}
		return $language;
	}
	
	public function getLanguageById($id) {
		$id = $this->escapeValues($id);
		$cacheVar = "vds_language_".$id;
		if(!$language = $this->cache->get($cacheVar)) {
			$language = $this->db->where(["id" => $id,"status" => 1])->limit(1)->get("languages")->row_array();
			$this->cache->save($cacheVar,$language,86400);
		}
		return $language;
	}
	
	public function apiKeys() {
		$cacheVar = "vds_api_keys";
		if(!$apiKeys = $this->cache->get($cacheVar)) {
			$apiKeys = $this->db->limit(1)->get("api-keys")->row_array();
			$this->cache->save($cacheVar,$apiKeys,86400);
		}
		return $apiKeys;
	}
	
	public function getApiKey($source) {
		$apiKeys = $this->apiKeys();
		if(is_array($source)) {
			$keys = array();
			foreach($source as $index) {
				$keys[$index] = $apiKeys[$index];
			}
			return $keys;
		}
		else {
			return $apiKeys[$source];
		}
	}
	
	public function getStatsEntryRecord($date) {
		return $this->db->where("date",$date)->limit(1)->get("statistics")->row_array();
	}
	
	public function addStatisticsEntry($values) {
		$this->db->insert("statistics",$values);
	}
	
	public function updateStatisticsEntry($values,$date) {
		$this->db->where("date",$date)->set($values)->update("statistics");
	}
}
?>