<?php
class AdminModel extends CI_Model {
	function deleteCacheVar($cacheVar) {
		if(is_array($cacheVar)) {
			foreach($cacheVar as $value) {
				$this->cache->delete($value);
			}
		}
		else {
			$this->cache->delete($cacheVar);
		}
	}
	
	public function getStatsCount($startDate = null, $endDate = null) {
		if($startDate != null && $endDate != null) {
			$this->db->group_start();
			$this->db->where("date BETWEEN '$startDate' AND '$endDate'",null);
			$this->db->group_end();
		}
		$this->db->select_sum('pageViews');
		$this->db->select_sum('uniqueViews');
		$this->db->select_sum('downloads');
		$stats = $this->db->get("statistics")->row_array();
		return $stats;
	}
	
	public function updateGeneralSettings($values) {
		$values = $this->DefaultModel->escapeValues($values);
		$this->db->set($values)->update("general-settings");
		$this->deleteCacheVar("vds_general_settings");
		
	}
	
	public function sources() {
		$sources = $this->db->order_by("displayOrder","asc")->get("sources")->result_array();
		return $sources;
	}
	
	public function getSource($id) {
		$id = $this->DefaultModel->escapeValues($id);
		$source = $this->db->where("id",$id)->limit(1)->get("sources")->row_array();
		return $source;
	}
	
	public function updateSource($values,$id,$name) {
		$values = $this->DefaultModel->escapeValues($values);
		$id = $this->DefaultModel->escapeValues($id);
		$name = $this->DefaultModel->escapeValues($name);
		$this->db->where("id",$id)->set($values)->update("sources");
		$this->deleteCacheVar(["vds_sources","vds_source_".$name]);
	}
	
	public function updateSourcesOrder($displayOrder,$id) {
		$displayOrder = $this->DefaultModel->escapeValues($displayOrder);
		$id = $this->DefaultModel->escapeValues($id);
		$this->db->set('displayOrder', $displayOrder)->where('id', $id)->update('sources');
		$this->deleteCacheVar("vds_sources");
	}
	
	public function updateApiKeys($values) {
		$values = $this->DefaultModel->escapeValues($values);
		$this->db->set($values)->update("api-keys");
		$this->deleteCacheVar("vds_api_keys");
	}
	
	public function updateCaptchaSettings($values) {
		$values = $this->DefaultModel->escapeValues($values);
		$this->db->set($values)->update("captcha-settings");
		$this->deleteCacheVar("vds_captcha_settings");
	}
	
	public function updatePassword($id,$password) {
		$id = $this->DefaultModel->escapeValues($id);
		$this->db->where("id",$id);
		$this->db->set("password",$password);
		$this->db->update("users");
	}
	
	public function updateAnalyticsSettings($values) {
		$values = $this->DefaultModel->escapeValues($values);
		$this->db->set($values)->update("analytics-settings");
		$this->deleteCacheVar("vds_analytics_settings");
	}
	
	public function updateAdsSettings($values) {
		$values = $this->DefaultModel->escapeValues($values);
		$this->db->set($values)->update("ads-settings");
		$this->deleteCacheVar("vds_ads_settings");
	}
	
	public function updateSocialSharing($values) {
		$values = $this->DefaultModel->escapeValues($values);
		$this->db->set($values)->update("social-sharing");
		$this->deleteCacheVar("vds_social_settings");
	}
	
	public function updateMailSettings($values) {
		$values = $this->DefaultModel->escapeValues($values);
		$this->db->set($values)->update("mail-settings");
		$this->deleteCacheVar("vds_mail_settings");
	}
	
	public function countPagePermalink($permalink) {
		$permalink = $this->DefaultModel->escapeValues($permalink);
		return $this->db->where("permalink",$permalink)->count_all_results("pages");
	}
	
	public function getPageDisplayOrder() {
		$result = $this->db->select_max('displayOrder')->get('pages')->row_array();
		$displayOrder = $result['displayOrder'] + 1;
		return $displayOrder;
	}
	
	public function addPage($values) {
		$values = $this->DefaultModel->escapeValues($values);
		$this->db->insert("pages",$values);
		$this->deleteCacheVar("vds_pages");
	}
	
	public function pages() {
		return $this->db->select("id,title,permalink,position,status")->order_by("displayOrder","asc")->get("pages")->result_array();
	}
	
	public function updatePagesOrder($displayOrder,$id) {
		$displayOrder = $this->DefaultModel->escapeValues($displayOrder);
		$id = $this->DefaultModel->escapeValues($id);
		$this->db->set('displayOrder', $displayOrder)->where('id', $id)->update('pages');
		$this->deleteCacheVar("vds_pages");
	}
	
	public function deletePage($id,$permalink) {
		$id = $this->DefaultModel->escapeValues($id);
		$permalink = $this->DefaultModel->escapeValues($permalink);
		$this->db->where("id",$id)->delete("pages");
		$this->deleteCacheVar(["vds_pages","vds_page_".$permalink]);
	}
	
	public function getPage($id) {
		$id = $this->DefaultModel->escapeValues($id);
		return $this->db->where("id",$id)->limit(1)->get("pages")->row_array();
	}
	
	public function updatePage($values,$id,$oldPermalink) {
		$values = $this->DefaultModel->escapeValues($values);
		$id = $this->DefaultModel->escapeValues($id);
		$oldPermalink = $this->DefaultModel->escapeValues($oldPermalink);
		$this->db->where("id",$id)->set($values)->update("pages");
		$this->deleteCacheVar(["vds_pages","vds_page_".$oldPermalink]);
	}
	
	public function languages() {
		return $this->db->order_by("displayOrder","asc")->get("languages")->result_array();
	}
	
	public function getLanguageDisplayOrder() {
		$result = $this->db->select_max('displayOrder')->get('languages')->row_array();
		$displayOrder = $result['displayOrder'] + 1;
		return $displayOrder;
	}
	
	public function addLanguage($values) {
		$values = $this->DefaultModel->escapeValues($values);
		$this->db->insert("languages",$values);
		$this->deleteCacheVar(["vds_languages","vds_languages_variables_count"]);
		return $this->db->insert_id();
	}
	
	public function getLanguage($id) {
		$id = $this->DefaultModel->escapeValues($id);
		return $this->db->where("id",$id)->limit(1)->get("languages")->row_array();
	}
	
	public function countLanguageCode($code) {
		$code = $this->DefaultModel->escapeValues($code);
		return $this->db->where("code",$code)->count_all_results("languages");
	}
	
	public function updateLanguage($values,$id) {
		$values = $this->DefaultModel->escapeValues($values);
		$id = $this->DefaultModel->escapeValues($id);
		$this->db->where("id",$id)->set($values)->update("languages");
		$this->deleteCacheVar(["vds_languages","vds_default_language","vds_language_".$id]);
	}
	
	public function updateLanguagesOrder($displayOrder,$id) {
		$displayOrder = $this->DefaultModel->escapeValues($displayOrder);
		$id = $this->DefaultModel->escapeValues($id);
		$this->db->set('displayOrder', $displayOrder)->where('id', $id)->update('languages');
		$this->deleteCacheVar(["vds_languages","vds_default_language"]);
	}
	
	public function deleteLanguge($id) {
		$id = $this->DefaultModel->escapeValues($id);
		$this->db->where("id",$id)->delete("languages");
		$this->deleteCacheVar(["vds_languages","vds_languages_variables_count","vds_default_language","vds_language_".$id]);
	}
	
	public function publishedlanguagesCount() {
		return $this->db->where("status",1)->count_all_results("languages");
	}
}
?>