<?php

/**
 * Description of Soundcloud
 *
 * @author Nexthon
 */

/*
 {source_info}{"name":"Soundcloud.com","website":"https:\/\/www.soundcloud.com\/"}{end_source_info}
 */
class Soundcloud 
{
    
    function get_fields()
    {
        
        return array(
            array("label" => "SoundCloud Api Key", "name" => "sc_api_key")                        
        );       
      
    }
    /*** Get Soundcloud Audio Info ***/
     function getMediaInfo($url) 
    {

         $data = array();
        $source_info = get_source_info("soundcloud");

        if(!empty($source_info['sc_api_key']))
        {
            $data['found'] = 0;
            $result = getRemoteContents("https://api.soundcloud.com/resolve.json?url=".$url."&client_id=".$source_info['sc_api_key']);

            if($result) 
            {
                $result = json_decode($result,true);
                if(isset($result['kind']) && $result['kind'] == "track") 
                {
                        $data['id'] = $result['id'];
                        $data['found'] = 1;
                        $title = (isset($result['title']) ? htmlentities($result['title'],ENT_QUOTES) : "Track By Soundcloud");
                        $data['title'] = $title;
                        if(isset($result['description']) && !empty($result['description'])) {
                                $data['description'] = htmlentities(truncate(trim(preg_replace('/[\s]+/',' ',preg_replace("/\r|\n/", " ", $result['description']))),250),ENT_QUOTES);
                        }
                        else {
                                $data['description'] = "Download ".$title." From Soundcloud";
                        }
                        $data['image'] = (empty($result['artwork_url']) ? base_url("assets/images/soundcloud.jpg") : str_replace("large","t300x300",$result['artwork_url']));
                        $duration  = $result['duration'] / 1000;
                        $data['time'] = gmdate(($duration > 3600 ? "H:i:s" : "i:s"), $duration);

                        $data['embedIframeDirect'] = "false";
                        $embedIframe = '<div id="loader-iframe" class="p-t-40 p-b-40 text-center"><img src="'.base_url("assets/images/loader.svg").'" /></div><iframe class="hide" id="player-id" width="100%" height="300" scrolling="no" frameborder="no" src="https://w.soundcloud.com/player/?url=https%3A//api.soundcloud.com/tracks/'.$result['id'].'&amp;color=%23ff5500&amp;auto_play=false&amp;hide_related=true&amp;show_comments=true&amp;show_user=true&amp;show_reposts=false&amp;show_teaser=true&amp;visual=true"></iframe>';
                        $data['embedIframe'] = $embedIframe;
                        $data['scriptFiles'] = '<script type="text/javascript" src="//w.soundcloud.com/player/api.js"></script>';
                        $data['script'] = '$("#embedModal").one("show.bs.modal",function() { $("#player-body").html(\''.$embedIframe.'\'); $("#player-id").on("load", function() { $("#loader-iframe").remove(); $(this).removeClass("hide"); }); }); $("#embedModal").on("hide.bs.modal",function() { var widget = SC.Widget("player-id"); widget.pause(); });';

                        $streamLinks = getRemoteContents("https://api.soundcloud.com/i1/tracks/".$result['id']."/streams?client_id=".$source_info['sc_api_key']);
                        $streamLinks = json_decode($streamLinks,true);
                        $downloadUrl = $streamLinks['http_mp3_128_url'];

                        $audios = array();

                        $formatId = "http_mp3_128_url";
                        $link = array();

                        $formatData = array();
                        $formatData['order'] = 1;
                        $formatData['height'] = "empty";
                        $formatData['ext'] = "mp3";
                        $formatData['resolution'] = "Orginal";
                        $formatData['video'] = "false";
                        $formatData['video_only'] = "false";
                        $link['data'] = $formatData;

                        $link['formatId'] = $formatId;
                        $link['order'] = 1;
                        $link['url'] = $downloadUrl;
                        $link['title'] = $title.".".$formatData['ext'];
                        $link['size'] = "unknown";
                        array_push($audios,$link);

                        $data['audios'] = $audios;
                    }
                }
            }     
        
        
        return $data;
    }
}
