<?php

/*
 *  {lib_name; facebook}
 */

/**
 * Description of Facebook
 *
 * @author Nexthon
 */
/*
  {source_info}{"name":"Facebook.com","website":"https:\/\/www.facebook.com\/"}{end_source_info}
 */

class Facebook
{


    function getMediaInfo($url)
    {
        $data = array();
        $data['found'] = 0;
        
            $context = [
                'http' => [
                    'method' => 'GET',
                    'header' => "User-Agent: " . $_SERVER['HTTP_USER_AGENT'],
                ],
            ];
			
            $context = stream_context_create($context);
			
            $result = file_get_contents($url, false, $context);
			
            if ($result)
            {
                $videoSDlink = getStringBetween($result, 'sd_src_no_ratelimit:"', '"');
                $videoHDlink = getStringBetween($result, 'hd_src_no_ratelimit:"', '"');


                if ($videoSDlink)
                {

                    $data['found'] = 1;
                    $data['id'] = $id;
                    $links = array();

                    $links['SD'] = $videoSDlink;
                    if (!empty($videoHDlink))
                    {
                        $links['HD'] = $videoHDlink;
                    }
                    $ti = getStringBetween($result, 'h2 class="uiHeaderTitle"', '</h2>');
                    if ($ti)
                    {
                        $title = $ti;
                    } else
                    {

                        $title = getStringBetween($result, 'title id="pageTitle">', '</title>');
                    }

                    $description = getStringBetween($result, '<meta property="og:description" content="', '"/>');
                    $image = html_entity_decode(getStringBetween($result, '<meta property="og:image" content="', '" /><meta property="og:url" content="'));
                    $data['title'] = $title;
                    $data['image'] = $image;

                    if (!empty($description))
                    {
                        $data['description'] = htmlentities(truncate(trim(preg_replace('/[\s]+/', ' ', preg_replace("/\r|\n/", " ", $description))), 250), ENT_QUOTES);
                    } else
                    {
                        $data['description'] = "Download " . $title . " From Facebook";
                    }

                    $formatCodes = array(
                        "SD" => array("order" => "1", "height" => "{{height}}", "ext" => "mp4", "resolution" => "SD", "video" => "true", "video_only" => "false"),
                        "HD" => array("order" => "2", "height" => "{{height}}", "ext" => "mp4", "resolution" => "HD", "video" => "true", "video_only" => "false")
                    );
                    $videos = array();
                    foreach ($formatCodes as $formatId => $formatData)
                    {
                        if (isset($links[$formatId]))
                        {
                            $link = array();
                            $link['data'] = $formatData;
                            $link['formatId'] = $formatId;
                            $link['order'] = $formatData['order'];
                            $link['url'] = $links[$formatId];
                            $link['title'] = $title . "." . $formatData['ext'];
                            $link['size'] = "unknown";
                            array_push($videos, $link);
                        }
                    }
                    $data['videos'] = $videos;
                }
            }
        

        return $data;
    }

}