<?php

/**
 * Description of Dailymotion
 *
 * @author Nexthon
 */

/*
 {source_info}{"name":"Dailymotion.com","website":"https:\/\/www.dailymotion.com\/"}{end_source_info}
 */

class Dailymotion 
{
    
    /*** Get Dailymotion Video Info ***/
	public function getMediaInfo($url) 
        {
            
		$data = array();
		$data['found'] = 0;
		$urlParts = parse_url($url);
		if(isset($urlParts['path'])) {
			$pathArr = explode("/",rtrim($urlParts['path'],"/"));
			if(count($pathArr) == 3 && $pathArr[1] == "video") {
				$id = $pathArr[2];
				$result = getRemoteContents("https://api.dailymotion.com/video/".$id."?fields=title,description,thumbnail_url,duration");
				if($result) {
					$result = json_decode($result,true);
					$data['found'] = 1;
					$data['id'] = $id;
					$title = (isset($result['title']) ? htmlentities($result['title'],ENT_QUOTES) : "Video By Dailymotion");
					$data['title'] = $title;
					if(isset($result['description']) && !empty($result['description'])) {
						$data['description'] = htmlentities(truncate(trim(preg_replace('/[\s]+/',' ',preg_replace("/\r|\n/", " ", $result['description']))),250),ENT_QUOTES);
					}
					else {
						$data['description'] = "Download ".$title." From Dailymotion";
					}
					$data['image'] = str_replace("http","https",$result['thumbnail_url']);
					$duration  = $result['duration'];
					$data['time'] = gmdate(($duration > 3600 ? "H:i:s" : "i:s"), $duration);
					$data['embedIframeDirect'] = "false";
					$embedIframe = '<div id="loader-iframe" class="p-t-40 p-b-40 text-center"><img src="'.base_url("assets/images/loader.svg").'" /></div><iframe id="player-id" class="hide" frameborder="0" allowfullscreen=""></iframe>';
					$data['embedIframe'] = $embedIframe;
					$data['scriptFiles'] = '<script type="text/javascript" src="//api.dmcdn.net/all.js"></script>';
					$data['script'] = '$("#embedModal").one("show.bs.modal",function() { $("#player-body").html(\''.$embedIframe.'\'); var player = DM.player(document.getElementById("player-id"), {video: "'.$id.'",width: "100%", height: "360px", params: { autoplay: false,api:1 } }); player.addEventListener("apiready", function (e) { $("#embedModal").on("hide.bs.modal",function() { player.pause(); }); }); $("#player-id").on("load", function() { $("#loader-iframe").remove(); $(this).removeClass("hide"); }); });';
					$formatCodes = array (
						"144" => array("order" => "1", "height" => "144", "ext" => "mp4", "resolution" => "144p", "video" => "true", "video_only" => "false"),
						"240" => array("order" => "2", "height" => "240", "ext" => "mp4", "resolution" => "240p", "video" => "true", "video_only" => "false"),
						"380" => array("order" => "3", "height" => "380", "ext" => "mp4", "resolution" => "380p", "video" => "true", "video_only" => "false"),
						"480" => array("order" => "4", "height" => "480", "ext" => "mp4", "resolution" => "480p", "video" => "true", "video_only" => "false"),
						"720" => array("order" => "5", "height" => "720", "ext" => "mp4", "resolution" => "720p", "video" => "true", "video_only" => "false"),
						"1080" => array("order" => "6", "height" => "1080", "ext" => "mp4", "resolution" => "1080p", "video" => "true", "video_only" => "false")
					);
					$videoFormatsData = getRemoteContents("https://www.dailymotion.com/embed/video/".$id);
					$videoFormatsData = getStringBetween($videoFormatsData,"config = ","}};");
					$videoFormatsData .= "}}";
					$videoFormatsData = json_decode($videoFormatsData,true);
					$streams = $videoFormatsData['metadata']['qualities'];
					
					$videos = array();
					foreach($streams as $formatId => $stream) {
						if(array_key_exists($formatId,$formatCodes)) {
							$link = array();
							$formatData = $formatCodes[$formatId];
							$link['data'] = $formatData;
							$link['formatId'] = $formatId;
							$link['order'] = $formatData['order'];
							$link['url'] = $stream[1]['url'];
							$link['title'] = $title.".".$formatData['ext'];
							$link['size'] = "unknown";
							array_push($videos,$link);
						}
					}
					$orders = array();
					foreach ($videos as $key => $row) {
						$orders[$key] = $row['order'];
					}
					array_multisort($orders, SORT_DESC, $videos);
					$data['videos'] = $videos;
				}
			}
		}
		return $data;
	}
}
