<?php
function _v($a, $k, $d=null) { return isset($a[$k]) ? trim($a[$k]) : $d; }

$root = dirname(__FILE__).'/';
$ds = DIRECTORY_SEPARATOR;
$flash = array();

$requirements = array(
	'PHP Version'=>version_compare(PHP_VERSION,"5.1.0",">="),
	'PCRE'=>extension_loaded("pcre"),
	'SPL'=>extension_loaded("SPL"),
	'PDO Driver'=>extension_loaded('pdo'),
	'PDO Mysql'=>extension_loaded('pdo_mysql'),
	'Reflection'=>class_exists('Reflection',false),
);

//Checking permission of the main folders and files
if(!is_writable($root.'/app/config/db.php'))
	$flash['notice'][] = "Please, make file {$root}app{$ds}config{$ds}db.php executable";

if(!is_writable($root.'/app/runtime/'))
	$flash['notice'][] = "Please, make directory {$root}app{$ds}runtime{$ds} executable";

if(!is_writable($root.'/assets/'))
	$flash['notice'][] = "Please, make directory {$root}assets{$ds} executable";

if(!is_writable($root.'/images/settings/'))
	$flash['notice'][] = "Please, make directory {$root}images{$ds}settings{$ds} executable";

//Submit button
if(isset($_POST['install']) && empty($flash['notice']))
{
	$host = 	_v($_POST, 'host');
	$user = 	_v($_POST, 'user');
	$pw =			_v($_POST, 'pw');
	$dbname = _v($_POST, 'dbname');

	if(empty($host))
		$flash['error'][] = 'Please fill Hostname';
	if(empty($user))
		$flash['error'][] = 'Please fill Username';
	if(empty($dbname))
		$flash['error'][] = 'Please fill Database Name';

	if(empty($flash['error']))
	{
		$string = "<?php \n return array( \n
			'connectionString' => 'mysql:host={$host};dbname={$dbname}', \n
			'emulatePrepare' => true, \n
			'username' => '{$user}', \n
			'password' => '{$pw}', \n
			'charset' => 'utf8', \n
			'tablePrefix' => 'sl_', \n
			'schemaCachingDuration'=>60*60*24, \n
			'enableParamLogging'=>false, \n
			'enableProfiling'=>false, \n
		);";

		$mysqli = @new mysqli($host, $user, $pw, $dbname);

		if ($mysqli->connect_errno) {
			$flash['error'][] = "Could not connect to database.";
		}

		if(!isset($flash['error']))
		{
			$file = file_get_contents($root.'/app/data/url_shortener.sql');
			$sql = explode(";", $file);
			foreach($sql as $query) {
				if(empty($query)) continue;
				if (!$mysqli->query(trim($query.";"))) {
					$flash['error'][] =  "INSERT failed: (" . $mysqli->errno . ") " . $mysqli->error;
					break;
				}
			}
			file_put_contents($root.'/app/config/db.php', $string, LOCK_EX);
		}

		if(!isset($flash['error']))
		{
			$site = "http://".$_SERVER['HTTP_HOST'].rtrim(str_replace("install.php", "", $_SERVER['SCRIPT_NAME']), "/");
			$flash['success'][] = "Installation has been completed!<br>Site: <b><a href=\"{$site}\">{$site}</a></b><br>
			Admin panel: <b><a href=\"{$site}/admin\">{$site}/admin</a></b><br>
			Login: admin<br>
			Password: admin<br>
			<b>DON'T FORGET TO CHANGE YOUR ADMIN LOGIN AND PASSWORD (<a href=\"{$site}/admin/settings/admin\">{$site}/admin/settings/admin</a>)</b>";
			$flash['notice'][] = "<b>Remove install.php file!</b>";
		}
	}
}
?>

<html>
<head>
<style type="text/css">
* {margin:0; padding:0; }

body {
	line-height:1.5;
	background:url(images/bg.png);
	font-family: Tahoma, Helvetica, Arial, Sans-Serif;
	height: 100%;
	font-size:14px;
}
a {
	color:#6AA500;
}
.install {
	font: 40px Tahoma, Helvetica, Arial, Sans-Serif;
	margin-left:50px;
	margin-top:50px;
	letter-spacing:2px;
	text-align: left;
	color: #cccccc;
	text-shadow: 1px 1px 1px #8c8c8c;
}

span.example {
	color:#8c8c8c;
	font-size:10px;
}

.wrapper {
	margin:20px 50px 50px 50px;
	width:800px;
	background-color:#F5F5F5;
	padding:20px;
}

h1.error_h {
	font-size:14px;
	color:#B80000;
	padding:0 20px 20px 20px;
}

.flash {
 position:relative;
 padding:10px;
 margin-bottom:20px;
}

.success {
	background-color: #F6FAF0;
	border: 1px solid #6AA500;
	color: #6AA500;
}

.error {
	background-color: #FBF0F0;
	border: 1px solid #B80000;
	color: #B80000;
}

.notice {
	background-color: #FEF9F1;
	border: 1px solid #ED9D12;
	color: #ED9D12;
}
label {
  float:left;
  width:25%;
  padding:5px;
  text-align:right;
}
input {
	padding:5px;
}

input[type=text]{
	border:1px solid #d3d3d3;
}

.row {
	clear:both;
	margin-bottom:5px;
}

.submit {
	margin-left:10px;
	margin-bottom:10px;
}

fieldset {
	border:1px solid #d3d3d3;
}

legend {
	margin: 0.2em 2.5em;
}
table, tr, td {
	border:1px solid #d3d3d3;
	font-size:12px;
}
table.requirements {
	border-collapse: collapse;
	border-spacing: 0;
	margin:20px;
	background-color:white
}
td {
	padding:5px;
}

</style>
<title>Installation</title>
</head>
<body>

<h1 class="install"><b>2  0  S  C  R  I  P  T  . I R</b><br>Installation</h1>
<div class="wrapper">

<? if (!empty($flash)): ?>
<? if(!empty($flash['error'])): ?>
<h1 class="error_h">Please fix the following errors</h1>
<? endif; ?>
<? foreach($flash as $k=>$v): ?>
<? foreach($v as $error) : ?>
<div class="flash <?= $k ?>">
<?= $error ?>
</div>
<? endforeach; ?>
<? endforeach; ?>
<? endif; ?>

<p>
Welcome to URL Shortener install page. Please fix the following notices if they are exists and fill MySQL settings.
After successful installation you will see site and admin panel URL addresses.
If you have trouble with installation process or something going wrong, please contact me <b>roman.codecanyon@gmail.com</b>
<br><br>
</p>

<fieldset>
<legend><b>Requirements</b></legend>
<table class="requirements">
<thead>
<tr>
<td>
Name
</td>
<td>
Result
</td>
</tr>
</thead>
<tbody>
<? foreach($requirements as $key=>$req):?>
<? $class = $key ? "success" : "failed" ?>
<tr class="<?= $class ?>">
<td>
<?= $key ?>
</td>
<td>
<?= $req ? "passed" : "failed"?>
</td>
</tr>
<? endforeach; ?>
</tbody>
</table>
<div class="flash notice" style="margin-left:20px;margin-right:20px;">Note. If your main index.php file located not in the root folder
- you need to add <b>RewriteBase /subfolder/</b> into .htaccess file after <b>RewriteEngine on</b></div>
</fieldset>

<br><br>

<form method="POST">
<fieldset>
<legend><b>MySQL Settings</b></legend>
<br>

<div class="row">
<label for="host">Hostname <span class="example">(ex. localhost)</span></label>
<input type="text" name="host" id="host" value="<?= _v($_POST, 'host') ?>" placeholder="localhost">
</div>

<div class="row">
<label for="user">Username <span class="example">(ex. root)</span></label>
<input type="text" name="user" id="user" value="<?= _v($_POST, 'user') ?>" placeholder="root">
</div>

<div class="row">
<label for="pw">Password <span class="example">(ex. qwerty)</span></label>
<input type="text" name="pw" id="pw" value="<?= _v($_POST, 'pw') ?>" placeholder="password">
</div>

<div class="row">
<label for="dbname">Database Name <span class="example">(ex. shortlink)</span></label>
<input type="text" name="dbname" id="dbname" value="<?= _v($_POST, 'dbname') ?>" placeholder="dbname">
</div>

<div class="row submit">
<input type="submit" name="install" id="Install" value="Install">
</div>

</fieldset>
</form>

</div>
</body>
</html>