<?php
class Basic extends CActiveRecord
{
	protected $basic = array();

	public function get($key)
	{
		static $grab = true;
		if($grab)
		{
			$this->basic = self::model()->find()->attributes;
			$grab = false;
		}
		return isset($this->basic[$key]) ? $this->basic[$key] : null;
	}

	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	public function tableName()
	{
		return '{{basic_settings}}';
	}

	public function rules()
	{
		return array(
			array('Title, Keywords, Description, BingID, GoogleID, YandexID, Banner, QR, JsScript, Redirect, SiteName, API_Request', 'safe'),
		);
	}

	public function attributeLabels()
	{
		return array(
			'QR'=>'QR Code',
			'JsScript'=>'Javascript Code',
			'Redirect'=>'Redirect Timer',
		);
	}
}